/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.smartsmodule.builder.internal;

import com.ibm.bi.platform.moser.common.generated.metadata.ItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.ObjectType;
import com.ibm.bi.platform.moser.common.generated.metadata.QueryItem;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import com.ibm.smarts.common.provider.IDataProviderModuleInfo;
import com.ibm.smarts.model.builder.ModuleInfo;
import com.ibm.smarts.schema.AnalysisScope;
import com.ibm.smarts.schema.InScopeTable;
import com.ibm.smarts.smartsmodule.builder.SmartsModuleBuilderSettings;
import com.ibm.smarts.smartsmodule.builder.exceptions.InvalidAnalysisScopeException;
import com.ibm.smarts.smartsmodule.builder.exceptions.MissingModuleInfoException;
import com.ibm.smarts.smartsmodule.builder.exceptions.SmartsBuilderException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ModulePreProcessor {
    private ModulePreProcessor() {
    }

    public static Module execute(ModuleInfo moduleInfo, SmartsModuleBuilderSettings settings) throws SmartsBuilderException {
        IDataProviderModuleInfo moduleProvider = settings.getDataProviderModuleInfo();
        Module module = moduleInfo.getModule();
        if (module == null) {
            String moduleURI = moduleInfo.getModuleUri();
            if (moduleURI == null) {
                throw new MissingModuleInfoException("Unable to get module as module information is missing");
            }
            if (moduleProvider == null) {
                throw new SmartsBuilderException("module provider not set");
            }
            module = moduleProvider.getModule(settings.getRequestContext(), moduleURI);
        }
        if (module == null) {
            throw new SmartsBuilderException("Can not locate Module " + moduleInfo.getModuleUri());
        }
        if (settings.getAnalysisScope() != null) {
            ModulePreProcessor.shrinkModule(module, settings.getAnalysisScope());
        }
        return module;
    }

    public static void shrinkModule(Module module, AnalysisScope analysisScope) throws SmartsBuilderException {
        if (analysisScope.getInScopeTables().isEmpty() && analysisScope.getOutScopeTables().isEmpty()) {
            return;
        }
        Set inScopeTableIds = analysisScope.getInScopeTables().stream().map(InScopeTable::getTableID).collect(Collectors.toSet());
        Set outScopeTableIds = analysisScope.getOutScopeTables().stream().map(InScopeTable::getTableID).collect(Collectors.toSet());
        Set querySubjectIds = module.getQuerySubject().stream().map(ObjectType::getIdentifier).collect(Collectors.toSet());
        if (!inScopeTableIds.isEmpty() && !querySubjectIds.containsAll(inScopeTableIds)) {
            throw new InvalidAnalysisScopeException("Invalid table ids in analysis scope");
        }
        Map<Object, Object> inScopedcolumnIdMap = new HashMap();
        Map<Object, Object> outScopedcolumnIdMap = new HashMap();
        if (!inScopeTableIds.isEmpty()) {
            module.getQuerySubject().removeIf(qs -> !inScopeTableIds.contains(qs.getIdentifier()));
            inScopedcolumnIdMap = analysisScope.getInScopeTables().stream().collect(Collectors.toMap(InScopeTable::getTableID, InScopeTable::getInScopeFieldIDs, (l1, l2) -> l1));
        }
        if (!outScopeTableIds.isEmpty()) {
            outScopedcolumnIdMap = analysisScope.getOutScopeTables().stream().collect(Collectors.toMap(InScopeTable::getTableID, InScopeTable::getInScopeFieldIDs, (l1, l2) -> l1));
            ListIterator qsIter = module.getQuerySubject().listIterator();
            while (qsIter.hasNext()) {
                QuerySubject qs2 = (QuerySubject)qsIter.next();
                if (!outScopeTableIds.contains(qs2.getIdentifier()) || !outScopedcolumnIdMap.getOrDefault(qs2.getIdentifier(), Collections.emptyList()).isEmpty()) continue;
                qsIter.remove();
            }
        }
        for (QuerySubject qs2 : module.getQuerySubject()) {
            HashSet<String> excludedColumnIds;
            List includedColumns = (List)inScopedcolumnIdMap.get(qs2.getIdentifier());
            List excludedColumns = (List)outScopedcolumnIdMap.get(qs2.getIdentifier());
            HashSet<String> includedColumnIds = includedColumns != null ? new HashSet<String>(includedColumns) : Collections.emptySet();
            HashSet<String> hashSet = excludedColumnIds = excludedColumns != null ? new HashSet<String>(excludedColumns) : Collections.emptySet();
            if (includedColumnIds.isEmpty() && excludedColumnIds.isEmpty()) continue;
            ListIterator iter = qs2.getItem().listIterator();
            while (iter.hasNext()) {
                ItemType item = (ItemType)iter.next();
                boolean res = ModulePreProcessor.retainApplicableItems(item, includedColumnIds, excludedColumnIds);
                if (res) continue;
                iter.remove();
            }
        }
    }

    private static boolean retainApplicableItems(ItemType item, Set<String> includedColumnIds, Set<String> excludedColumnIds) {
        List childItems;
        QueryItem rootQi;
        boolean keep = false;
        Object object = rootQi = item.getQueryItem() != null ? item.getQueryItem() : item.getNamedSet();
        if (rootQi != null) {
            if (includedColumnIds.contains(rootQi.getIdForExpression())) {
                return true;
            }
            if (excludedColumnIds.contains(rootQi.getIdForExpression())) {
                return false;
            }
        }
        if ((childItems = item.getFolder() != null ? item.getFolder().getItem() : (item.getQueryItem() != null ? item.getQueryItem().getItem() : (item.getNamedSet() != null ? item.getNamedSet().getItem() : Collections.emptyList()))).isEmpty() && includedColumnIds.isEmpty()) {
            keep = true;
        }
        ListIterator listIterator = childItems.listIterator();
        while (listIterator.hasNext()) {
            ItemType childItem = (ItemType)listIterator.next();
            boolean childKeep = ModulePreProcessor.retainApplicableItems(childItem, includedColumnIds, excludedColumnIds);
            if (childKeep) {
                keep = true;
                continue;
            }
            listIterator.remove();
        }
        return keep;
    }
}

