/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.common.utils;

import java.util.Date;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public class ResponseUtils {
    private ResponseUtils() {
    }

    public static Response getResponse(Response.Status status, Object entity) {
        if (entity == null) {
            return Response.status((Response.Status)status).build();
        }
        return Response.status((Response.Status)status).entity(entity).build();
    }

    public static Response getResponseNoStore(Response.Status status, Object entity) {
        CacheControl cc = new CacheControl();
        cc.setNoStore(true);
        if (entity == null) {
            return Response.status((Response.Status)status).cacheControl(cc).build();
        }
        return Response.status((Response.Status)status).cacheControl(cc).entity(entity).build();
    }

    public static Response getResponse(int status, Object entity) {
        if (entity == null) {
            return Response.status((int)status).build();
        }
        return Response.status((int)status).entity(entity).build();
    }

    public static Response getResponse(Response.Status status, Object entity, MediaType mediaType, String eTag, long lastModified) {
        Response.ResponseBuilder builder = Response.status((Response.Status)status).type(mediaType);
        if (entity != null) {
            builder = builder.entity(entity);
        }
        CacheControl cc = new CacheControl();
        cc.setMustRevalidate(true);
        cc.setPrivate(true);
        return builder.tag(eTag).lastModified(new Date(lastModified)).cacheControl(cc).build();
    }
}

