/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.combinations.generator.internal;

import com.ibm.smarts.core.exceptions.InternalException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class CombinationIterable<T>
implements Iterable<List<T>> {
    private final List<T> allElements;
    private final int combSize;

    public CombinationIterable(List<T> allElements, int combSize) {
        this.allElements = new ArrayList<T>(allElements);
        this.combSize = combSize;
    }

    @Override
    public Iterator<List<T>> iterator() {
        return new CombinationIterator<T>(this.allElements, this.combSize);
    }

    private static final class CombinationIterator<T>
    implements Iterator<List<T>> {
        private final List<T> allElements;
        private final int[] indices;
        private List<T> nextCombination;
        private final int currentCombinationSize;

        CombinationIterator(List<T> allElements, int currentCombinationSize) {
            if (currentCombinationSize > allElements.size()) {
                throw new InternalException("Combination size " + currentCombinationSize + " cannot be larger than the size of elements " + allElements.size(), new Object[0]);
            }
            if (currentCombinationSize <= 0) {
                throw new InternalException("Combination size " + currentCombinationSize + " has to be a positive integer", new Object[0]);
            }
            this.allElements = new ArrayList<T>(allElements);
            this.indices = new int[allElements.size()];
            this.currentCombinationSize = currentCombinationSize;
            if (!allElements.isEmpty()) {
                this.nextCombination = new ArrayList<T>(currentCombinationSize);
                for (int i = 0; i < currentCombinationSize; ++i) {
                    this.nextCombination.add(allElements.get(i));
                    this.indices[i] = i;
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextCombination != null;
        }

        @Override
        public List<T> next() {
            if (this.nextCombination == null) {
                throw new NoSuchElementException("No combinations left.");
            }
            List<T> combination = this.nextCombination;
            this.generateNextCombination();
            return combination;
        }

        private void loadCombination() {
            ArrayList<T> combination = new ArrayList<T>(this.currentCombinationSize);
            for (int i = 0; i < this.currentCombinationSize; ++i) {
                combination.add(this.allElements.get(this.indices[i]));
            }
            this.nextCombination = combination;
        }

        private void generateNextCombination() {
            if (this.indices[this.currentCombinationSize - 1] < this.indices.length - 1) {
                int n = this.currentCombinationSize - 1;
                this.indices[n] = this.indices[n] + 1;
                this.loadCombination();
                return;
            }
            for (int i = this.currentCombinationSize - 2; i >= 0; --i) {
                if (this.indices[i] >= this.indices[i + 1] - 1) continue;
                int n = i;
                this.indices[n] = this.indices[n] + 1;
                for (int j = i + 1; j < this.currentCombinationSize; ++j) {
                    this.indices[j] = this.indices[j - 1] + 1;
                }
                this.loadCombination();
                return;
            }
            this.nextCombination = null;
        }
    }
}

