/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.uima_annotator.cleanup;

import com.ibm.dltj.uima_annotator.flow.LrwCasCopier;
import com.ibm.langware.annotator.Copyright;
import com.ibm.langware.annotator.Messages;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.CasMultiplier_ImplBase;
import org.apache.uima.cas.AbstractCas;
import org.apache.uima.cas.CAS;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

@Copyright(value="\n\n(C) Copyright IBM Corp. 2006, 2013.\n\n")
public class TypeCleanupMultiplier
extends CasMultiplier_ImplBase {
    private String[] _discardTypes;
    private CAS _destCas;
    private Logger _logger;

    public void initialize(UimaContext uimaContext) throws ResourceInitializationException {
        super.initialize(uimaContext);
        this._logger = uimaContext.getLogger();
        this._discardTypes = (String[])uimaContext.getConfigParameterValue("DiscardTypes");
    }

    public void process(CAS cAS) {
        if (this._discardTypes == null || this._discardTypes.length == 0) {
            return;
        }
        this._destCas = this.getEmptyCAS();
        this._destCas.setDocumentText(cAS.getDocumentText());
        this._destCas.setDocumentLanguage(cAS.getDocumentLanguage());
        LrwCasCopier.copyAnnotationsWithDiscard(cAS, this._destCas, this._discardTypes);
    }

    public boolean hasNext() {
        this._logger.log(Level.INFO, Messages.getFormattedMessage("TypeCleanup.hasnext", this._destCas != null));
        return this._destCas != null;
    }

    public AbstractCas next() {
        CAS cAS = this._destCas;
        this._destCas = null;
        this._logger.log(Level.INFO, Messages.getFormattedMessage("TypeCleanup.next", cAS));
        return cAS;
    }
}

