/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.uima_annotator.entity_analysis;

import com.ibm.langware.annotator.Copyright;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.impl.LowLevelCAS;
import org.apache.uima.cas.impl.LowLevelIterator;
import org.apache.uima.cas.impl.LowLevelTypeSystem;

@Copyright(value="\n\n(C) Copyright IBM Corp. 2006, 2013.\n\n")
final class LowLevelSubIterator {
    private final LowLevelCAS _llCas;
    private final LowLevelIterator _llItr;
    private final LowLevelTypeSystem _llTypeSystem;
    private final BitSet _typeCodes = new BitSet();
    private final int _featureCodeBegin;
    private final int _featureCodeEnd;
    private int _begin = 0;
    private int _end = 0;
    private int _fsRef = 0;
    private int _fsLast = 0;
    private final boolean _ambiguous;

    private LowLevelSubIterator(CAS cAS, boolean bl) {
        assert (cAS != null);
        this._llCas = cAS.getLowLevelCAS();
        this._llItr = this._llCas.ll_getIndexRepository().ll_getIndex("AnnotationIndex").ll_iterator();
        this._llTypeSystem = this._llCas.ll_getTypeSystem();
        this._featureCodeBegin = this._llTypeSystem.ll_getCodeForFeatureName("uima.tcas.Annotation:begin");
        this._featureCodeEnd = this._llTypeSystem.ll_getCodeForFeatureName("uima.tcas.Annotation:end");
        assert (this._featureCodeBegin > 0);
        assert (this._featureCodeEnd > 0);
        this._ambiguous = bl;
    }

    LowLevelSubIterator(CAS cAS, Type type, boolean bl) {
        this(cAS, bl);
        TypeSystem typeSystem = cAS.getTypeSystem();
        Iterator iterator = typeSystem.getTypeIterator();
        while (iterator.hasNext()) {
            Type type2 = (Type)iterator.next();
            if (!typeSystem.subsumes(type, type2)) continue;
            this._typeCodes.set(this._llTypeSystem.ll_getCodeForType(type2));
        }
    }

    LowLevelSubIterator(CAS cAS, Type type) {
        this(cAS, type, true);
    }

    LowLevelSubIterator(CAS cAS, Collection<Type> collection, boolean bl) {
        this(cAS, bl);
        TypeSystem typeSystem = cAS.getTypeSystem();
        Iterator iterator = typeSystem.getTypeIterator();
        block0: while (iterator.hasNext()) {
            Type type = (Type)iterator.next();
            for (Type type2 : collection) {
                if (!typeSystem.subsumes(type2, type)) continue;
                this._typeCodes.set(this._llTypeSystem.ll_getCodeForType(type));
                continue block0;
            }
        }
    }

    LowLevelSubIterator(CAS cAS, Collection<Type> collection) {
        this(cAS, collection, true);
    }

    boolean isValid() {
        return this._fsRef > 0;
    }

    int ll_get() throws NoSuchElementException {
        if (this._fsRef > 0) {
            return this._fsRef;
        }
        throw new NoSuchElementException();
    }

    void moveTo(int n) {
        this.moveTo(this._llCas.ll_getIntValue(n, this._featureCodeBegin), this._llCas.ll_getIntValue(n, this._featureCodeEnd));
    }

    void moveTo(int n, int n2) {
        assert (0 <= n && n <= n2);
        this._begin = n;
        this._end = n2;
        this._fsRef = 0;
        this._fsLast = 0;
        if (!this._llItr.isValid()) {
            this._llItr.moveToLast();
        }
        while (this._llItr.isValid()) {
            int n3 = this._llItr.ll_get();
            int n4 = this._llCas.ll_getIntValue(n3, this._featureCodeBegin);
            if (n4 < this._begin && this._typeCodes.get(this._llCas.ll_getFSRefType(n3))) {
                this._fsRef = n3;
                break;
            }
            this._llItr.moveToPrevious();
        }
        if (!this._llItr.isValid()) {
            this._llItr.moveToFirst();
        }
        this.forward();
    }

    void moveToNext() {
        this._fsRef = 0;
        this._llItr.moveToNext();
        this.forward();
    }

    private void forward() {
        while (this._llItr.isValid()) {
            int n = this._llItr.ll_get();
            int n2 = this._llCas.ll_getIntValue(n, this._featureCodeBegin);
            int n3 = this._llCas.ll_getIntValue(n, this._featureCodeEnd);
            if (this._end < n2) {
                return;
            }
            if (this._begin <= n2 && n3 <= this._end && this._typeCodes.get(this._llCas.ll_getFSRefType(n)) && (this._ambiguous || this._fsLast <= n2)) {
                this._fsRef = n;
                this._fsLast = this._llCas.ll_getIntValue(this._fsRef, this._featureCodeBegin);
                return;
            }
            this._llItr.moveToNext();
        }
    }
}

