/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ca.core.impl.contentrecommender;

import com.ibm.smarts.ca.core.impl.contentrecommender.AnalysisType;
import com.ibm.smarts.ca.core.impl.contentrecommender.Artifact;
import com.ibm.smarts.ca.core.impl.contentrecommender.Context;
import com.ibm.smarts.common.util.CommonJAXBHelper;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentRecommenderRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContentRecommenderRequest.class);
    private String sourceModuleId;
    private String sourceModule;
    private String sourceModuleURI;
    private String sourceType;
    private Context context;
    private AnalysisType analysisType;
    private boolean includePredictiveCharts;
    private List<String> includedColumns;
    private List<String> excludedColumns;
    private List<Artifact> includedArtifacts;
    private List<Artifact> excludedArtifacts;
    private int maxCombinationLength;

    public String getSourceModuleId() {
        return this.sourceModuleId;
    }

    public void setSourceModuleId(String sourceModuleId) {
        this.sourceModuleId = sourceModuleId;
    }

    public String getSourceModule() {
        return this.sourceModule;
    }

    public void setSourceModule(String sourceModule) {
        this.sourceModule = sourceModule;
    }

    public String getSourceModuleURI() {
        return this.sourceModuleURI;
    }

    public void setSourceModuleURI(String sourceModuleURI) {
        this.sourceModuleURI = sourceModuleURI;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public AnalysisType getAnalysisType() {
        return this.analysisType;
    }

    public void setAnalysisType(AnalysisType analysisType) {
        this.analysisType = analysisType;
    }

    public boolean isIncludePredictiveCharts() {
        return this.includePredictiveCharts;
    }

    public void setIncludePredictiveCharts(boolean includePredictiveCharts) {
        this.includePredictiveCharts = includePredictiveCharts;
    }

    public List<String> getIncludedColumns() {
        return this.includedColumns;
    }

    public void setIncludedColumns(List<String> includedColumns) {
        this.includedColumns = includedColumns;
    }

    public List<String> getExcludedColumns() {
        return this.excludedColumns;
    }

    public void setExcludedColumns(List<String> excludedColumns) {
        this.excludedColumns = excludedColumns;
    }

    public List<Artifact> getIncludedArtifacts() {
        return this.includedArtifacts;
    }

    public void setIncludedArtifacts(List<Artifact> includedArtifacts) {
        this.includedArtifacts = includedArtifacts;
    }

    public List<Artifact> getExcludedArtifacts() {
        return this.excludedArtifacts;
    }

    public void setExcludedArtifacts(List<Artifact> excludedArtifacts) {
        this.excludedArtifacts = excludedArtifacts;
    }

    public int getMaxCombinationLength() {
        return this.maxCombinationLength;
    }

    public void setMaxCombinationLength(int maxCombinationLength) {
        this.maxCombinationLength = maxCombinationLength;
    }

    public String toJSON() {
        return CommonJAXBHelper.marshalToJSON((Object)this, (boolean)true);
    }

    public String toString() {
        return "ContentRecommenderRequest{sourceModuleId='" + this.sourceModuleId + '\'' + ", sourceModule='" + this.sourceModule + '\'' + ", sourceModuleURI='" + this.sourceModuleURI + '\'' + ", sourceType='" + this.sourceType + '\'' + ", context=" + this.context + ", analysisType=" + (Object)((Object)this.analysisType) + ", includePredictiveCharts=" + this.includePredictiveCharts + ", includedColumns=" + this.includedColumns + ", excludedColumns=" + this.excludedColumns + ", includedArtifacts=" + this.includedArtifacts + ", excludedArtifacts=" + this.excludedArtifacts + '}';
    }

    public static class Builder {
        private String sourceModuleId;
        private String sourceModule;
        private String sourceModuleURI;
        private String sourceType;
        private Context context;
        private AnalysisType analysisType;
        private boolean includePredictiveCharts;
        private List<String> includedColumns;
        private List<String> excludedColumns;
        private List<Artifact> includedArtifacts;
        private List<Artifact> excludedArtifacts;
        private int maxCombinationLength;

        public Builder(ModuleAccess access, String module) {
            switch (access) {
                case MODULE_ID: {
                    this.sourceModuleId = module;
                    break;
                }
                case MODULE_URI: {
                    this.sourceModuleURI = module;
                    break;
                }
                case MODULE_JSON: {
                    this.sourceModule = module;
                }
            }
        }

        public ContentRecommenderRequest request() {
            ContentRecommenderRequest request = new ContentRecommenderRequest();
            request.setSourceModuleId(this.sourceModuleId);
            request.setSourceModule(this.sourceModule);
            request.setSourceModuleURI(this.sourceModuleURI);
            request.setSourceType(this.sourceType);
            request.setContext(this.context);
            request.setAnalysisType(this.analysisType);
            request.setIncludePredictiveCharts(this.includePredictiveCharts);
            request.setIncludedArtifacts(this.includedArtifacts);
            request.setExcludedArtifacts(this.excludedArtifacts);
            request.setIncludedColumns(this.includedColumns);
            request.setExcludedColumns(this.excludedColumns);
            request.setMaxCombinationLength(this.maxCombinationLength);
            return request;
        }

        public Builder sourceModuleId(String sourceModuleId) {
            this.sourceModuleId = sourceModuleId;
            return this;
        }

        public Builder sourceModule(String sourceModule) {
            this.sourceModule = sourceModule;
            return this;
        }

        public Builder sourceModuleURI(String sourceModuleURI) {
            this.sourceModuleURI = sourceModuleURI;
            return this;
        }

        public Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public Builder context(Context context) {
            this.context = context;
            return this;
        }

        public Builder analysisType(AnalysisType analysisType) {
            this.analysisType = analysisType;
            return this;
        }

        public Builder includePredictiveCharts(Boolean includePredictiveCharts) {
            this.includePredictiveCharts = includePredictiveCharts;
            return this;
        }

        public Builder includedArtifacts(List<Artifact> includedArtifacts) {
            this.includedArtifacts = includedArtifacts;
            return this;
        }

        public Builder excludedArtifacts(List<Artifact> excludedArtifacts) {
            this.excludedArtifacts = excludedArtifacts;
            return this;
        }

        public Builder includedColumns(List<String> includedColumns) {
            this.includedColumns = includedColumns;
            return this;
        }

        public Builder excludedColumns(List<String> excludedColumns) {
            this.excludedColumns = excludedColumns;
            return this;
        }

        public Builder maxCombinationLength(int maxCombinationLength) {
            this.maxCombinationLength = maxCombinationLength;
            return this;
        }
    }

    public static enum ModuleAccess {
        MODULE_ID,
        MODULE_URI,
        MODULE_JSON;

    }
}

