/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ca.core.impl.dashboardgenerator;

import com.ibm.smarts.ca.core.impl.dashboardgenerator.GenerateDashboardRequest;
import com.ibm.smarts.ca.core.impl.dashboardgenerator.GenerateDashboardResponse;
import com.ibm.smarts.ca.core.rest.client.CaRestClient;
import com.ibm.smarts.core.rest.client.RestClient;
import com.ibm.smarts.core.util.RequestContext;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

public class CaDashboardGeneratorClient
extends CaRestClient {
    public CaDashboardGeneratorClient(RestClient.RestCallContextFactory rccf, RequestContext requestContext, String uri) {
        super(rccf, requestContext, uri);
    }

    public GenerateDashboardResponse generate(GenerateDashboardRequest request) {
        try {
            return this.generateAsync(request).get();
        }
        catch (InterruptedException | ExecutionException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    private CompletableFuture<GenerateDashboardResponse> generateAsync(GenerateDashboardRequest request) {
        String path = Paths.generatePath();
        return this.generateAsync(path, request.toJSON()).thenApply(GenerateDashboardResponse::fromJSON);
    }

    private CompletableFuture<String> generateAsync(String path, String request) {
        return this.postAsync(path, request);
    }

    private static class Paths {
        private static final String DASHBOARD_GENERATOR = "/bi/v1/smarts/dashboard-generator";
        private static final String GENERATE = "/bi/v1/smarts/dashboard-generator/generate";

        private Paths() {
        }

        private static String generatePath() {
            return GENERATE;
        }
    }
}

