/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ca.core.impl.dashboardgenerator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.ibm.smarts.common.util.CommonJAXBHelper;
import com.ibm.smarts.core.exceptions.json.JsonDeserializeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum SmartsStatus {
    OK(0, "The request was completed successfully"),
    NO_SMARTS_MODULE_SPECIFIED(1, "No smarts module specified"),
    SMARTS_MODULE_NOT_FOUND(2, "Smarts module not found"),
    SMARTS_MODULE_TIMEOUT(3, "Smarts module timeout"),
    JSON_ERROR_IN_INPUT(4, "JSON error in input"),
    RECOMMENDER_TIMEOUT(5, "Timed out generating recommendations"),
    MISSING_REQUIRED_PARAMETERS(6, "One of sourceModuleId, sourceModuleURI or sourceModule must be specified"),
    SMARTS_MODULE_NOT_READY(7, "Smarts module not ready"),
    NO_MEASURE_NO_RESULTS(8, "No suitable measure column was found to create content."),
    GENERAL_NO_RESULTS(9, "No suitable results were found to create content."),
    ERROR(100, "We were unable to process your request due to an unknown error");

    private static final Logger LOGGER;
    private final int value;
    private String details;

    @JsonCreator
    private SmartsStatus(int value, String details) {
        this.value = value;
        this.details = details;
    }

    public int getValue() {
        return this.value;
    }

    public String getDetails() {
        return this.details;
    }

    public static SmartsStatus fromJSON(String str) {
        try {
            return (SmartsStatus)((Object)CommonJAXBHelper.unmarshalFromJSON(SmartsStatus.class, (String)str));
        }
        catch (JsonDeserializeException e) {
            LOGGER.error("Unable to deserialize JSON in the SmartsStatus class", (Throwable)e);
            return null;
        }
    }

    public String toJSON() {
        return CommonJAXBHelper.marshalToJSON((Object)((Object)this), (boolean)true);
    }

    static {
        LOGGER = LoggerFactory.getLogger(SmartsStatus.class);
    }
}

