/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ca.core.rest.server;

import com.ibm.bi.config.ConfigurationPropertyFactory;
import com.ibm.bi.config.util.ConfigurationUtils;
import com.ibm.bi.rest.RESTClientFactory;
import com.ibm.smarts.ca.core.impl.SmartsCaClientManager;
import com.ibm.smarts.ca.core.rest.client.BIRestCallContext;
import com.ibm.smarts.ca.core.rest.client.BIRestCallContextFactory;
import com.ibm.smarts.ca.core.rest.client.BIRestClientConfigInfo;
import com.ibm.smarts.ca.core.rest.client.CaRestClient;
import com.ibm.smarts.ca.core.rest.client.SmartsCaRestClientHelper;
import com.ibm.smarts.ca.core.rest.server.SmartsCaCoreHandlers;
import com.ibm.smarts.ca.core.rest.server.handlers.SmartsCaCoreBaseRestApi;
import com.ibm.smarts.core.config.SmartsCaProps;
import com.ibm.smarts.core.exceptions.InternalException;
import com.ibm.smarts.core.rest.client.RestClient;
import com.ibm.smarts.core.rest.server.AbstractRestServiceContextListener;
import com.ibm.smarts.core.util.ConfigUtil;
import com.ibm.smarts.core.util.ObjectCreator;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.core.util.ToString;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.servlet.ServletContextEvent;
import javax.servlet.annotation.WebListener;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.NewCookie;

@WebListener
public class AbstractCaRestServiceContextListener
extends AbstractRestServiceContextListener {
    protected static RestClient.RestCallContextFactory systemRccf = null;
    protected static Properties caConfig = null;
    private boolean nextRestCallNoTrustedId = false;

    private <T> T executeInCaNoIdentity(Function<RequestContext, T> func) {
        LocalCaHandlerRunner runner = new LocalCaHandlerRunner();
        T ret = runner.executeInCaNoIdentity(systemRequestContext, func);
        return ret;
    }

    public void contextInitialized(ServletContextEvent event) {
        systemLogger.info("Initializing Smarts in CA...");
        super.contextInitialized(event);
        String caServerInstallDir = ConfigurationUtils.getInstallRoot();
        String internalDispatcherUrl = ConfigurationPropertyFactory.getInstance().getStringProperty("internalDispatcher", null).get();
        String caTempFolder = ConfigurationPropertyFactory.getInstance().getStringProperty("temp", null).get();
        String caLogsFolder = caServerInstallDir + File.separator + "logs";
        String caConfigPath = caServerInstallDir + File.separator + "configuration" + File.separator + "smarts";
        String caTempPath = caTempFolder + File.separator + "smarts";
        String caLogsPath = caLogsFolder + File.separator + "smarts";
        caConfig = new Properties();
        caConfig.setProperty("smarts.ca.core.installDir", caServerInstallDir);
        caConfig.setProperty("smarts.ca.core.caServer.url", AbstractCaRestServiceContextListener.getBaseUrl(internalDispatcherUrl));
        caConfig.setProperty("smarts.core.configFolder", caConfigPath);
        caConfig.setProperty("smarts.core.tempFolder", caTempPath);
        caConfig.setProperty("smarts.core.logsFolder", caLogsPath);
        caConfig.setProperty("smarts.core.performance.logging", "false");
        caConfig.setProperty("smarts.core.column.embedding", "true");
        caConfig.setProperty("smarts.core.question.generator", "true");
        SmartsCaCoreBaseRestApi.setStaticCaConfig(caConfig);
    }

    public static Properties resolveProperties(Properties config) {
        String propertiesFileName = "smarts.ca.properties";
        String caConfigPath = config.getProperty("smarts.core.configFolder");
        Path propertiesPath = Paths.get(caConfigPath + File.separator + "smarts.ca.properties", new String[0]);
        Properties mergedConfig = ConfigUtil.mergeProps((Properties[])new Properties[]{config, SmartsCaProps.getDefaultConfig()});
        if (Files.exists(propertiesPath, new LinkOption[0])) {
            try (FileInputStream input = new FileInputStream(propertiesPath.toFile());){
                mergedConfig.load(input);
                systemLogger.info("Total number of properties after load: " + mergedConfig.size() + ".");
            }
            catch (IOException e) {
                systemLogger.info("Could not load smarts.ca.properties. Using system defaults.");
            }
        } else {
            systemLogger.info("smarts.ca.properties not found. Using system defaults.");
        }
        return mergedConfig;
    }

    private static String getBaseUrl(String fullUrl) {
        try {
            URL url = new URL(fullUrl);
            String ret = url.getProtocol() + "://" + url.getHost() + ":" + url.getPort();
            return ret;
        }
        catch (MalformedURLException e) {
            throw new InternalException((Throwable)e, "Parsing URL " + ToString.valueString((Object)fullUrl), new Object[0]);
        }
    }

    protected String getTrustedServiceId() {
        return null;
    }

    protected BIRestClientConfigInfo buildBiRestConfig(Properties config) {
        URL url;
        String urlStr = config.getProperty("smarts.ca.core.caServer.url");
        try {
            url = new URL(urlStr);
        }
        catch (MalformedURLException e) {
            throw new InternalException((Throwable)e, "Invalid BI host URL: " + urlStr, new Object[0]);
        }
        String scheme = url.getProtocol();
        String host = url.getHost();
        int port = url.getPort();
        String context = url.getPath();
        BIRestClientConfigInfo ret = new BIRestClientConfigInfo(context, scheme, host, port, null);
        return ret;
    }

    protected void buildSystemRccf(final BIRestClientConfigInfo restConfig) {
        final Supplier<String> trustedIdSupplier = () -> {
            String ret;
            if (this.nextRestCallNoTrustedId) {
                this.nextRestCallNoTrustedId = false;
                ret = null;
            } else {
                ret = this.getTrustedServiceId();
            }
            return ret;
        };
        BIRestCallContextFactory rccf = new BIRestCallContextFactory(restConfig){

            @Override
            public <T> RestClient.RestCallContext<T> buildRestCallContext(RequestContext requestContext, Class<T> klass, RestClient.MeasuredFuture<T> mf, String root, String path, RestClient.QueryParams params, MediaType mediaType, Map<String, List<String>> headers, Map<String, NewCookie> setCookies) {
                BIRestClientConfigInfo c = SmartsCaRestClientHelper.getConfigFromRequestContext(systemRequestContext);
                if (c == null) {
                    c = restConfig;
                }
                BIRestCallContext<T> ret = new BIRestCallContext<T>(requestContext, klass, RESTClientFactory.getInstance(), c, mf, root, path, params, mediaType, headers, setCookies, (String)trustedIdSupplier.get());
                return ret;
            }
        };
        systemRccf = rccf;
        systemRequestContext.setAttribute("com.ibm.smarts.rest.restCallContextFactory", (Object)systemRccf);
        SmartsCaRestClientHelper.setConfigIntoRequestContext(restConfig, systemRequestContext);
    }

    protected void waitForDispatcherReady(String caHostUrl) {
        systemLogger.info("Waiting for dispatcher ready...");
        AtomicBoolean stopLoop = new AtomicBoolean(false);
        while (!stopLoop.get()) {
            try {
                this.executeInCaNoIdentity(context -> {
                    ObjectCreator creator = (ObjectCreator)context.getRequestAttribute("com.ibm.smarts.rest.clientManager");
                    if (creator == null) {
                        throw new InternalException("Rest client manager not found in request context at 'com.ibm.smarts.rest.clientManager': requestContext=" + context, new Object[0]);
                    }
                    try (SmartsCaClientManager clientManager = (SmartsCaClientManager)((Object)((Object)creator.create(context)));){
                        CaRestClient client = clientManager.getCaClient(caHostUrl);
                        boolean dispatcherReady = client.isDispatcherReady();
                        if (dispatcherReady) {
                            systemLogger.info("Dispatcher is ready.");
                            this.setXsrfHeader(caHostUrl);
                        }
                        stopLoop.set(dispatcherReady);
                    }
                    catch (IOException e) {
                        systemLogger.error("Failed to close CA REST client manager", (Throwable)e);
                    }
                    return null;
                });
                Thread.sleep(30000L);
            }
            catch (Throwable th) {
                stopLoop.set(true);
                throw new InternalException(th, "Failed to wait for dispatcher", new Object[0]);
            }
        }
    }

    private void setXsrfHeader(String caHostUrl) {
        systemLogger.info("Getting XSRF headers from CA...");
        this.executeInCaNoIdentity(context -> {
            ObjectCreator creator = (ObjectCreator)context.getRequestAttribute("com.ibm.smarts.rest.clientManager");
            if (creator == null) {
                throw new InternalException("Rest client manager not found in request context at 'com.ibm.smarts.rest.clientManager': requestContext=" + context, new Object[0]);
            }
            try (SmartsCaClientManager clientManager = (SmartsCaClientManager)((Object)((Object)creator.create(context)));){
                CaRestClient client = clientManager.getCaClient(caHostUrl);
                this.nextRestCallNoTrustedId = true;
                Map<String, List<String>> headers = client.pingCa();
                if (headers != null) {
                    List<String> cookieHeaders;
                    List<String> xsrfHeaders = headers.get("X-XSRF-TOKEN");
                    if (xsrfHeaders != null && xsrfHeaders.size() > 0) {
                        String xsrfHeader = xsrfHeaders.get(0);
                        BIRestClientConfigInfo configOrig = SmartsCaRestClientHelper.getConfigFromRequestContext(context);
                        BIRestClientConfigInfo configNew = new BIRestClientConfigInfo(configOrig);
                        configNew.headers.put("X-XSRF-TOKEN", Arrays.asList(xsrfHeader));
                        SmartsCaRestClientHelper.setConfigIntoRequestContext(configNew, context);
                    }
                    if ((cookieHeaders = headers.get("Cookie")) != null && cookieHeaders.size() > 0) {
                        String cookieHeader = cookieHeaders.get(0);
                        BIRestClientConfigInfo configOrig = SmartsCaRestClientHelper.getConfigFromRequestContext(context);
                        BIRestClientConfigInfo configNew = new BIRestClientConfigInfo(configOrig);
                        configNew.headers.put("Cookie", Arrays.asList(cookieHeader));
                        SmartsCaRestClientHelper.setConfigIntoRequestContext(configNew, context);
                    }
                }
                Map<String, List<String>> map = headers;
                return map;
            }
            catch (IOException e) {
                throw new InternalException((Throwable)e, "Failed to close CA REST client manager", new Object[0]);
            }
        });
    }

    public void contextDestroyed(ServletContextEvent event) {
        super.contextDestroyed(event);
    }

    private static class LocalCaHandlerRunner
    implements SmartsCaCoreHandlers {
        private LocalCaHandlerRunner() {
        }

        public <T> T executeInCaNoIdentity(RequestContext rc, Function<RequestContext, T> func) {
            T ret = this.handle(rc, func);
            return ret;
        }

        @Override
        public Properties getCaConfig() {
            return caConfig;
        }
    }
}

