/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.simpleNlg;

public class NLGNumbers {
    public static final String HUNDRED = "hundred";
    public static final String THOUSAND = "thousand";
    public static final String MILLION = "million";
    public static final String BILLION = "billion";
    static final String[] table = new String[]{"zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten", "eleven", "twelve", "thirteen", "fourteen", "fifteen", "sixteen", "seventeen", "eighteen", "nineteen", "twenty", "twenty-one", "twenty-two", "twenty-three", "twenty-four", "twenty-five", "twenty-six", "twenty-seven", "twenty-eight", "twenty-nine", "thirty", "thirty-one", "thirty-two", "thirty-three", "thirty-four", "thirty-five", "thirty-six", "thirty-seven", "thirty-eight", "thirty-nine", "forty", "forty-one", "forty-two", "forty-three", "forty-four", "forty-five", "forty-six", "forty-seven", "forty-eight", "forty-nine", "fifty", "fifty-one", "fifty-two", "fifty-three", "fifty-four", "fifty-five", "fifty-six", "fifty-seven", "fifty-eight", "fifty-nine", "sixty", "sixty-one", "sixty-two", "sixty-three", "sixty-four", "sixty-five", "sixty-six", "sixty-seven", "sixty-eight", "sixty-nine", "seventy", "seventy-one", "seventy-two", "seventy-three", "seventy-four", "seventy-five", "seventy-six", "seventy-seven", "seventy-eight", "seventy-nine", "eighty", "eighty-one", "eighty-two", "eighty-three", "eighty-four", "eighty-five", "eighty-six", "eighty-seven", "eighty-eight", "eighty-nine", "ninety", "ninety-one", "ninety-two", "ninety-three", "ninety-four", "ninety-five", "ninety-six", "ninety-seven", "ninety-eight", "ninety-nine"};

    public static String getBase10Word(long number) {
        int numDigitsInNumber = NLGNumbers.getNumDigits(number);
        switch (numDigitsInNumber) {
            case 3: {
                return HUNDRED;
            }
            case 4: 
            case 5: 
            case 6: {
                return THOUSAND;
            }
            case 7: 
            case 8: 
            case 9: {
                return MILLION;
            }
            case 10: 
            case 11: 
            case 12: {
                return BILLION;
            }
        }
        return "";
    }

    public static int getNumDigits(long number) {
        return (int)Math.log10(number) + 1;
    }

    public static long getBase10X(long number, int index) {
        return (long)Math.pow(10.0, NLGNumbers.getNumDigits(number) - index - 1);
    }

    public static long popDigits(long number, int n) {
        return number % NLGNumbers.getBase10X(number, n);
    }
}

