/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.simpleNlg;

import com.ibm.smarts.simpleNlg.NLGNumbers;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import simplenlg.framework.DocumentElement;
import simplenlg.framework.InflectedWordElement;
import simplenlg.framework.LexicalCategory;
import simplenlg.framework.NLGElement;
import simplenlg.framework.NLGFactory;
import simplenlg.framework.WordElement;
import simplenlg.lexicon.Lexicon;
import simplenlg.phrasespec.NPPhraseSpec;
import simplenlg.phrasespec.SPhraseSpec;
import simplenlg.realiser.english.Realiser;

public class NLGUtilities {
    private static String[] numbersTable = NLGNumbers.table;
    private static Lexicon lexicon = Lexicon.getDefaultLexicon();
    private static Realiser realiser = new Realiser(lexicon);
    private static NLGFactory nlgFactory = new NLGFactory(lexicon);

    private static InflectedWordElement getPluralWordElement(String word, LexicalCategory category) {
        InflectedWordElement pluralWord = NLGUtilities.getWordElement(word, category);
        pluralWord.setPlural(true);
        return pluralWord;
    }

    private static InflectedWordElement getWordElement(String word, LexicalCategory category) {
        WordElement nlgWord = lexicon.getWord(word, category);
        return new InflectedWordElement(nlgWord);
    }

    public static String plural(long val, String word) {
        if (val != 1L) {
            return realiser.realise((NLGElement)NLGUtilities.getPluralWordElement(word, LexicalCategory.NOUN)).getRealisation();
        }
        return word;
    }

    public static String plural(long val, String word, String category) {
        InflectedWordElement wordElement = NLGUtilities.getPluralWordElement(word, LexicalCategory.valueOf((String)category));
        if (val == 1L) {
            wordElement.setPlural(false);
        }
        return realiser.realise((NLGElement)wordElement).getRealisation();
    }

    public static String pickRandomly(String ... phrases) {
        return NLGUtilities.pickRandomly(ThreadLocalRandom.current(), phrases);
    }

    public static String pickRandomly(Random random, String ... phrases) {
        if (phrases == null) {
            return "";
        }
        if (phrases.length == 1) {
            return phrases[0];
        }
        return phrases[random.nextInt(phrases.length)];
    }

    public static String prettify(String sentence) {
        DocumentElement s1 = nlgFactory.createSentence(sentence);
        return realiser.realiseSentence((NLGElement)s1);
    }

    public static String numberToText(long number, long ceiling, String pre) {
        long rest;
        long determiner;
        if (number < 0L) {
            return Long.toString(number);
        }
        int numDigitsInNumber = NLGNumbers.getNumDigits(number);
        switch (numDigitsInNumber) {
            case 1: 
            case 2: {
                return numbersTable[(int)number];
            }
            case 3: 
            case 4: 
            case 7: 
            case 10: {
                determiner = number / NLGNumbers.getBase10X(number, 0);
                rest = NLGNumbers.popDigits(number, 0);
                break;
            }
            case 5: 
            case 8: 
            case 11: {
                determiner = number / NLGNumbers.getBase10X(number, 1);
                rest = NLGNumbers.popDigits(number, 1);
                break;
            }
            case 6: 
            case 9: 
            case 12: {
                determiner = number / NLGNumbers.getBase10X(number, 2);
                rest = NLGNumbers.popDigits(number, 2);
                break;
            }
            default: {
                return Long.toString(number);
            }
        }
        StringBuilder builder = new StringBuilder();
        if (ceiling >= 0L && ceiling < number) {
            builder.append(pre);
        }
        builder.append(NLGUtilities.numberToText(determiner));
        builder.append(" ");
        builder.append(NLGNumbers.getBase10Word(number));
        if ((ceiling == -1L || ceiling > number) && rest > 0L) {
            builder.append(" ");
            builder.append(NLGUtilities.numberToText(rest));
        }
        return builder.toString();
    }

    public static String numberToText(long number, long ceiling) {
        return NLGUtilities.numberToText(number, ceiling, "~");
    }

    public static String numberToText(long number) {
        return NLGUtilities.numberToText(number, -1L);
    }

    public static String list(String[] list, String delim, String endSep) {
        StringBuilder builder = new StringBuilder();
        if (list != null) {
            if (list.length == 1) {
                return list[0];
            }
            builder.append(list[0]);
            if (list.length > 2) {
                for (int i = 1; i < list.length - 1; ++i) {
                    builder.append(delim);
                    builder.append(list[i]);
                }
            }
            builder.append(endSep);
            builder.append(list[list.length - 1]);
        }
        return builder.toString();
    }

    public static String determiner(String det, String subj, long count) {
        if (count > 1L) {
            return subj;
        }
        return NLGUtilities.determiner(det, subj);
    }

    public static String determiner(String det, String subj) {
        SPhraseSpec sentence = nlgFactory.createClause();
        NPPhraseSpec subject = nlgFactory.createNounPhrase((Object)det, (Object)subj);
        sentence.setSubject((Object)subject);
        return realiser.realise((NLGElement)sentence).getRealisation();
    }
}

