/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.model.qg;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ibm.smarts.model.qg.TokenType;
import java.util.Objects;

public class Token {
    private TokenType tokenType;
    private int startCharIndex;
    private int endCharIndex;
    private String text;

    @JsonCreator
    public Token(@JsonProperty(value="tokenType") TokenType tokenType, @JsonProperty(value="startCharIndex") int startCharIndex, @JsonProperty(value="text") String text) {
        this.tokenType = tokenType;
        this.text = text;
        this.setStartCharIndex(startCharIndex);
    }

    public TokenType getTokenType() {
        return this.tokenType;
    }

    public int getStartCharIndex() {
        return this.startCharIndex;
    }

    public void setStartCharIndex(int startCharIndex) {
        this.startCharIndex = startCharIndex;
        this.endCharIndex = this.text == null ? startCharIndex : this.startCharIndex + this.text.length();
    }

    public int getEndCharIndex() {
        return this.endCharIndex;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Token token = (Token)o;
        return this.startCharIndex == token.startCharIndex && this.endCharIndex == token.endCharIndex && Objects.equals(this.text, token.text);
    }

    public int hashCode() {
        return Objects.hash(this.startCharIndex, this.endCharIndex, this.text);
    }
}

