/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.schema.util;

import com.ibm.smarts.model.builder.ColumnEmbedding;
import com.ibm.smarts.model.builder.QGEncodedSamples;
import com.ibm.smarts.model.builder.SmartsModuleOptions;
import com.ibm.smarts.model.qg.Question;
import com.ibm.smarts.schema.AnalysisStateType;
import com.ibm.smarts.schema.BaseItemObject;
import com.ibm.smarts.schema.BaseObject;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.ConceptInfo;
import com.ibm.smarts.schema.DatasetInfo;
import com.ibm.smarts.schema.DatasetType;
import com.ibm.smarts.schema.ItemType;
import com.ibm.smarts.schema.ObjectFactory;
import com.ibm.smarts.schema.PropertyType;
import com.ibm.smarts.schema.SemanticInfo;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.schema.SourceCategoryType;
import com.ibm.smarts.schema.Statistic;
import com.ibm.smarts.schema.util.JAXBHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartsModuleUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmartsModuleUtil.class);
    public static final String GLOBAL_CALCULATIONS = "_global_calculations";
    public static final String GLOBAL_NAMEDSETS = "_global_namedSets";
    public static final String COLUMN_EMBEDDING = "ColumnEmbedding";
    public static final String UPGRADE_FLAG = "_SmartsModuleUpgrade";
    public static final String UPGRADE_MESSAGE = "SmartsModule version has been upgraded to 1.2";
    public static final String QUESTIONS = "Questions";
    public static final String PK_COLUMN = "PK";
    public static final String FK_COLUMN = "FK";
    public static final String PACKAGE = "package";
    public static final String COLUMN_EMBEDDING_VERSION_KEY = "column-embedding-Version";

    public static List<ColumnInfo> getFlattenedColumns(ItemType item) {
        ArrayList<ColumnInfo> columns = new ArrayList<ColumnInfo>();
        SmartsModuleUtil.getFlattenedColumns(columns, item);
        return columns;
    }

    public static List<ColumnInfo> getFlattenedColumns(BaseItemObject itemObject) {
        ArrayList<ColumnInfo> columns = new ArrayList<ColumnInfo>();
        SmartsModuleUtil.getFlattenedColumns(columns, itemObject);
        return columns;
    }

    public static void getFlattenedColumns(List<ColumnInfo> columns, ItemType item) {
        BaseItemObject column = null;
        if (item.getColumn() != null) {
            column = item.getColumn();
        } else if (item.getFolder() != null) {
            column = item.getFolder();
        } else {
            return;
        }
        SmartsModuleUtil.getFlattenedColumns(columns, column);
    }

    public static void getFlattenedColumns(List<ColumnInfo> columns, BaseItemObject itemObject) {
        if (itemObject instanceof ColumnInfo) {
            columns.add((ColumnInfo)itemObject);
        }
        if (itemObject != null) {
            itemObject.getItem().forEach(item -> SmartsModuleUtil.getFlattenedColumns(columns, item));
        }
    }

    public static List<ItemType.Folder> getFlattenedFolders(BaseItemObject itemObject) {
        ArrayList<ItemType.Folder> folders = new ArrayList<ItemType.Folder>();
        SmartsModuleUtil.getFlattenedFolders(folders, itemObject);
        return folders;
    }

    public static void getFlattenedFolders(List<ItemType.Folder> folders, ItemType item) {
        BaseItemObject obj = null;
        if (item.getColumn() != null) {
            obj = item.getColumn();
        } else if (item.getFolder() != null) {
            obj = item.getFolder();
        } else {
            return;
        }
        SmartsModuleUtil.getFlattenedFolders(folders, obj);
    }

    public static void getFlattenedFolders(List<ItemType.Folder> folders, BaseItemObject itemObject) {
        if (itemObject instanceof ItemType.Folder) {
            folders.add((ItemType.Folder)itemObject);
        }
        if (itemObject != null) {
            itemObject.getItem().forEach(item -> SmartsModuleUtil.getFlattenedFolders(folders, item));
        }
    }

    public static void migrate(SmartsModule smartsModule) {
        SmartsModuleUtil.copyColumnEmbedding(smartsModule);
        SmartsModuleUtil.bumpVersion(smartsModule);
    }

    public static void migrate(Collection<SmartsModule> smartsModules) {
        smartsModules.stream().filter(Objects::nonNull).forEach(SmartsModuleUtil::migrate);
    }

    public static void copyColumnEmbedding(SmartsModule smartsModule) {
        Objects.requireNonNull(smartsModule);
        List<DatasetInfo> datasets = smartsModule.getDatasets();
        List<PropertyType> properties = smartsModule.getProperties();
        if (properties.isEmpty()) {
            return;
        }
        PropertyType columnEmbeddingProperty = properties.stream().filter(p -> p.getName().equals(COLUMN_EMBEDDING)).findAny().orElse(null);
        if (columnEmbeddingProperty == null) {
            return;
        }
        String columnEmbeddingJson = columnEmbeddingProperty.getValue();
        if (columnEmbeddingJson == null) {
            return;
        }
        try {
            List<ColumnEmbedding> columnEmbeddingsInSmartsModule = JAXBHelper.unmarshalListFromJSON(ColumnEmbedding.class, columnEmbeddingJson);
            Map<String, List<ColumnEmbedding>> datasetToColumnEmbeddings = columnEmbeddingsInSmartsModule.stream().collect(Collectors.groupingBy(ColumnEmbedding::getDatasetId));
            if (datasets.isEmpty()) {
                List datasetInfos = datasetToColumnEmbeddings.entrySet().stream().map(entry -> {
                    List columnEmbeddings = (List)entry.getValue();
                    if (!columnEmbeddings.isEmpty()) {
                        DatasetInfo dataset = new DatasetInfo();
                        dataset.setId((String)entry.getKey());
                        dataset.getColumnEmbeddings().addAll(columnEmbeddings);
                        return dataset;
                    }
                    return null;
                }).filter(Objects::nonNull).collect(Collectors.toList());
                smartsModule.getDatasets().addAll(datasetInfos);
            } else {
                for (DatasetInfo dataset : datasets) {
                    String id = dataset.getId();
                    List<ColumnEmbedding> columnEmbeddings = datasetToColumnEmbeddings.get(id);
                    List<ColumnEmbedding> columnEmbeddingsInDataset = dataset.getColumnEmbeddings();
                    if (columnEmbeddings == null || columnEmbeddings.isEmpty() || !columnEmbeddingsInDataset.isEmpty()) continue;
                    columnEmbeddingsInDataset.addAll(columnEmbeddings);
                }
            }
            SmartsModuleUtil.removeProperty(smartsModule, COLUMN_EMBEDDING, COLUMN_EMBEDDING_VERSION_KEY);
        }
        catch (IOException e) {
            LOGGER.error("Error occurred while migrate columnEmbedding from properties to datasets for smarts-module Id {}, error-details: {}", (Object)smartsModule.getId(), (Object)e);
        }
    }

    private static void bumpVersion(SmartsModule smartsModule) {
        if (!(smartsModule == null || smartsModule.getVersion() != null && "1.2".equals(smartsModule.getVersion()))) {
            List<PropertyType> properties = smartsModule.getProperties();
            PropertyType upgradeMessageProperty = new PropertyType();
            upgradeMessageProperty.setName("1.2_SmartsModuleUpgrade");
            upgradeMessageProperty.setValue(UPGRADE_MESSAGE);
            properties.add(upgradeMessageProperty);
            smartsModule.setVersion("1.2");
        }
    }

    public static boolean isPackageType(SmartsModule smartsModule) {
        return smartsModule.getType() != null && smartsModule.getType().equals(PACKAGE);
    }

    public static void addColumn(DatasetInfo dataset, ColumnInfo column) {
        ObjectFactory factory = new ObjectFactory();
        ItemType item = factory.createItemType();
        item.setColumn(column);
        dataset.getItem().add(item);
    }

    public static boolean deleteItemWithColumn(List<ItemType> items, String idForExpression) {
        ListIterator<ItemType> itemsIterator = items.listIterator();
        while (itemsIterator.hasNext()) {
            ItemType itemType = itemsIterator.next();
            if (itemType.getColumn() != null && itemType.getColumn().getIdForExpression().equals(idForExpression)) {
                itemsIterator.remove();
                return true;
            }
            if (itemType.getFolder() == null || !SmartsModuleUtil.deleteItemWithColumn(itemType.getFolder().getItem(), idForExpression)) continue;
            return true;
        }
        return false;
    }

    public static List<ColumnInfo> deleteColumn(DatasetInfo dataset, String id) {
        ArrayList<ColumnInfo> deleted = new ArrayList<ColumnInfo>();
        SmartsModuleUtil.deleteColumn(dataset.getItem(), id, deleted);
        return deleted;
    }

    public static void filterSmartsModuleByOptions(SmartsModule smartsModule, SmartsModuleOptions options) {
        if (smartsModule == null) {
            return;
        }
        if (options == null) {
            options = new SmartsModuleOptions.SmartsModuleOptionsBuilder().build();
        }
        Iterator<DatasetInfo> it = smartsModule.getDatasets().iterator();
        while (it.hasNext()) {
            DatasetInfo ds = it.next();
            if (!options.isIncludeFailedDataSets() && SmartsModuleUtil.removeDataset(it, ds)) continue;
            if (!options.isIncludeBivariates()) {
                SmartsModuleUtil.removeBivariates(ds);
            }
            if (!options.isIncludeColumnEmbedding()) {
                ds.getColumnEmbeddings().clear();
            }
            if (options.isExcludeStatistics()) {
                SmartsModuleUtil.removeColumnStatistics(ds.getItem());
            }
            if (options.isExcludeSampleStatistics()) {
                SmartsModuleUtil.removeColumnSampleStatistics(ds.getItem());
            }
            if (options.isExcludeLogicGroups()) {
                SmartsModuleUtil.removeLogicGroups(ds);
            }
            if (options.isExcludeHierarchies()) {
                SmartsModuleUtil.removeHierarchies(ds);
            }
            if (options.isExcludeLabels()) {
                SmartsModuleUtil.removeLabels(ds);
            }
            if (!options.isConceptsOnly()) continue;
            SmartsModuleUtil.removeNonConcept(ds);
        }
        if (smartsModule.getDatasets().isEmpty()) {
            smartsModule.setAnalysisState(AnalysisStateType.FAILED);
        }
        if (options != null && options.isConceptsOnly()) {
            smartsModule.setAnalysisMode(null);
            smartsModule.setAnalysisState(null);
            smartsModule.setModuleCreationTime(null);
            smartsModule.setModuleLastModifiedTime(null);
        }
    }

    private static boolean removeDataset(Iterator<DatasetInfo> iterator, DatasetInfo dataset) {
        if (!dataset.getAnalysisPhases().isEmpty() && !dataset.getAnalysisPhases().get(0).getAnalysisState().equals((Object)AnalysisStateType.DONE)) {
            iterator.remove();
            return true;
        }
        return false;
    }

    private static void removeBivariates(DatasetInfo ds) {
        if (!ds.getBivariateStatistics().isEmpty()) {
            ds.getBivariateStatistics().clear();
        }
    }

    private static void removeNonConcept(DatasetInfo ds) {
        if (!ds.getAnalysisPhases().isEmpty()) {
            ds.getAnalysisPhases().clear();
        }
        SmartsModuleUtil.removeHierarchies(ds);
        SmartsModuleUtil.removeDatasetLabels(ds);
        SmartsModuleUtil.removeBivariates(ds);
        SmartsModuleUtil.removeLogicGroups(ds);
        SmartsModuleUtil.filterNonConcepts(ds.getItem());
    }

    private static void removeHierarchies(DatasetInfo ds) {
        if (!ds.getHierarchies().isEmpty()) {
            ds.getHierarchies().clear();
        }
    }

    private static void removeLogicGroups(DatasetInfo ds) {
        if (!ds.getLogicalGroups().isEmpty()) {
            ds.getLogicalGroups().clear();
        }
    }

    public static void removeLabels(DatasetInfo ds) {
        SmartsModuleUtil.removeDatasetLabels(ds);
        SmartsModuleUtil.removeColumnsLabels(ds.getItem());
    }

    public static void filterNonConcepts(List<ItemType> items) {
        for (ItemType item : items) {
            ColumnInfo column = item.getColumn();
            if (column != null) {
                SemanticInfo semanticInfo;
                column.setDataType(null);
                column.setDefaultAggregation(null);
                column.setExpression(null);
                column.setId(null);
                column.setLabel(null);
                column.setName(null);
                column.setPrettyName(null);
                column.setUsage(null);
                column.setDescriptionLabel(null);
                if (!column.getSampleDistinctValueCounts().isEmpty()) {
                    column.getSampleDistinctValueCounts().clear();
                }
                if (!column.getSampleDistinctValues().isEmpty()) {
                    column.getSampleDistinctValues().clear();
                }
                if (!column.getSamples().isEmpty()) {
                    column.getSamples().clear();
                }
                SmartsModuleUtil.removeStatistics(column.getStatistics());
                SmartsModuleUtil.removeStatistics(column.getSampleStatistics());
                if (!column.getValueDecorations().isEmpty()) {
                    column.getValueDecorations().clear();
                }
                if ((semanticInfo = column.getSemanticInfo()) != null) {
                    semanticInfo.setDefaultAggregation(null);
                    semanticInfo.setUsage(null);
                    semanticInfo.setOverwrites(null);
                    if (!column.getSemanticInfo().getRelations().isEmpty()) {
                        column.getSemanticInfo().getRelations().clear();
                    }
                    Iterator<ConceptInfo> i = semanticInfo.getConcepts().iterator();
                    while (i.hasNext()) {
                        if (i.next().getConceptID().contains("/domain/")) continue;
                        i.remove();
                    }
                }
                SmartsModuleUtil.filterNonConcepts(column.getItem());
                continue;
            }
            if (item.getFolder() == null) continue;
            SmartsModuleUtil.filterNonConcepts(item.getFolder().getItem());
        }
    }

    private static void removeDatasetLabels(DatasetInfo ds) {
        ds.setLabel(null);
        ds.setDescriptionLabel(null);
    }

    private static void removeColumnsLabels(List<ItemType> items) {
        for (ItemType item : items) {
            ColumnInfo column = item.getColumn();
            if (column != null) {
                column.setLabel(null);
                SmartsModuleUtil.removeColumnsLabels(column.getItem());
                continue;
            }
            if (item.getFolder() == null) continue;
            SmartsModuleUtil.removeColumnsLabels(item.getFolder().getItem());
        }
    }

    private static void removeColumnStatistics(List<ItemType> items) {
        for (ItemType item : items) {
            ColumnInfo column = item.getColumn();
            if (column != null) {
                SmartsModuleUtil.removeStatistics(column.getStatistics());
                SmartsModuleUtil.removeColumnStatistics(column.getItem());
                continue;
            }
            if (item.getFolder() == null) continue;
            SmartsModuleUtil.removeColumnStatistics(item.getFolder().getItem());
        }
    }

    private static void removeColumnSampleStatistics(List<ItemType> items) {
        for (ItemType item : items) {
            ColumnInfo column = item.getColumn();
            if (column != null) {
                SmartsModuleUtil.removeStatistics(column.getSampleStatistics());
                SmartsModuleUtil.removeColumnSampleStatistics(column.getItem());
                continue;
            }
            if (item.getFolder() == null) continue;
            SmartsModuleUtil.removeColumnSampleStatistics(item.getFolder().getItem());
        }
    }

    private static void removeStatistics(List<Statistic> statistics) {
        if (!statistics.isEmpty()) {
            statistics.clear();
        }
    }

    private static void deleteColumn(List<ItemType> items, String id, List<ColumnInfo> deleted) {
        items.forEach(item -> {
            if (item.getColumn() != null && item.getColumn().getId().equals(id)) {
                deleted.add(item.getColumn());
                item.setColumn(null);
            } else if (item.getFolder() != null) {
                SmartsModuleUtil.deleteColumn(item.getFolder().getItem(), id, deleted);
            }
        });
    }

    public static boolean logMissingData(String smartsId, String datasetId, List<ColumnInfo> columns, String taskId) {
        if (columns == null) {
            return true;
        }
        if (columns.stream().map(ColumnInfo::getSamples).allMatch(samples -> samples == null || samples.isEmpty())) {
            LOGGER.info("NO SAMPLES! -> skipping {} for SmartsModule: {}, Dataset: {}", new Object[]{taskId, smartsId, datasetId});
            return false;
        }
        if (columns.stream().map(ColumnInfo::getDataType).allMatch(Objects::isNull)) {
            LOGGER.info("NO DATATYPES! -> skipping {} for SmartsModule: {}, Dataset: {}", new Object[]{taskId, smartsId, datasetId});
            return true;
        }
        return false;
    }

    public static DatasetInfo getCalculations(SmartsModule smartsModule) {
        return smartsModule.getDatasets().stream().filter(ds -> ds.getType().equals((Object)DatasetType.CALCULATIONS)).findFirst().orElse(null);
    }

    public static DatasetInfo getNamedSets(SmartsModule smartsModule) {
        return smartsModule.getDatasets().stream().filter(ds -> ds.getType().equals((Object)DatasetType.NAMED_SETS)).findFirst().orElse(null);
    }

    public static boolean isDimension(DatasetInfo dataset) {
        SourceCategoryType sct = dataset.getSourceCategory();
        return SourceCategoryType.DIMENSION_MEASURE.equals((Object)sct) || SourceCategoryType.DIMENSION_REGULAR.equals((Object)sct);
    }

    public static boolean isGlobalCalculation(String idForExpression, SmartsModule smartsModule) {
        DatasetInfo globalCalculations = SmartsModuleUtil.getCalculations(smartsModule);
        if (globalCalculations == null) {
            return false;
        }
        return SmartsModuleUtil.getFlattenedColumns(globalCalculations).stream().map(BaseObject::getIdForExpression).anyMatch(id -> id.equals(idForExpression));
    }

    @Deprecated
    public static List<ColumnEmbedding> unMarshalColumnEmbedding(SmartsModule smartsModule) throws IOException {
        try {
            if (smartsModule != null) {
                PropertyType propertyType;
                List<ColumnEmbedding> columnEmbeddingsInSmartsModule;
                List<DatasetInfo> datasets = smartsModule.getDatasets();
                List<PropertyType> properties = smartsModule.getProperties();
                if (!datasets.isEmpty() && !(columnEmbeddingsInSmartsModule = datasets.stream().flatMap(dataset -> dataset.getColumnEmbeddings().stream()).collect(Collectors.toList())).isEmpty()) {
                    return columnEmbeddingsInSmartsModule;
                }
                if (!properties.isEmpty() && null != (propertyType = (PropertyType)properties.stream().filter(p -> p.getName().equals(COLUMN_EMBEDDING)).findAny().orElse(null))) {
                    String columnEmbeddingJson = propertyType.getValue();
                    return JAXBHelper.unmarshalListFromJSON(ColumnEmbedding.class, columnEmbeddingJson);
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("Error occurred while un-marshaling the column embedding for smarts-module Id {}, error-details: {}", (Object)smartsModule.getId(), (Object)e);
            throw e;
        }
        return Collections.emptyList();
    }

    public static List<Question> unMarshalQuestions(SmartsModule smartsModule) throws IOException {
        List<Question> questions = Collections.emptyList();
        try {
            PropertyType questionsPropertyType;
            if (smartsModule != null && !smartsModule.getProperties().isEmpty() && null != (questionsPropertyType = (PropertyType)smartsModule.getProperties().stream().filter(p -> p.getName().equals(QUESTIONS)).findAny().orElse(null))) {
                String questionsJson = questionsPropertyType.getValue();
                questions = JAXBHelper.unmarshalListFromJSON(Question.class, questionsJson);
            }
        }
        catch (IOException ex) {
            LOGGER.error("Error occurred while un-marshaling the question-generator questions for smarts-module Id {}, error-details: {}", (Object)smartsModule.getId(), (Object)ex);
            throw ex;
        }
        return questions;
    }

    public static void marshalQuestions(SmartsModule smartsModule, List<Question> questions) throws IOException {
        String questionsJson = null;
        try {
            PropertyType questionsPropertyType;
            if (!smartsModule.getProperties().isEmpty() && null != (questionsPropertyType = (PropertyType)smartsModule.getProperties().stream().filter(p -> p.getName().equals(QUESTIONS)).findAny().orElse(null))) {
                smartsModule.getProperties().remove(questionsPropertyType);
            }
            questionsJson = JAXBHelper.marshalToJSON(questions);
            PropertyType questionsProp = new PropertyType();
            questionsProp.setName(QUESTIONS);
            questionsProp.setValue(questionsJson);
            smartsModule.getProperties().add(questionsProp);
        }
        catch (IOException ex) {
            LOGGER.error("Error occurred while marshaling the question-generator questions for smarts-module Id {}, error-details: {}", (Object)smartsModule.getId(), (Object)ex);
            throw ex;
        }
    }

    public static List<ColumnEmbedding> fetchColumnEmbeddingsFromSmartsModule(SmartsModule smartsModule) {
        List<ColumnEmbedding> columnEmbeddingsInSmartsModule;
        List<DatasetInfo> datasets;
        if (smartsModule != null && !(datasets = smartsModule.getDatasets()).isEmpty() && !(columnEmbeddingsInSmartsModule = datasets.stream().flatMap(dataset -> dataset.getColumnEmbeddings().stream()).collect(Collectors.toList())).isEmpty()) {
            return columnEmbeddingsInSmartsModule;
        }
        return Collections.emptyList();
    }

    public static void appendFilteredColumnEmbedding(List<ColumnEmbedding> generatedColumnEmbedding, List<ColumnEmbedding> inheritedColumnEmbedding) {
        if (!inheritedColumnEmbedding.isEmpty()) {
            Set idForExpressions = generatedColumnEmbedding.stream().map(ColumnEmbedding::getIdForExpression).collect(Collectors.toSet());
            inheritedColumnEmbedding.forEach(em -> {
                if (!idForExpressions.contains(em.getIdForExpression())) {
                    generatedColumnEmbedding.add((ColumnEmbedding)em);
                }
            });
        }
    }

    public static void appendFilteredEncodedSamples(List<QGEncodedSamples> generatedEncodedSamples, List<QGEncodedSamples> inheritedEncodedSamples) {
        if (!inheritedEncodedSamples.isEmpty()) {
            Set idForExpressions = generatedEncodedSamples.stream().map(QGEncodedSamples::getIdForExpression).collect(Collectors.toSet());
            inheritedEncodedSamples.forEach(em -> {
                if (!idForExpressions.contains(em.getIdForExpression())) {
                    generatedEncodedSamples.add((QGEncodedSamples)em);
                }
            });
        }
    }

    public static PropertyType findProperty(SmartsModule sm, String propertyName) {
        return sm.getProperties().stream().filter(p -> p.getName().equals(propertyName)).findAny().orElse(null);
    }

    public static void removeProperty(SmartsModule sm, String ... propertyName) {
        List<PropertyType> properties = sm.getProperties();
        if (properties.isEmpty()) {
            return;
        }
        HashSet<String> propertyNames = new HashSet<String>(Arrays.asList(propertyName));
        Map<Boolean, List<PropertyType>> dividedProperties = properties.stream().collect(Collectors.partitioningBy(property -> propertyNames.contains(property.getName())));
        properties.clear();
        properties.addAll((Collection<PropertyType>)dividedProperties.get(false));
    }
}

