/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.recommendationmodel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class Concept {
    private String conceptId;
    private int frequency;

    protected Concept(String conceptId) {
        this.conceptId = conceptId;
        this.frequency = 1;
    }

    public void incrementFrequency() {
        ++this.frequency;
    }

    @JsonCreator
    protected Concept(@JsonProperty(value="conceptId") String conceptId, @JsonProperty(value="frequency") int frequency) {
        this.conceptId = conceptId;
        this.frequency = frequency;
    }

    protected Concept(Concept inputConcept, Double inputRecModelWeight) {
        this.conceptId = inputConcept.getConceptId();
        this.frequency = (int)Math.round((double)inputConcept.getFrequency() * inputRecModelWeight);
    }

    @JsonGetter
    public String getConceptId() {
        return this.conceptId;
    }

    @JsonGetter
    public int getFrequency() {
        return this.frequency;
    }

    protected void merge(Concept sourceConcept) {
        this.frequency += sourceConcept.getFrequency();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.conceptId == null ? 0 : this.conceptId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Concept concept = (Concept)obj;
        return Objects.equals(this.conceptId, concept.conceptId);
    }
}

