/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.recommendationmodel;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.ibm.bi.recommendationmodel.Slot;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class SlotMapping {
    protected static final int MAX_SLOT_MAPPINGS = 5;
    private Map<String, Slot> slotsMapping;
    private int frequency;

    protected SlotMapping() {
        this.frequency = 0;
        this.slotsMapping = new HashMap<String, Slot>();
    }

    protected SlotMapping(SlotMapping slotMapping, double freqWeight) {
        this.slotsMapping = new HashMap<String, Slot>(slotMapping.getSlotsMapping().size());
        this.frequency = (int)Math.round((double)slotMapping.getFrequency() * freqWeight);
        for (Slot slot : slotMapping.getSlots()) {
            String inputSlotName = slot.getName();
            Slot newSlot = new Slot(slot, freqWeight);
            this.slotsMapping.putIfAbsent(inputSlotName, newSlot);
        }
    }

    public Slot putIfAbsentAndReturn(String slotName, int columnSize) {
        Slot slot = new Slot(slotName, columnSize);
        this.slotsMapping.putIfAbsent(slotName, slot);
        return this.slotsMapping.get(slotName);
    }

    @JsonGetter
    public Collection<Slot> getSlots() {
        return this.slotsMapping.values();
    }

    public void incrementFrequency() {
        ++this.frequency;
    }

    protected boolean isEqual(SlotMapping sourceSlotMapping) {
        if (this.slotsMapping.size() == sourceSlotMapping.slotsMapping.size()) {
            for (Slot slot : this.getSlots()) {
                if (sourceSlotMapping.slotsMapping.containsKey(slot.getName())) {
                    int columnSize = sourceSlotMapping.slotsMapping.get(slot.getName()).getColumns().getColumnCount();
                    if (slot.getColumns().getColumnCount() == columnSize) continue;
                    return false;
                }
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    protected boolean isEqual(Map<String, Integer> slotColumnMappings) {
        if (this.slotsMapping.size() == slotColumnMappings.size()) {
            for (Slot slot : this.getSlots()) {
                if (slotColumnMappings.containsKey(slot.getName())) {
                    int columnSize = slotColumnMappings.get(slot.getName());
                    if (slot.getColumns().getColumnCount() == columnSize) continue;
                    return false;
                }
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    @JsonSetter(value="slots")
    protected void setSlots(ArrayList<Slot> slots) {
        for (Slot slot : slots) {
            this.slotsMapping.putIfAbsent(slot.getName(), slot);
        }
    }

    @JsonSetter
    protected void setFrequency(int frequency) {
        this.frequency = frequency;
    }

    @JsonGetter
    public int getFrequency() {
        return this.frequency;
    }

    private Map<String, Slot> getSlotsMapping() {
        return this.slotsMapping;
    }

    protected void merge(SlotMapping sourceSlotMapping) {
        this.frequency += sourceSlotMapping.getFrequency();
        for (String sourceSlotName : sourceSlotMapping.getSlotsMapping().keySet()) {
            Slot sourceSlot = sourceSlotMapping.getSlotsMapping().get(sourceSlotName);
            if (this.slotsMapping.containsKey(sourceSlotName)) {
                Slot targetSlot = this.getSlotsMapping().get(sourceSlotName);
                targetSlot.merge(sourceSlot);
                continue;
            }
            this.slotsMapping.put(sourceSlotName, sourceSlot);
        }
    }
}

