/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.core.api;

import com.ibm.smarts.core.async.AsyncMetrics;
import com.ibm.smarts.core.exceptions.ClientException;
import com.ibm.smarts.core.exceptions.InternalException;
import com.ibm.smarts.core.exceptions.ServiceException;
import com.ibm.smarts.core.util.MetricsHelper;
import com.ibm.smarts.core.util.RequestContext;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Handlers {
    public static final Logger LOGGER = LoggerFactory.getLogger(Handlers.class);

    public static OnBehalfOf onBehalfOf(Object object) {
        return new OnBehalfOf(object);
    }

    default public <T, R> Function<T, R> wrap(RequestContext ctx, Function<T, R> func) {
        return this.wrap(Handlers.onBehalfOf(this), ctx, func);
    }

    default public <T, R> Function<T, R> wrap(OnBehalfOf onBehalfOf, RequestContext ctx, Function<T, R> func) {
        return new WrappedFunction<T, R>(onBehalfOf, ctx, func);
    }

    default public <R> Supplier<R> wrap(RequestContext ctx, Supplier<R> supplier) {
        return this.wrap(Handlers.onBehalfOf(this), ctx, supplier);
    }

    default public <R> Supplier<R> wrap(OnBehalfOf onBehalfOf, RequestContext ctx, Supplier<R> supplier) {
        return new WrappedSupplier<R>(onBehalfOf, ctx, supplier);
    }

    default public WrappedRunnable wrap(RequestContext ctx, Runnable runnable) {
        return this.wrap(Handlers.onBehalfOf(this), ctx, runnable);
    }

    default public WrappedRunnable wrap(long createdTs, RequestContext ctx, Runnable runnable) {
        return this.wrap(createdTs, Handlers.onBehalfOf(this), ctx, runnable);
    }

    default public WrappedRunnable wrap(OnBehalfOf onBehalfOf, RequestContext ctx, Runnable runnable) {
        return this.wrap(-1L, onBehalfOf, ctx, runnable);
    }

    default public WrappedRunnable wrap(long createdTs, OnBehalfOf onBehalfOf, RequestContext ctx, Runnable runnable) {
        return new WrappedRunnable(createdTs, onBehalfOf, ctx, runnable);
    }

    default public <T> T handle(RequestContext ctx, Function<RequestContext, T> handler) {
        return this.handle(Handlers.onBehalfOf(this), ctx, handler, null);
    }

    default public <T> T handle(RequestContext ctx, Function<RequestContext, T> handler, Consumer<RequestContext> cleanUp) {
        return this.handle(Handlers.onBehalfOf(this), ctx, handler, cleanUp);
    }

    default public <T> T handle(OnBehalfOf onBehalfOf, RequestContext ctx, Function<RequestContext, T> handler) {
        return this.handle(onBehalfOf, ctx, handler, null);
    }

    default public <T> T handle(OnBehalfOf onBehalfOf, RequestContext ctx, Function<RequestContext, T> handler, Consumer<RequestContext> cleanUp) {
        Function<RequestContext, RequestContext> wrapped = this.wrap(onBehalfOf, ctx, handler);
        long callId = ctx.nextCallId();
        T ret = null;
        try {
            try {
                ret = wrapped.apply(ctx);
            }
            catch (ServiceException serex) {
                throw serex;
            }
            catch (Throwable ex) {
                throw new InternalException(ex, "handler=" + handler.getClass().getName() + " \\nMessage=" + ex.getMessage() + "\n", new Object[0]);
            }
        }
        catch (ClientException cex) {
            throw cex;
        }
        catch (InternalException svcEx) {
            LOGGER.error("call=" + callId, (Throwable)svcEx);
            svcEx.printStackTrace();
            throw svcEx;
        }
        finally {
            if (cleanUp != null) {
                cleanUp.accept(ctx);
            }
        }
        return ret;
    }

    public static final class WrappedRunnable
    extends __AbstractWrappedOperation__<Void>
    implements Runnable {
        private final Runnable runnable;

        protected WrappedRunnable(long createdTs, OnBehalfOf onBehalfOf, RequestContext ctx, Runnable runnable) {
            super(createdTs, onBehalfOf, ctx);
            this.runnable = runnable;
        }

        @Override
        public void run() {
            this.beforeCall();
            try {
                this.runnable.run();
            }
            finally {
                this.afterCall(null);
            }
        }
    }

    public static final class WrappedSupplier<R>
    extends __AbstractWrappedOperation__<R>
    implements Supplier<R> {
        private final Supplier<R> supplier;

        protected WrappedSupplier(OnBehalfOf onBehalfOf, RequestContext ctx, Supplier<R> supplier) {
            super(onBehalfOf, ctx);
            this.supplier = supplier;
        }

        @Override
        public R get() {
            this.beforeCall();
            R ret = null;
            try {
                ret = this.supplier.get();
            }
            finally {
                this.afterCall(ret);
            }
            return ret;
        }
    }

    public static final class WrappedFunction<T, R>
    extends __AbstractWrappedOperation__<R>
    implements Function<T, R> {
        private final Function<T, R> func;

        protected WrappedFunction(OnBehalfOf onBehalfOf, RequestContext ctx, Function<T, R> func) {
            super(onBehalfOf, ctx);
            this.func = func;
        }

        @Override
        public R apply(T t) {
            this.beforeCall();
            R ret = null;
            try {
                ret = this.func.apply(t);
            }
            finally {
                this.afterCall(ret);
            }
            return ret;
        }
    }

    public static class __AbstractWrappedOperation__<R> {
        protected final Object onBehalfOf;
        protected final RequestContext ctx;
        public final long callId;
        protected final long createNanos;
        private final AsyncMetrics asyncMetrics;
        protected final long startQueuedNanos;
        protected long startWorkingNanos = 0L;

        protected __AbstractWrappedOperation__(OnBehalfOf onBehalfOf, RequestContext ctx) {
            this(-1L, onBehalfOf, ctx);
        }

        protected __AbstractWrappedOperation__(long createTs, OnBehalfOf onBehalfOf, RequestContext ctx) {
            this.onBehalfOf = onBehalfOf != null ? onBehalfOf.object : this;
            this.ctx = ctx;
            this.callId = ctx.nextCallId();
            this.asyncMetrics = ctx.asyncMetrics();
            this.createNanos = createTs == -1L ? System.nanoTime() : __AbstractWrappedOperation__.estimateNanosFromTs(createTs);
            this.startQueuedNanos = this.asyncMetrics.queued.durationStart();
        }

        private static long estimateNanosFromTs(long ts) {
            long nowNanos = System.nanoTime();
            long nowTs = System.currentTimeMillis();
            long diffMs = nowTs - ts;
            long diffNanos = diffMs * 1000000L;
            long ret = nowNanos - diffNanos;
            return ret;
        }

        protected final void beforeCall() {
            this.startWorkingNanos = this.asyncMetrics.queued.durationEndNow(this.startQueuedNanos);
            this.asyncMetrics.working.durationStart(this.startWorkingNanos);
            if (LOGGER.isTraceEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("[TRACE] call=" + this.callId + " start");
                sb.append(" time=" + System.currentTimeMillis());
                sb.append(" class=" + this.onBehalfOf.getClass().getSimpleName());
                sb.append(" queued ms=" + MetricsHelper.stringForNanosToMillis(this.startWorkingNanos - this.createNanos));
                String traceMsg = sb.toString();
                LOGGER.trace(traceMsg);
            }
        }

        protected final void afterCall(R ret) {
            long finishNanos = this.asyncMetrics.working.durationEndNow(this.startWorkingNanos);
            if (LOGGER.isTraceEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("[TRACE] call=" + this.callId + " finish");
                sb.append(" time=" + System.currentTimeMillis());
                sb.append(" class=" + this.onBehalfOf.getClass().getSimpleName());
                sb.append(" duration ms=" + MetricsHelper.stringForNanosToMillis(finishNanos - this.startWorkingNanos));
                sb.append(" returning=" + ret);
                String traceMsg = sb.toString();
                LOGGER.trace(traceMsg);
            }
        }
    }

    public static class OnBehalfOf {
        public final Object object;

        public OnBehalfOf(Object object) {
            this.object = object;
        }
    }
}

