/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.core.mq.impl;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.core.util.RequestJsonHelper;

public class WrappedJsonMessage {
    public TrackingInfo tracking;
    public String request;
    public String json;

    public WrappedJsonMessage() {
    }

    public WrappedJsonMessage(RequestContext rc, String json) {
        this.request = RequestJsonHelper.toJson(rc.request);
        this.json = json;
    }

    @JsonIgnore
    public void setWriteToQueueTimestamp() {
        if (this.tracking == null) {
            this.tracking = new TrackingInfo();
            this.tracking.writtenToQueueTs = System.currentTimeMillis();
            this.tracking.writtenToQueueNanos = System.nanoTime();
        }
    }

    @JsonIgnore
    public long getWriteToQueueTimestamp() {
        if (this.tracking != null) {
            return this.tracking.writtenToQueueTs;
        }
        return 0L;
    }

    @JsonIgnore
    public long getWriteToQueueNanos() {
        if (this.tracking != null) {
            return this.tracking.writtenToQueueNanos;
        }
        return 0L;
    }

    public static class TrackingInfo {
        public long writtenToQueueTs;
        public long writtenToQueueNanos;
    }
}

