/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.core.util;

import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomDelay {
    private static final Logger LOGGER = LoggerFactory.getLogger(RandomDelay.class);
    private final Random random = new Random();
    public final long average;
    public final double stdDev;

    public RandomDelay(long averageMillis, double stdDevMillis) {
        this.average = TimeUnit.MILLISECONDS.toNanos(averageMillis);
        this.stdDev = stdDevMillis * 100000.0;
    }

    public long nextNanos() {
        double r = this.random.nextGaussian();
        double delay = r * this.stdDev + (double)this.average;
        return (long)(delay > 0.0 ? delay : 0.0);
    }

    public long nextMillis() {
        long nanos = this.nextNanos();
        return TimeUnit.NANOSECONDS.toMillis(nanos);
    }

    public long sleep() {
        long nanos = this.nextNanos();
        try {
            TimeUnit.NANOSECONDS.sleep(nanos);
        }
        catch (InterruptedException e) {
            LOGGER.error(e.getMessage());
            Thread.currentThread().interrupt();
        }
        return TimeUnit.NANOSECONDS.toMillis(nanos);
    }
}

