/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.semanticsearch.pipeline;

import com.ibm.smarts.schema.PhraseInfo;
import com.ibm.smarts.semanticsearch.impl.NLUEntityContext;
import com.ibm.smarts.semanticsearch.impl.SearchContext;
import com.ibm.smarts.semanticsearch.impl.SemanticQueryType;
import com.ibm.smarts.semanticsearch.pipeline.IAnnotator;
import com.ibm.smarts.semanticsearch.util.SemanticSearchHelper;
import com.ibm.smarts.store.api.provider.IFeatureStore;
import com.ibm.smarts.store.api.query.IStoreQuery;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LemmaSearchAnnotator
implements IAnnotator {
    private static final Logger LOGGER = LoggerFactory.getLogger(LemmaSearchAnnotator.class);
    private static final String SPACE = " ";
    private SearchContext searchContext;

    public LemmaSearchAnnotator(SearchContext searchContext) {
        this.searchContext = searchContext;
    }

    @Override
    public void accept(NLUEntityContext entityContext) {
        String queryString = this.expandQuery(entityContext);
        LOGGER.info("Expanded query: " + queryString);
        if (StringUtils.isBlank((CharSequence)queryString) || queryString.equals(entityContext.getNluEntity().getText())) {
            return;
        }
        IFeatureStore featureStore = this.searchContext.getStoreProvider().getFeatureStore(this.searchContext.getReqCtx());
        IStoreQuery query = SemanticSearchHelper.buildQuery(this.searchContext.getReqCtx(), featureStore, queryString, this.searchContext.getAssetTypes(), this.searchContext.isInDataValue(), SemanticQueryType.EXPAND, this.searchContext.getAssetRefs());
        List featureHits = featureStore.executeSearch(query);
        SemanticSearchHelper.debugRawFeatureHits(featureHits, LOGGER, String.format("querySearch with query: [%s]", entityContext.getNluEntity().getText()));
        SemanticSearchHelper.appendQueryByAssetRefsHitsIfInDataValue(featureHits, this.searchContext, featureStore, queryString);
        if (featureHits.isEmpty()) {
            return;
        }
        entityContext.cacheMultipleRawSearchResults(featureHits);
    }

    private String expandQuery(NLUEntityContext entityContext) {
        PhraseInfo phrase = entityContext.getNluPhraseInfo();
        String phraseTextLC = phrase.getText().toLowerCase(this.searchContext.getReqCtx().locale);
        String entityTextLC = entityContext.getNluEntity().getText().toLowerCase(this.searchContext.getReqCtx().locale);
        ArrayList<String> words = new ArrayList<String>();
        if (!phraseTextLC.equals(entityTextLC)) {
            words.add(phrase.getText());
        }
        this.addTokens(words, phrase);
        this.addLemmaIfRequired(words, phrase);
        return words.stream().reduce("", (s1, s2) -> String.join((CharSequence)SPACE, s1, s2)).trim();
    }

    private void addLemmaIfRequired(List<String> words, PhraseInfo phrase) {
        phrase.getTokens().stream().filter(t -> !t.getText().equalsIgnoreCase(t.getLemma())).forEach(t -> words.add(t.getLemma()));
    }

    private void addTokens(List<String> words, PhraseInfo phrase) {
        phrase.getTokens().forEach(t -> words.add(t.getText()));
    }
}

