/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.content.recommender.api;

import com.ibm.smarts.common.modifiers.BaseFilter;
import com.ibm.smarts.common.modifiers.Intent;
import com.ibm.smarts.content.recommender.api.AnalysisType;
import com.ibm.smarts.content.recommender.api.TopicScope;
import com.ibm.smarts.schema.SmartsModule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class AnalysisScope {
    private static final int DEFAULT_MAX_COMBINATION_SIZE = 3;
    private static final int DEFAULT_COLUMN_COMBINATION_COUNT = 20;
    private static final int DEFAULT_MAX_TOPICS = 3;
    private final Locale locale;
    private final SmartsModule smartsModule;
    private final String sourceType;
    private TopicScope primaryTopic;
    private final List<TopicScope> secondaryTopics;
    private List<Intent> intents = new ArrayList<Intent>();
    private List<BaseFilter> filters = new ArrayList<BaseFilter>();
    private boolean includePredictiveCombinations;
    private AnalysisType analysisType = AnalysisType.SIMPLE;
    private List<String> includedColumns = new ArrayList<String>();
    private List<String> excludedColumns = new ArrayList<String>();
    private String queryableAssetId;
    private int maxCombinationSize = 3;
    private int maxTopics = 3;
    private Map<String, Set<String>> joinableColumnMap = new HashMap<String, Set<String>>();
    private int maxColumnCombinations = 20;
    private boolean guidedDashboard;

    public AnalysisScope(AnalysisScope other) {
        this.smartsModule = other.smartsModule;
        this.sourceType = other.sourceType;
        this.locale = other.locale;
        this.primaryTopic = other.primaryTopic;
        this.secondaryTopics = new ArrayList<TopicScope>();
        this.secondaryTopics.addAll(other.secondaryTopics);
        this.intents.addAll(other.intents);
        this.analysisType = other.analysisType;
        this.maxCombinationSize = other.maxCombinationSize;
        this.joinableColumnMap = other.joinableColumnMap;
        this.maxColumnCombinations = other.maxColumnCombinations;
        this.queryableAssetId = other.queryableAssetId;
        this.filters.addAll(other.filters);
    }

    public AnalysisScope(SmartsModule smartsModule, String sourceType, Locale locale, List<TopicScope> secondaryTopics) {
        this.smartsModule = smartsModule;
        this.locale = locale;
        this.sourceType = sourceType;
        if (!secondaryTopics.isEmpty()) {
            this.secondaryTopics = new ArrayList<TopicScope>();
            this.secondaryTopics.addAll(secondaryTopics);
        } else {
            this.secondaryTopics = Collections.emptyList();
        }
    }

    public AnalysisScope(SmartsModule smartsModule, String sourceType, Locale locale, TopicScope primary, List<TopicScope> secondaryTopics) {
        this.smartsModule = smartsModule;
        this.locale = locale;
        this.sourceType = sourceType;
        this.primaryTopic = primary;
        if (!secondaryTopics.isEmpty()) {
            this.secondaryTopics = new ArrayList<TopicScope>();
            this.secondaryTopics.addAll(secondaryTopics);
        } else {
            this.secondaryTopics = Collections.emptyList();
        }
    }

    public void setPrimaryTopic(TopicScope primaryTopic) {
        this.primaryTopic = primaryTopic;
    }

    public Optional<TopicScope> getPrimaryTopic() {
        if (this.primaryTopic != null) {
            return Optional.of(this.primaryTopic);
        }
        return Optional.empty();
    }

    public void setQueryableAssetId(String assetId) {
        this.queryableAssetId = assetId;
    }

    public String getQueryableAssetId() {
        return this.queryableAssetId;
    }

    public List<TopicScope> getSecondaryTopics() {
        return this.secondaryTopics;
    }

    public List<Intent> getIntents() {
        return Collections.unmodifiableList(this.intents);
    }

    public List<BaseFilter> getFilters() {
        return Collections.unmodifiableList(this.filters);
    }

    public SmartsModule getSmartsModule() {
        return this.smartsModule;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public void setFilters(List<BaseFilter> filters) {
        if (filters != null) {
            this.filters.addAll(filters);
        }
    }

    public AnalysisType getAnalysisType() {
        return this.analysisType;
    }

    public void setAnalysisType(AnalysisType analysisType) {
        this.analysisType = analysisType;
    }

    public boolean isIncludePredictiveCombinations() {
        return this.includePredictiveCombinations;
    }

    public void setIncludePredictiveCombinations(boolean includePredictiveCombinations) {
        this.includePredictiveCombinations = includePredictiveCombinations;
    }

    public List<String> getIncludedColumns() {
        return this.includedColumns;
    }

    public void setIncludedColumns(List<String> includedColumns) {
        this.includedColumns = includedColumns;
    }

    public List<String> getExcludedColumns() {
        return this.excludedColumns;
    }

    public void setExcludedColumns(List<String> excludedColumns) {
        this.excludedColumns = excludedColumns;
    }

    public int getMaxCombinationSize() {
        return this.maxCombinationSize;
    }

    public void setMaxCombinationSize(int maxCombinationSize) {
        this.maxCombinationSize = maxCombinationSize;
    }

    public void setIntents(List<Intent> intents) {
        if (intents != null) {
            this.intents.addAll(intents);
        }
    }

    public Map<String, Set<String>> getJoinableColumnMap() {
        return this.joinableColumnMap;
    }

    public void setJoinableColumnMap(Map<String, Set<String>> joinableColumnMap) {
        this.joinableColumnMap = joinableColumnMap;
    }

    public int getMaxColumnCombinations() {
        return this.maxColumnCombinations;
    }

    public void setMaxColumnCombinations(int maxColumnCombinations) {
        this.maxColumnCombinations = maxColumnCombinations;
    }

    public boolean getGuidedDashboard() {
        return this.guidedDashboard;
    }

    public void setGuidedDashboard(boolean guidedDashboard) {
        this.guidedDashboard = guidedDashboard;
    }

    public int getMaxTopics() {
        return this.maxTopics;
    }

    public void setMaxTopics(int maxTopics) {
        this.maxTopics = maxTopics;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AnalysisScope)) {
            return false;
        }
        AnalysisScope that = (AnalysisScope)o;
        return this.isIncludePredictiveCombinations() == that.isIncludePredictiveCombinations() && this.getMaxCombinationSize() == that.getMaxCombinationSize() && this.getMaxColumnCombinations() == that.getMaxColumnCombinations() && this.getGuidedDashboard() == that.getGuidedDashboard() && Objects.equals(this.getLocale(), that.getLocale()) && Objects.equals(this.getSmartsModule(), that.getSmartsModule()) && Objects.equals(this.getSourceType(), that.getSourceType()) && Objects.equals(this.getPrimaryTopic(), that.getPrimaryTopic()) && Objects.equals(this.getSecondaryTopics(), that.getSecondaryTopics()) && Objects.equals(this.getIntents(), that.getIntents()) && Objects.equals(this.getFilters(), that.getFilters()) && this.getAnalysisType() == that.getAnalysisType() && Objects.equals(this.getIncludedColumns(), that.getIncludedColumns()) && Objects.equals(this.getExcludedColumns(), that.getExcludedColumns()) && Objects.equals(this.getQueryableAssetId(), that.getQueryableAssetId()) && Objects.equals(this.getJoinableColumnMap(), that.getJoinableColumnMap());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getLocale(), this.getSmartsModule(), this.getSourceType(), this.getPrimaryTopic(), this.getSecondaryTopics(), this.getIntents(), this.getFilters(), this.isIncludePredictiveCombinations(), this.getAnalysisType(), this.getIncludedColumns(), this.getExcludedColumns(), this.getQueryableAssetId(), this.getMaxCombinationSize(), this.getJoinableColumnMap(), this.getMaxColumnCombinations(), this.getGuidedDashboard()});
    }

    public String toString() {
        return "AnalysisScope{locale=" + this.locale + ", smartsModule=" + this.smartsModule + ", sourceType='" + this.sourceType + '\'' + ", primaryTopic=" + this.primaryTopic + ", secondaryTopics=" + this.secondaryTopics + ", intents=" + this.intents + ", filters=" + this.filters + ", includePredictiveCombinations=" + this.includePredictiveCombinations + ", analysisType=" + (Object)((Object)this.analysisType) + ", includedColumns=" + this.includedColumns + ", excludedColumns=" + this.excludedColumns + ", queryableAssetId='" + this.queryableAssetId + '\'' + ", maxCombinationSize=" + this.maxCombinationSize + ", getJoinableColumnMap=" + this.getJoinableColumnMap() + ", maxColumnCombinations=" + this.maxColumnCombinations + ", guidedDashboard=" + this.guidedDashboard + '}';
    }
}

