/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.content.recommender.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ibm.smarts.common.modifiers.Modifier;
import com.ibm.smarts.common.modifiers.TopBottomFilter;
import com.ibm.smarts.schema.AggregationType;

public class TopicScope {
    private String id;
    private double confidence;
    private boolean isPrimary;
    private TopBottomFilter filter;
    private Modifier modifier;
    private AggregationType aggregationType;
    private boolean hasAggregationOverride = false;

    public TopicScope(String id) {
        this.id = id;
    }

    public TopicScope(String id, double confidence) {
        this.id = id;
        this.confidence = confidence;
    }

    public TopicScope(String id, double confidence, boolean isPrimary) {
        this.id = id;
        this.confidence = confidence;
        this.isPrimary = isPrimary;
    }

    @JsonCreator
    public TopicScope(@JsonProperty(value="id") String id, @JsonProperty(value="confidence") double confidence, @JsonProperty(value="isPrimary") boolean isPrimary, @JsonProperty(value="filter") TopBottomFilter filter, @JsonProperty(value="modifier") Modifier modifier) {
        this(id, confidence, isPrimary);
        this.filter = filter;
        this.modifier = modifier;
    }

    public String getId() {
        return this.id;
    }

    public double getConfidence() {
        return this.confidence;
    }

    public boolean isPrimary() {
        return this.isPrimary;
    }

    public void setPrimary(boolean primary) {
        this.isPrimary = primary;
    }

    public TopBottomFilter getFilter() {
        return this.filter;
    }

    public Modifier getModifier() {
        return this.modifier;
    }

    public void setAggregationType(AggregationType aggregationType) {
        this.aggregationType = aggregationType;
        this.hasAggregationOverride = true;
    }

    public void setAggregationType(AggregationType aggregationType, boolean isAggregationOverride) {
        this.aggregationType = aggregationType;
        this.hasAggregationOverride = isAggregationOverride;
    }

    public AggregationType getAggregationType() {
        return this.aggregationType;
    }

    public AggregationType getAggregationTypeOverride() {
        if (this.hasAggregationOverride) {
            return this.aggregationType;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TopicScope other = (TopicScope)obj;
        if (this.aggregationType != other.aggregationType) {
            return false;
        }
        if (Double.doubleToLongBits(this.confidence) != Double.doubleToLongBits(other.confidence)) {
            return false;
        }
        if (this.filter == null ? other.filter != null : !this.filter.equals((Object)other.filter)) {
            return false;
        }
        if (this.hasAggregationOverride != other.hasAggregationOverride) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.isPrimary != other.isPrimary) {
            return false;
        }
        return this.modifier == other.modifier;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.aggregationType == null ? 0 : this.aggregationType.hashCode());
        long temp = Double.doubleToLongBits(this.confidence);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.filter == null ? 0 : this.filter.hashCode());
        result = 31 * result + (this.hasAggregationOverride ? 1231 : 1237);
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.isPrimary ? 1231 : 1237);
        result = 31 * result + (this.modifier == null ? 0 : this.modifier.hashCode());
        return result;
    }

    public String toString() {
        return super.toString();
    }
}

