/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.content.recommender.api.content;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ibm.smarts.common.modifiers.BaseFilter;
import com.ibm.smarts.content.recommender.api.content.IRCombination;
import com.ibm.smarts.schema.AggregationType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class IRContent {
    private String id;
    private String topicId;
    private List<IRCombination> combinations = new ArrayList<IRCombination>();
    private List<BaseFilter> globalFilters = new ArrayList<BaseFilter>();
    private double score;
    private String details;
    private AggregationType aggregationType;

    public IRContent(String id, String topicId, List<IRCombination> combinations, List<BaseFilter> globalFilters) {
        this.id = id;
        this.topicId = topicId;
        if (combinations != null) {
            this.combinations.addAll(combinations);
        }
        if (globalFilters != null) {
            this.globalFilters.addAll(globalFilters);
        }
    }

    @JsonCreator
    public IRContent(@JsonProperty(value="id") String id, @JsonProperty(value="topicId") String topicId, @JsonProperty(value="combinations") List<IRCombination> combinations, @JsonProperty(value="globalFilters") List<BaseFilter> globalFilters, @JsonProperty(value="details") String details) {
        this(id, topicId, combinations, globalFilters);
        this.details = details;
    }

    public IRContent(IRContent source) {
        this(source.getId(), source.getTopicId(), source.getCombinations(), source.globalFilters);
        this.details = source.getDetails();
    }

    public void setCombinations(List<IRCombination> combinations) {
        this.combinations.clear();
        this.combinations.addAll(combinations);
    }

    public String getId() {
        return this.id;
    }

    public double getScore() {
        return this.score;
    }

    public void setScore(double score) {
        this.score = score;
    }

    public String getTopicId() {
        return this.topicId;
    }

    public List<IRCombination> getCombinations() {
        return this.combinations;
    }

    public List<BaseFilter> getGlobalFilters() {
        return this.globalFilters;
    }

    public void setGlobalFilters(List<BaseFilter> filters) {
        this.globalFilters.clear();
        this.globalFilters.addAll(filters);
    }

    public String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public AggregationType getAggregationType() {
        return this.aggregationType;
    }

    public void setAggregationType(AggregationType aggregationType) {
        this.aggregationType = aggregationType;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IRContent)) {
            return false;
        }
        IRContent irContent = (IRContent)o;
        return Double.compare(irContent.getScore(), this.getScore()) == 0 && this.getId().equals(irContent.getId()) && this.getTopicId().equals(irContent.getTopicId()) && this.getCombinations().equals(irContent.getCombinations()) && this.getGlobalFilters().equals(irContent.getGlobalFilters()) && Objects.equals(this.getDetails(), irContent.getDetails()) && this.getAggregationType() == irContent.getAggregationType();
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.getTopicId(), this.getCombinations(), this.getGlobalFilters(), this.getScore(), this.getDetails(), this.getAggregationType());
    }

    public String toString() {
        return "IRContent{id='" + this.id + '\'' + ", topicId='" + this.topicId + '\'' + ", combinations=" + this.combinations + ", globalFilters=" + this.globalFilters + ", score=" + this.score + ", details='" + this.details + '\'' + ", aggregationType=" + this.aggregationType + '}';
    }
}

