/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.content.recommender.internal;

import com.ibm.smarts.content.recommender.api.ContentException;
import com.ibm.smarts.content.recommender.internal.SmartsStatus;
import com.ibm.smarts.content.recommender.internal.util.QuickAccessSmartsModule;
import com.ibm.smarts.ontology.registry.util.ConceptsUtil;
import com.ibm.smarts.schema.AggregationType;
import com.ibm.smarts.schema.BaseItemObject;
import com.ibm.smarts.schema.BivariateStatistics;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.ConceptInfo;
import com.ibm.smarts.schema.DatasetInfo;
import com.ibm.smarts.schema.FieldRecommendationRecord;
import com.ibm.smarts.schema.Statistic;
import com.ibm.smarts.schema.util.ColumnIdentifier;
import com.ibm.smarts.schema.util.SmartsModuleUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CandidateTopicGenerator {
    private final QuickAccessSmartsModule quickAccess;
    private final float OBVIOUS_CORRELATION = 0.5f;
    final String UNINTERESTING_ENTITY = "Entity";
    final String UNINTERESTING_ROWIDENTIFIER = "RowIdentifier";
    final String UNINTERESTING_IDENTIFIER = "Identifier";
    final String UNINTERESTING_MEASURE = "Measure";
    final String UNINTERESTING_QUANTITY = "Quantity";
    Set<String> UNINTERESTING_SET = new HashSet<String>(Arrays.asList("Entity", "RowIdentifier", "Identifier", "Measure", "Quantity", "Latitude", "Longitude"));
    static final String UNINTERESTING_LATITUDE = "Latitude";
    static final String UNINTERESTING_LONGITUDE = "Longitude";
    static Set<String> NONPERMISSABLE_SET = new HashSet<String>(Arrays.asList("Latitude", "Longitude"));

    public CandidateTopicGenerator(QuickAccessSmartsModule sm) {
        this.quickAccess = sm;
    }

    public List<ColumnInfo> getInterestingCandidates(List<FieldRecommendationRecord> recs, int maxTopicNum) {
        if (recs == null || recs.isEmpty()) {
            throw new ContentException(SmartsStatus.FIELD_RECOMMENDATION_IS_EMPTY);
        }
        ArrayList<ColumnInfo> topTier = new ArrayList<ColumnInfo>();
        for (FieldRecommendationRecord x : recs) {
            ColumnIdentifier id = this.quickAccess.getColumnIdentifier(x.getFieldIDForExpression());
            if (this.inSingleColumnTable(id) || id.getColumnInfo().getDefaultAggregation() == null || id.getColumnInfo().getDefaultAggregation().equals((Object)AggregationType.NONE)) continue;
            topTier.add(id.getColumnInfo());
        }
        List<ColumnInfo> candidates = this.findInterestingTopics(topTier, maxTopicNum, true);
        if (candidates.size() < maxTopicNum) {
            topTier.removeAll(candidates);
            candidates.addAll(this.findInterestingTopics(topTier, maxTopicNum - candidates.size(), false));
        }
        return candidates;
    }

    private boolean inSingleColumnTable(ColumnIdentifier ci) {
        DatasetInfo ds = this.quickAccess.getDatasetInfo(ci.columnIdForExpression);
        List columns = SmartsModuleUtil.getFlattenedColumns((BaseItemObject)ds);
        return columns.size() <= 1;
    }

    private List<ColumnInfo> findInterestingTopics(List<ColumnInfo> allInterestingFields, int maxTopicNum, boolean firstPass) {
        ArrayList<ColumnInfo> result = new ArrayList<ColumnInfo>();
        HashSet<String> domainConceptsObserved = new HashSet<String>();
        for (ColumnInfo ci : allInterestingFields) {
            if ((!firstPass || !result.isEmpty()) && (firstPass && !this.hasNewDomainConcept(ci, domainConceptsObserved) || this.isHighlyCorrelatedWith(ci, result))) continue;
            result.add(ci);
            if (result.size() == maxTopicNum) break;
            if (ci.getSemanticInfo() == null) continue;
            this.addAllDomainConcepts(ci.getSemanticInfo().getConcepts(), domainConceptsObserved);
        }
        return result;
    }

    private boolean hasNewDomainConcept(ColumnInfo col, Set<String> domainConceptsObserved) {
        boolean passedDomainCheck = false;
        List concepts = col.getSemanticInfo().getConcepts();
        for (ConceptInfo concept : concepts) {
            String conceptName = ConceptsUtil.getConceptName((ConceptInfo)concept);
            if (!ConceptsUtil.getOntologyId((ConceptInfo)concept).equals("http://www.ibm.com/ontologies/waca/domain/common") || this.isUninteresting(conceptName) || domainConceptsObserved.contains(conceptName)) continue;
            passedDomainCheck = true;
            break;
        }
        return passedDomainCheck;
    }

    private boolean isHighlyCorrelatedWith(ColumnInfo col, List<ColumnInfo> columns) {
        return columns.stream().anyMatch(c -> this.isHighlyCorrelated(col, (ColumnInfo)c));
    }

    private boolean isUninteresting(String conceptName) {
        return this.UNINTERESTING_SET.contains(conceptName);
    }

    private boolean isHighlyCorrelated(ColumnInfo ci1, ColumnInfo ci2) {
        ColumnIdentifier ci1Identifier = this.quickAccess.getColumnIdentifier(ci1.getIdForExpression());
        Map<ColumnIdentifier, BivariateStatistics> bivs = this.quickAccess.getBivariates(ci1Identifier);
        if (bivs != null) {
            BivariateStatistics biv;
            ColumnIdentifier ci2Identifier = this.quickAccess.getColumnIdentifier(ci2.getIdForExpression());
            return bivs.containsKey(ci2Identifier) && this.isObvious(biv = bivs.get(ci2Identifier));
        }
        return true;
    }

    private boolean isObvious(BivariateStatistics biv) {
        for (Statistic stat : biv.getStatistics()) {
            if (!(stat.getValue().floatValue() > 0.5f)) continue;
            return true;
        }
        return false;
    }

    private void addAllDomainConcepts(List<ConceptInfo> concepts, Set<String> domainConceptsObserved) {
        for (ConceptInfo concept : concepts) {
            String conceptName = ConceptsUtil.getConceptName((ConceptInfo)concept);
            if (!ConceptsUtil.getOntologyId((ConceptInfo)concept).equals("http://www.ibm.com/ontologies/waca/domain/common") || this.isUninteresting(conceptName)) continue;
            domainConceptsObserved.add(conceptName);
        }
    }

    public static boolean isPermissibleTopic(ColumnInfo ci) {
        if (ci == null) {
            return false;
        }
        if (ci.getSemanticInfo() != null) {
            for (ConceptInfo concept : ci.getSemanticInfo().getConcepts()) {
                if (!NONPERMISSABLE_SET.contains(ConceptsUtil.getConceptName((ConceptInfo)concept))) continue;
                return false;
            }
        }
        return true;
    }
}

