/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.content.recommender.internal;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.smarts.ca.core.impl.SmartsCaClientManager;
import com.ibm.smarts.common.modifiers.BaseFilter;
import com.ibm.smarts.common.modifiers.CategoricalFilterCondition;
import com.ibm.smarts.common.modifiers.FilterCondition;
import com.ibm.smarts.common.modifiers.FilterType;
import com.ibm.smarts.common.modifiers.FilterTypeConversionException;
import com.ibm.smarts.common.modifiers.InclusionExclusionFilter;
import com.ibm.smarts.common.modifiers.NumericFilter;
import com.ibm.smarts.common.modifiers.NumericOperator;
import com.ibm.smarts.common.modifiers.PreOrPostAggregation;
import com.ibm.smarts.common.modifiers.TopBottomFilter;
import com.ibm.smarts.content.recommender.api.ContentException;
import com.ibm.smarts.content.recommender.internal.SmartsStatus;
import com.ibm.smarts.content.recommender.internal.util.Pair;
import com.ibm.smarts.core.exceptions.InternalException;
import com.ibm.smarts.core.rest.client.util.JaxRs20Exceptions;
import com.ibm.smarts.schema.AggregationType;
import com.ibm.smarts.schema.ColumnInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import javax.ws.rs.WebApplicationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentQueryUtil {
    private static final int queryLimit = 3000;
    private static final long BIG_NUMBER = 10000000L;
    Random randomizer = new Random();
    SmartsCaClientManager clientManager;
    private String moduleId;
    private String sourceType;
    private static final String JSON_VERSION = "version";
    private static final String JSON_DATAITEMS = "dataItems";
    private static final String JSON_DATA = "data";
    private static final String JSON_PROJECTIONS = "projections";
    private static final String JSON_LIMIT = "limit";
    private static final String JSON_QUERYHINTS = "queryHints";
    private static final String JSON_SELECTION = "selection";
    private static final String JSON_FILTERS = "filters";
    private static final String IN = "in";
    private static final String NOT_IN = "notin";
    private static final Logger LOGGER = LoggerFactory.getLogger(ContentQueryUtil.class);

    public ContentQueryUtil(SmartsCaClientManager clientManager, String moduleId, String sourceType) {
        this.clientManager = clientManager;
        this.moduleId = moduleId;
        this.sourceType = sourceType;
    }

    public List<Pair<String, String>> getQueriedValuesFromFilters(List<BaseFilter> baseFilters, Pair<String, AggregationType> aggregatedMeasure, String groupedByIdForExpr, TopBottomFilter filter, int numItemsToReturn) {
        try {
            String querySpec = this.generateQuerySpecFromFilters(baseFilters, groupedByIdForExpr, filter, numItemsToReturn, aggregatedMeasure);
            String response = this.clientManager.getDatasetsClient().getData(this.moduleId, this.sourceType, querySpec);
            return this.parseTopOrBottomResponse(response);
        }
        catch (InternalException | JaxRs20Exceptions.ResponseProcessingException | WebApplicationException e) {
            LOGGER.error("Error querying data for top/bottom content recommendations", e);
            throw new ContentException(SmartsStatus.UNABLE_TO_GET_TOP_BOTTOM);
        }
    }

    private String generateQuerySpecFromFilters(List<BaseFilter> baseFilters, String groupedByIdForExpr, TopBottomFilter filter, int n, Pair<String, AggregationType> aggregatedMeasure) {
        JSONObject querySpec = new JSONObject();
        JSONArray dataItems = new JSONArray();
        JSONArray projections = new JSONArray();
        JSONArray filters = new JSONArray();
        this.generateSpecForDataItemsProjections(dataItems, projections, groupedByIdForExpr, filter, n, aggregatedMeasure);
        this.generateSpecForFilters(filters, baseFilters);
        querySpec.put((Object)JSON_VERSION, (Object)"1");
        querySpec.put((Object)JSON_DATAITEMS, (Object)dataItems);
        querySpec.put((Object)JSON_PROJECTIONS, (Object)projections);
        querySpec.put((Object)JSON_LIMIT, (Object)3000);
        querySpec.put((Object)JSON_QUERYHINTS, (Object)new JSONObject());
        querySpec.put((Object)JSON_FILTERS, (Object)filters);
        return querySpec.toString();
    }

    public void getTopAndBottomQuartile(ColumnInfo aggregatedMeasure, String groupedByIdForExpr, List<Pair<String, String>> topQuartile, List<Pair<String, String>> bottomQuartile, List<Pair<String, String>> middle) {
        try {
            String spec = this.generateOrderedQuerySpec(groupedByIdForExpr, aggregatedMeasure);
            String response = this.clientManager.getDatasetsClient().getData(this.moduleId, this.sourceType, spec);
            this.parseQuartiles(response, topQuartile, bottomQuartile, middle);
        }
        catch (InternalException | JaxRs20Exceptions.ResponseProcessingException | WebApplicationException e) {
            LOGGER.error("Error querying data for top/bottom content recommendations", e);
        }
    }

    public Map<String, String> getMeasuresByInclusion(List<ColumnInfo> aggregatedMeasures, InclusionExclusionFilter ief) {
        if (!ief.getInclusionValues().isEmpty()) {
            return this.getMeasuresByInclusion(aggregatedMeasures, ief.getColumnId(), ief.getInclusionValues().stream().map(i -> i.getUniqueValue()).collect(Collectors.toList()));
        }
        if (ief.getFilterCondition() != null && !ief.getFilterCondition().getValues().isEmpty()) {
            return this.getMeasuresByInclusion(aggregatedMeasures, ief.getColumnId(), ief.getFilterCondition().getValues().stream().collect(Collectors.toList()));
        }
        return Collections.emptyMap();
    }

    public Map<String, String> getMeasuresByInclusion(List<ColumnInfo> aggregatedMeasures, String inclusionOn, List<String> includedValues) {
        try {
            String spec = this.generateMultiMeasureQuerySpec(aggregatedMeasures, inclusionOn, includedValues);
            String response = this.clientManager.getDatasetsClient().getData(this.moduleId, this.sourceType, spec);
            return this.parseMultiMeasureResponse(response);
        }
        catch (InternalException | JaxRs20Exceptions.ResponseProcessingException | WebApplicationException e) {
            LOGGER.error("Error querying data for top/bottom content recommendations", e);
            return Collections.emptyMap();
        }
    }

    private String generateMultiMeasureQuerySpec(List<ColumnInfo> aggregatedMeasures, String filterOn, List<String> inclusionValues) {
        JSONObject querySpec = new JSONObject();
        JSONArray dataItems = new JSONArray();
        JSONArray projections = new JSONArray();
        this.generateSpecForOrderedDataItemsProjections(dataItems, projections, aggregatedMeasures);
        querySpec.put((Object)JSON_VERSION, (Object)"1");
        querySpec.put((Object)JSON_DATAITEMS, (Object)dataItems);
        querySpec.put((Object)JSON_PROJECTIONS, (Object)projections);
        querySpec.put((Object)JSON_LIMIT, (Object)3000);
        querySpec.put((Object)JSON_QUERYHINTS, (Object)new JSONObject());
        JSONArray filters = this.generateFilters(inclusionValues, filterOn);
        querySpec.put((Object)JSON_FILTERS, (Object)filters);
        return querySpec.toString();
    }

    public String generateOrderedQuerySpec(String groupedByIdForExpr, ColumnInfo aggregatedMeasure) {
        JSONObject querySpec = new JSONObject();
        JSONArray dataItems = new JSONArray();
        JSONArray projections = new JSONArray();
        this.generateSpecForOrderedDataItemsProjections(dataItems, projections, groupedByIdForExpr, aggregatedMeasure);
        querySpec.put((Object)JSON_VERSION, (Object)"1");
        querySpec.put((Object)JSON_DATAITEMS, (Object)dataItems);
        querySpec.put((Object)JSON_PROJECTIONS, (Object)projections);
        querySpec.put((Object)JSON_LIMIT, (Object)3000);
        querySpec.put((Object)JSON_QUERYHINTS, (Object)new JSONObject());
        return querySpec.toString();
    }

    private void addSelectionToDataItem(JSONObject dataItem, int priority, String sortType) {
        JSONArray selection1Array = new JSONArray();
        JSONObject selection1 = new JSONObject();
        selection1.put((Object)"operation", (Object)"order");
        JSONObject sort1 = new JSONObject();
        sort1.put((Object)"type", (Object)sortType);
        sort1.put((Object)"priority", (Object)priority);
        selection1.put((Object)"sort", (Object)sort1);
        selection1Array.add((Object)selection1);
        dataItem.put((Object)JSON_SELECTION, (Object)selection1Array);
    }

    private void generateSpecForOrderedDataItemsProjections(JSONArray dataItems, JSONArray projections, String itemId, ColumnInfo aggregatedMeasure) {
        Pair<String, String> uniqueIds = this.generateUniqueIdsForSelection();
        JSONObject dataItem1 = this.makeDataItemJSON(uniqueIds.getLeft(), itemId, Optional.empty());
        JSONObject dataItem2 = this.makeDataItemJSON(uniqueIds.getRight(), aggregatedMeasure.getIdForExpression(), Optional.of(this.getQueryableAggregation(aggregatedMeasure)));
        dataItems.add((Object)dataItem1);
        dataItems.add((Object)dataItem2);
        this.addSelectionToDataItem(dataItem1, 1, "asc");
        this.addSelectionToDataItem(dataItem2, 0, "desc");
        projections.add((Object)uniqueIds.getLeft());
        projections.add((Object)uniqueIds.getRight());
    }

    private void generateSpecForOrderedDataItemsProjections(JSONArray dataItems, JSONArray projections, List<ColumnInfo> aggregatedMeasures) {
        List<String> uniqueIds = this.generateUniqueIdsForSelection(aggregatedMeasures.size());
        for (int dataItemIdx = 0; dataItemIdx < aggregatedMeasures.size(); ++dataItemIdx) {
            String uniqueId = uniqueIds.get(dataItemIdx);
            ColumnInfo measure = aggregatedMeasures.get(dataItemIdx);
            JSONObject dataItem = this.makeDataItemJSON(uniqueId, measure.getIdForExpression(), Optional.of(this.getQueryableAggregation(measure)));
            dataItems.add((Object)dataItem);
            this.addSelectionToDataItem(dataItem, dataItemIdx, "asc");
            projections.add((Object)uniqueId);
        }
    }

    private List<String> generateUniqueIdsForSelection(int n) {
        ArrayList<String> uniqueList = new ArrayList<String>();
        for (int uniqueId = 0; uniqueId < n; ++uniqueId) {
            long id;
            String idString;
            do {
                id = Math.round(this.randomizer.nextDouble() * 1.0E7);
            } while (uniqueList.contains(idString = "id" + id));
            uniqueList.add(idString);
        }
        return uniqueList;
    }

    private Map<String, String> parseMultiMeasureResponse(String response) {
        JSONObject json;
        try {
            json = JSONObject.parse((String)response);
        }
        catch (IOException e) {
            LOGGER.error("Error parsing top/bottom query response", (Throwable)e);
            return Collections.emptyMap();
        }
        JSONArray dataItems = (JSONArray)json.get((Object)JSON_DATAITEMS);
        JSONArray data = (JSONArray)json.get((Object)JSON_DATA);
        return this.parseData(dataItems, data);
    }

    private Map<String, String> parseData(JSONArray dataItems, JSONArray data) {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        JSONObject dataEl = (JSONObject)data.get(0);
        JSONArray ptArray = (JSONArray)dataEl.get((Object)"pt");
        for (int dataItemId = 0; dataItemId < dataItems.size(); ++dataItemId) {
            JSONObject dataItem = (JSONObject)dataItems.get(dataItemId);
            JSONObject itemClass = (JSONObject)dataItem.get((Object)"itemClass");
            JSONArray h = (JSONArray)itemClass.get((Object)"h");
            JSONObject hItem = (JSONObject)h.get(0);
            String itemId = (String)hItem.get((Object)"u");
            JSONObject pt = (JSONObject)ptArray.get(dataItemId);
            Object v = pt.get((Object)"v");
            dataMap.put(itemId, v.toString());
        }
        return dataMap;
    }

    private void parseQuartiles(String response, List<Pair<String, String>> topQuartiles, List<Pair<String, String>> bottomQuartiles, List<Pair<String, String>> middle) {
        JSONObject json;
        try {
            json = JSONObject.parse((String)response);
        }
        catch (IOException e) {
            LOGGER.error("Error parsing top/bottom query response", (Throwable)e);
            return;
        }
        List<Pair<String, String>> dataItems = this.parseDataItems((JSONArray)json.get((Object)JSON_DATAITEMS));
        if (dataItems.size() <= 1) {
            return;
        }
        int quartileSize = dataItems.size() / 4;
        topQuartiles.addAll(dataItems.subList(0, quartileSize));
        bottomQuartiles.addAll(dataItems.subList(dataItems.size() - quartileSize, dataItems.size()));
        middle.addAll(dataItems.subList(quartileSize, dataItems.size() - quartileSize));
    }

    private JSONArray generateFilters(List<String> includedValues, String itemId) {
        JSONArray filterArray = new JSONArray();
        JSONObject filter = new JSONObject();
        filter.put((Object)"type", (Object)"pre");
        JSONObject expression = new JSONObject();
        expression.put((Object)"operator", (Object)IN);
        expression.put((Object)"itemId", (Object)itemId);
        JSONArray valuesArray = new JSONArray();
        for (String includedValue : includedValues) {
            valuesArray.add((Object)includedValue);
        }
        expression.put((Object)"values", (Object)valuesArray);
        filter.put((Object)"expression", (Object)expression);
        filterArray.add((Object)filter);
        return filterArray;
    }

    private void generateSpecForFilters(JSONArray filters, List<BaseFilter> baseFilters) {
        InclusionExclusionFilter filter;
        List inclusionExclusionFilters = baseFilters.stream().filter(f -> f.getType().equals((Object)FilterType.INCLUSION_EXCLUSION)).collect(Collectors.toList());
        List numericFilters = baseFilters.stream().filter(f -> f.getType().equals((Object)FilterType.NUMERIC)).collect(Collectors.toList());
        for (BaseFilter inclFilter : inclusionExclusionFilters) {
            try {
                filter = inclFilter.toInclusionExclusionFilter();
                JSONObject inclFilterSpec = this.makeInclusionFilterSpec(filter);
                filters.add((Object)inclFilterSpec);
            }
            catch (FilterTypeConversionException e) {
                LOGGER.error("Failed to convert base filter to Inclusion Filter", (Throwable)e);
            }
        }
        for (BaseFilter numFilter : numericFilters) {
            try {
                filter = numFilter.toNumericFilter();
                JSONObject numericFilterSpec = this.makeNumericFilterSpec((NumericFilter)filter);
                filters.add((Object)numericFilterSpec);
            }
            catch (FilterTypeConversionException e) {
                LOGGER.error("Failed to convert base filter to Numeric Filter", (Throwable)e);
            }
        }
    }

    private JSONObject makeNumericFilterSpec(NumericFilter numFilter) {
        String itemId = numFilter.getColumnId();
        String operator = this.getOperatorFromNumericOperator(numFilter.getOperator());
        String value = numFilter.getValue();
        JSONObject expressionForNumeric = this.makeExpressionForNumeric(operator, itemId, value);
        JSONObject filterJson = new JSONObject();
        PreOrPostAggregation preOrPostAggregation = PreOrPostAggregation.PRE;
        if (numFilter.getFilterAggregation() != null && numFilter.getFilterAggregation().getPreOrPostAggregation() != null) {
            preOrPostAggregation = numFilter.getFilterAggregation().getPreOrPostAggregation();
        }
        filterJson.put((Object)"type", (Object)preOrPostAggregation.name().toLowerCase());
        filterJson.put((Object)"expression", (Object)expressionForNumeric);
        return filterJson;
    }

    private JSONObject makeExpressionForNumeric(String operator, String itemId, String value) {
        JSONObject expressionJson = new JSONObject();
        JSONArray valuesArray = new JSONArray();
        valuesArray.add((Object)value);
        expressionJson.put((Object)"operator", (Object)operator);
        expressionJson.put((Object)"itemId", (Object)itemId);
        expressionJson.put((Object)"values", (Object)valuesArray);
        return expressionJson;
    }

    private JSONObject makeInclusionFilterSpec(InclusionExclusionFilter inclFilter) {
        String itemId = inclFilter.getColumnId();
        List<String> inclValues = inclFilter.getInclusionValues().stream().map(val -> val.getUniqueValue()).collect(Collectors.toList());
        JSONObject expressionForInclValues = null;
        JSONObject expressionForFilterCondition = null;
        if (!inclValues.isEmpty()) {
            String operator = inclFilter.getInvertFlag() ? NOT_IN : IN;
            expressionForInclValues = this.makeExpressionForInclusion(operator, itemId, inclValues, null, Optional.empty());
        }
        if (inclFilter.getFilterCondition() != null) {
            FilterCondition filterCondition = inclFilter.getFilterCondition();
            String operator = this.getOperatorFromCategoricalCondition(filterCondition.getCondition());
            Boolean ignoreCase = filterCondition.getIgnoreCase();
            List values = filterCondition.getValues();
            JSONObject expression = this.makeExpressionForInclusion(operator, itemId, values, "display", Optional.of(ignoreCase));
            if (inclFilter.getInvertFlag()) {
                expressionForFilterCondition = new JSONObject();
                expressionForFilterCondition.put((Object)"not", (Object)expression);
            } else {
                expressionForFilterCondition = expression;
            }
        }
        JSONObject filterJson = new JSONObject();
        filterJson.put((Object)"type", (Object)PreOrPostAggregation.PRE.name().toLowerCase());
        if (expressionForFilterCondition != null && expressionForInclValues != null) {
            JSONArray orArray = new JSONArray();
            orArray.add((Object)expressionForInclValues);
            orArray.add(expressionForFilterCondition);
            JSONObject orJson = new JSONObject();
            orJson.put((Object)"or", (Object)orArray);
            filterJson.put((Object)"expression", (Object)orJson);
        } else if (expressionForInclValues != null) {
            filterJson.put((Object)"expression", (Object)expressionForInclValues);
        } else if (expressionForFilterCondition != null) {
            filterJson.put((Object)"expression", expressionForFilterCondition);
        }
        return filterJson;
    }

    private JSONObject makeExpressionForInclusion(String operator, String itemId, List<String> inclValues, String valueType, Optional<Boolean> ignoreCase) {
        JSONObject expressionJson = new JSONObject();
        JSONArray inclValuesArray = new JSONArray();
        inclValuesArray.addAll(inclValues);
        expressionJson.put((Object)"operator", (Object)operator);
        expressionJson.put((Object)"itemId", (Object)itemId);
        expressionJson.put((Object)"values", (Object)inclValuesArray);
        expressionJson.put((Object)"valueType", (Object)valueType);
        if (ignoreCase.isPresent()) {
            expressionJson.put((Object)"ignoreCase", (Object)ignoreCase.get());
        }
        return expressionJson;
    }

    private String getOperatorFromCategoricalCondition(CategoricalFilterCondition categoricalCondition) {
        switch (categoricalCondition) {
            case BEGINS_WITH: {
                return "beginswith";
            }
            case ENDS_WITH: {
                return "endswith";
            }
            case CONTAINS: {
                return "contains";
            }
            case EQUALS: {
                return IN;
            }
        }
        return null;
    }

    private String getOperatorFromNumericOperator(NumericOperator numericOperator) {
        switch (numericOperator) {
            case GREATER_THAN_EQUALS: {
                return "gte";
            }
            case LESS_THAN_EQUALS: {
                return "lte";
            }
            case GREATER_THAN: {
                return "gt";
            }
            case LESS_THAN: {
                return "lt";
            }
        }
        return null;
    }

    private void generateSpecForDataItemsProjections(JSONArray dataItems, JSONArray projections, String groupedByIdForExpr, TopBottomFilter filter, int n, Pair<String, AggregationType> aggregatedMeasure) {
        Pair<String, String> uniqueIds = this.generateUniqueIdsForSelection();
        JSONObject dataItem1 = this.makeDataItemJSON(uniqueIds.getLeft(), groupedByIdForExpr, Optional.empty());
        JSONObject dataItem2 = this.makeDataItemJSON(uniqueIds.getRight(), aggregatedMeasure.getLeft(), Optional.of(this.getQueryableAggregation(aggregatedMeasure.getRight())));
        dataItems.add((Object)dataItem1);
        dataItems.add((Object)dataItem2);
        JSONArray selection = new JSONArray();
        JSONObject topOrbottomSpec = this.makeTopOrBottomSpec(filter, n);
        JSONArray context = this.makeContext(aggregatedMeasure);
        JSONObject selection1 = this.makeSelectionJSON("keep", Optional.of(topOrbottomSpec), context, Optional.empty());
        selection.add((Object)selection1);
        JSONObject sort = this.makeSort();
        JSONObject selection2 = this.makeSelectionJSON("order", Optional.empty(), context, Optional.of(sort));
        selection.add((Object)selection2);
        dataItem1.put((Object)JSON_SELECTION, (Object)selection);
        projections.add((Object)uniqueIds.getLeft());
        projections.add((Object)uniqueIds.getRight());
    }

    private JSONObject makeSort() {
        JSONObject sort = new JSONObject();
        sort.put((Object)"type", (Object)"desc");
        sort.put((Object)"by", (Object)"value");
        sort.put((Object)"priority", (Object)1);
        return sort;
    }

    private JSONObject makeTopOrBottomSpec(TopBottomFilter filter, int n) {
        JSONObject topOrbottomSpec = new JSONObject();
        topOrbottomSpec.put((Object)"type", (Object)filter.getFilterStringType());
        topOrbottomSpec.put((Object)"value", (Object)n);
        return topOrbottomSpec;
    }

    private JSONArray makeContext(Pair<String, AggregationType> aggregatedMeasure) {
        JSONArray context = new JSONArray();
        JSONObject contextItem = new JSONObject();
        contextItem.put((Object)"itemId", (Object)aggregatedMeasure.getLeft());
        contextItem.put((Object)"aggregate", (Object)this.getQueryableAggregation(aggregatedMeasure.getRight()));
        context.add((Object)contextItem);
        return context;
    }

    private JSONObject makeSelectionJSON(String operation, Optional<JSONObject> topBottomSpec, JSONArray context, Optional<JSONObject> sort) {
        JSONObject selection = new JSONObject();
        selection.put((Object)"operation", (Object)operation);
        if (topBottomSpec.isPresent()) {
            selection.put((Object)"topBottom", (Object)topBottomSpec.get());
        }
        selection.put((Object)"context", (Object)context);
        if (sort.isPresent()) {
            selection.put((Object)"sort", (Object)sort.get());
        }
        return selection;
    }

    private JSONObject makeDataItemJSON(String id, String itemId, Optional<String> aggregate) {
        JSONObject dataItem = new JSONObject();
        dataItem.put((Object)"id", (Object)id);
        dataItem.put((Object)"itemId", (Object)itemId);
        if (aggregate.isPresent()) {
            dataItem.put((Object)"aggregate", (Object)aggregate.get());
        }
        return dataItem;
    }

    private Pair<String, String> generateUniqueIdsForSelection() {
        long id1Long = Math.round(this.randomizer.nextDouble() * 1.0E7);
        long id2Long = 0L;
        while ((id2Long = Math.round(this.randomizer.nextDouble() * 1.0E7)) == id1Long) {
        }
        String id1 = "id" + id1Long;
        String id2 = "id_" + id2Long;
        return new Pair<String, String>(id1, id2);
    }

    private String getQueryableAggregation(ColumnInfo aggregatedMeasure) {
        if (aggregatedMeasure.getSemanticInfo() != null && aggregatedMeasure.getSemanticInfo().getDefaultAggregation() != null) {
            return this.getQueryableAggregation(aggregatedMeasure.getSemanticInfo().getDefaultAggregation());
        }
        return "none";
    }

    private String getQueryableAggregation(AggregationType aggregationType) {
        if (aggregationType != null) {
            switch (aggregationType) {
                case SUM: {
                    return "sum";
                }
                case AVERAGE: {
                    return "avg";
                }
                case COUNT: {
                    return "count";
                }
                case COUNT_DISTINCT: {
                    return "countdistinct";
                }
                case MAXIMUM: {
                    return "max";
                }
                case MINIMUM: {
                    return "min";
                }
            }
            return "none";
        }
        return "none";
    }

    private List<Pair<String, String>> parseTopOrBottomResponse(String response) {
        JSONObject json;
        ArrayList<Pair<String, String>> dataValues = new ArrayList<Pair<String, String>>();
        try {
            json = JSONObject.parse((String)response);
        }
        catch (IOException e) {
            LOGGER.error("Error parsing top/bottom query response", (Throwable)e);
            return dataValues;
        }
        return this.parseDataItems((JSONArray)json.get((Object)JSON_DATAITEMS));
    }

    private List<Pair<String, String>> parseDataItems(JSONArray dataItems) {
        JSONObject dataItem;
        JSONArray items;
        ArrayList<Pair<String, String>> dataValues = new ArrayList<Pair<String, String>>();
        if (dataItems != null && !dataItems.isEmpty() && (items = (JSONArray)(dataItem = (JSONObject)dataItems.get(0)).get((Object)"items")) != null) {
            for (Object itemJSON : items) {
                JSONObject item = (JSONObject)itemJSON;
                JSONArray tArray = (JSONArray)item.get((Object)"t");
                JSONObject tJSON = (JSONObject)tArray.get(0);
                String u = "";
                if (tJSON.containsKey((Object)"u")) {
                    Object uObj = tJSON.get((Object)"u");
                    if (uObj instanceof Double) {
                        u = Double.toString((Double)tJSON.get((Object)"u"));
                    } else if (u instanceof String) {
                        u = (String)tJSON.get((Object)"u");
                    }
                }
                String displayName = "";
                if (tJSON.containsKey((Object)"d")) {
                    Object uObj = tJSON.get((Object)"d");
                    displayName = uObj.toString();
                }
                Pair<String, String> dataValue = new Pair<String, String>(u, displayName);
                dataValues.add(dataValue);
            }
        }
        return dataValues;
    }
}

