/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.content.recommender.internal;

import com.ibm.smarts.content.recommender.api.AnalysisScope;
import com.ibm.smarts.content.recommender.api.AnalysisType;
import com.ibm.smarts.content.recommender.api.ContentException;
import com.ibm.smarts.content.recommender.api.ExplainScope;
import com.ibm.smarts.content.recommender.api.IContentRecommender;
import com.ibm.smarts.content.recommender.api.PrescribeScope;
import com.ibm.smarts.content.recommender.api.TopicScope;
import com.ibm.smarts.content.recommender.api.content.ComparisonScope;
import com.ibm.smarts.content.recommender.api.content.IRCombination;
import com.ibm.smarts.content.recommender.api.content.IRContent;
import com.ibm.smarts.content.recommender.api.content.IRExplanation;
import com.ibm.smarts.content.recommender.api.content.IRPrescription;
import com.ibm.smarts.content.recommender.internal.SmartsStatus;
import com.ibm.smarts.content.recommender.internal.context.ComparisonContext;
import com.ibm.smarts.content.recommender.internal.context.ContentsContext;
import com.ibm.smarts.content.recommender.internal.context.ExplainContext;
import com.ibm.smarts.content.recommender.internal.context.PrescribeContext;
import com.ibm.smarts.content.recommender.internal.pipeline.compare.AggregateComparisons;
import com.ibm.smarts.content.recommender.internal.pipeline.compare.InvertFilter;
import com.ibm.smarts.content.recommender.internal.pipeline.compare.RecommendFilter;
import com.ibm.smarts.content.recommender.internal.pipeline.compare.ReplaceMeasure;
import com.ibm.smarts.content.recommender.internal.pipeline.compare.ReplaceMeasureInTopBottomFilter;
import com.ibm.smarts.content.recommender.internal.pipeline.content.AnalysisScopeResolution;
import com.ibm.smarts.content.recommender.internal.pipeline.content.ContentResolutionFromDecisionTree;
import com.ibm.smarts.content.recommender.internal.pipeline.content.DecisionTreeRetrieval;
import com.ibm.smarts.content.recommender.internal.pipeline.content.GuidedContentStep;
import com.ibm.smarts.content.recommender.internal.pipeline.content.PredictiveContentResolution;
import com.ibm.smarts.content.recommender.internal.pipeline.content.PrimaryContentAggregation;
import com.ibm.smarts.content.recommender.internal.pipeline.content.PrimaryTopicSelection;
import com.ibm.smarts.content.recommender.internal.pipeline.content.RelatedContentAnalysis;
import com.ibm.smarts.content.recommender.internal.pipeline.content.RelatedFieldsStep;
import com.ibm.smarts.content.recommender.internal.pipeline.content.SecondaryContentAggregation;
import com.ibm.smarts.content.recommender.internal.pipeline.content.TopBottomContentResolution;
import com.ibm.smarts.content.recommender.internal.pipeline.content.TopicResolution;
import com.ibm.smarts.content.recommender.internal.pipeline.content.UpdateNonPermissibleCombinations;
import com.ibm.smarts.content.recommender.internal.pipeline.explain.DriverComparisonSelection;
import com.ibm.smarts.content.recommender.internal.pipeline.explain.KeyDifferencesStep;
import com.ibm.smarts.content.recommender.internal.pipeline.prescribe.InfluencersSelection;
import com.ibm.smarts.content.recommender.internal.pipeline.prescribe.PrescriptionAnalysis;
import com.ibm.smarts.content.recommender.internal.pipeline.prescribe.RectangleOfDataSelection;
import com.ibm.smarts.content.recommender.internal.util.QuickAccessSmartsModule;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.fields.recommender.api.InterestingFieldsRecommender;
import com.ibm.smarts.fields.recommender.core.InterestingFieldsRecommenderImpl;
import com.ibm.smarts.ontology.service.KnowledgeDiscoveryService;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.FieldRecommendationRecord;
import com.ibm.smarts.schema.FieldsRecommendation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentRecommender
implements IContentRecommender {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContentRecommender.class);
    private static final double DEFAULT_MIN_DRIVER_CONFIDENCE = 0.1;
    private static final int DEFAULT_MAX_DRIVER_TREE_DEPTH = 2;
    private static final int DEFAULT_MAX_COMBINATIONS = 4;
    private final KnowledgeDiscoveryService kds;
    private final InterestingFieldsRecommender fieldRecommender;

    private Consumer<ContentsContext> buildPrimaryPipeline(AnalysisScope scope) {
        Consumer<ContentsContext> pipeline = new AnalysisScopeResolution();
        if (!scope.getPrimaryTopic().isPresent()) {
            pipeline = pipeline.andThen(new PrimaryTopicSelection()).andThen(new RelatedFieldsStep(this.fieldRecommender));
        }
        if (scope.isIncludePredictiveCombinations()) {
            pipeline = pipeline.andThen(new PredictiveContentResolution());
        }
        if (scope.getAnalysisType().equals((Object)AnalysisType.DETAILED)) {
            pipeline = pipeline.andThen(new DecisionTreeRetrieval()).andThen(new ContentResolutionFromDecisionTree(0.1, 2));
        }
        return pipeline.andThen(new RelatedContentAnalysis()).andThen(new PrimaryContentAggregation(true, 4, true));
    }

    private boolean isSecondaryStepNeeded(ContentsContext context) {
        if (context == null) {
            throw new ContentException(SmartsStatus.MISSING_CONTEXT);
        }
        if (context.getScope() == null) {
            throw new ContentException(SmartsStatus.MISSING_CONTEXT_SCOPE);
        }
        if (!context.getScope().getPrimaryTopic().isPresent()) {
            return false;
        }
        TopicScope primary = context.getScope().getPrimaryTopic().get();
        return primary.getFilter() != null && primary.getFilter().getByColumn() != null && context.getScope().getQueryableAssetId() != null && !context.getScope().getSecondaryTopics().isEmpty();
    }

    private Consumer<ContentsContext> buildSecondaryPipeline(AnalysisScope scope) {
        TopBottomContentResolution pipeline = new TopBottomContentResolution(scope.getPrimaryTopic().get());
        return pipeline.andThen(new RelatedFieldsStep(this.fieldRecommender)).andThen(new RelatedContentAnalysis()).andThen(new SecondaryContentAggregation(4, scope.getPrimaryTopic().get()));
    }

    private ContentsContext buildSecondaryContext(ContentsContext context) {
        TopicScope secondaryTopicToBecomePrimary = context.getScope().getSecondaryTopics().get(0);
        List<TopicScope> newSecondaries = context.getScope().getSecondaryTopics().subList(1, context.getScope().getSecondaryTopics().size());
        AnalysisScope secondaryFocusedScope = new AnalysisScope(context.getScope().getSmartsModule(), context.getScope().getSourceType(), context.getScope().getLocale(), newSecondaries);
        secondaryFocusedScope.setPrimaryTopic(secondaryTopicToBecomePrimary);
        secondaryFocusedScope.setIntents(context.getScope().getIntents());
        secondaryFocusedScope.setMaxCombinationSize(context.getScope().getMaxCombinationSize());
        secondaryFocusedScope.setQueryableAssetId(context.getScope().getQueryableAssetId());
        secondaryFocusedScope.setJoinableColumnMap(context.getScope().getJoinableColumnMap());
        secondaryFocusedScope.setFilters(context.getScope().getFilters());
        return new ContentsContext(secondaryFocusedScope, context.getRequestContext(), context.getInterestingFields(), context.getIndexedSM());
    }

    public ContentRecommender(KnowledgeDiscoveryService kds) {
        this.kds = kds;
        this.fieldRecommender = kds != null ? new InterestingFieldsRecommenderImpl(this.kds) : null;
    }

    public ContentRecommender(InterestingFieldsRecommender intFieldsRec) {
        this.kds = null;
        this.fieldRecommender = intFieldsRec;
    }

    @Override
    public List<IRContent> recommendIRs(AnalysisScope scope, RequestContext requestContext) {
        List<FieldRecommendationRecord> interestingFields = this.calculateInterestingFields(scope, requestContext);
        QuickAccessSmartsModule indexedSM = new QuickAccessSmartsModule(scope.getSmartsModule());
        ContentsContext context = new ContentsContext(scope, requestContext, interestingFields, indexedSM);
        this.validateAndUpdateAggregationInTopicScope(context);
        if (!scope.getPrimaryTopic().isPresent() && scope.getSecondaryTopics().isEmpty()) {
            TopicResolution step1 = new TopicResolution();
            List<AnalysisScope> preparedScopes = step1.prepare(context);
            ArrayList<SmartsStatus> contentExceptionSmartsStatus = new ArrayList<SmartsStatus>();
            for (AnalysisScope innerScope : preparedScopes) {
                Consumer<ContentsContext> pipeline = this.buildPrimaryPipeline(innerScope);
                ContentsContext innerContext = new ContentsContext(innerScope, requestContext, interestingFields, indexedSM);
                try {
                    pipeline.accept(innerContext);
                    context.getIRContents().addAll(innerContext.getIRContents());
                }
                catch (ContentException e) {
                    contentExceptionSmartsStatus.add(e.getSmartsStatus());
                }
            }
            if (context.getIRContents().isEmpty()) {
                if (contentExceptionSmartsStatus.stream().distinct().count() == 1L && contentExceptionSmartsStatus.get(0) == SmartsStatus.NO_RELATED_COMBINATIONS) {
                    throw new ContentException(SmartsStatus.NO_RELATED_COMBINATIONS);
                }
                throw new ContentException(SmartsStatus.GENERAL_NO_COMBINATIONS);
            }
        } else if (!scope.getSecondaryTopics().isEmpty() && !scope.getPrimaryTopic().isPresent()) {
            List<TopicScope> topics = this.selectBestTopics(scope.getSecondaryTopics(), scope.getMaxTopics(), interestingFields);
            for (TopicScope topicScope : topics) {
                context.getScope().setAnalysisType(AnalysisType.GUIDED);
                context.getScope().setPrimaryTopic(topicScope);
                context.getScope().getSecondaryTopics().remove(topicScope);
                Consumer<ContentsContext> pipeline = this.buildPrimaryPipeline(context.getScope());
                pipeline = pipeline.andThen(new GuidedContentStep()).andThen(new UpdateNonPermissibleCombinations());
                pipeline.accept(context);
                context.getScope().getSecondaryTopics().add(topicScope);
            }
            this.putGuidedAsTopCombo(context.getIRContents(), context.getGuidedCombinations());
        } else {
            Consumer<ContentsContext> pipeline = this.buildPrimaryPipeline(scope);
            if (scope.getGuidedDashboard()) {
                pipeline = pipeline.andThen(new GuidedContentStep());
            }
            pipeline.accept(context);
            this.putGuidedAsTopCombo(context.getIRContents(), context.getGuidedCombinations());
        }
        return context.getIRContents();
    }

    List<TopicScope> selectBestTopics(List<TopicScope> topics, int maxNumTopics, List<FieldRecommendationRecord> interestingFields) {
        Collections.sort(topics, (topic1, topic2) -> {
            Optional<FieldRecommendationRecord> fieldRec1 = interestingFields.stream().filter(f -> f.getFieldIDForExpression().equals(topic1.getId())).findFirst();
            Optional<FieldRecommendationRecord> fieldRec2 = interestingFields.stream().filter(f -> f.getFieldIDForExpression().equals(topic2.getId())).findFirst();
            if (fieldRec1.isPresent() && !fieldRec2.isPresent()) {
                return -1;
            }
            if (fieldRec2.isPresent() && !fieldRec1.isPresent()) {
                return 1;
            }
            if (fieldRec1.isPresent() && fieldRec2.isPresent() && Float.compare(fieldRec1.get().getConfidence(), fieldRec2.get().getConfidence()) != 0) {
                return -1 * Float.compare(fieldRec1.get().getConfidence(), fieldRec2.get().getConfidence());
            }
            return topic1.getId().compareTo(topic2.getId());
        });
        return topics.stream().limit(maxNumTopics).collect(Collectors.toList());
    }

    @Override
    public List<IRContent> recommendInstanceIRs(AnalysisScope scope, RequestContext requestContext) {
        List<FieldRecommendationRecord> interestingFields = this.calculateInterestingFields(scope, requestContext);
        QuickAccessSmartsModule indexedSM = new QuickAccessSmartsModule(scope.getSmartsModule());
        ContentsContext context = new ContentsContext(scope, requestContext, interestingFields, indexedSM);
        this.validateAndUpdateAggregationInTopicScope(context);
        Consumer<ContentsContext> selectPrimaryTopic = new AnalysisScopeResolution().andThen(new PrimaryTopicSelection());
        selectPrimaryTopic.accept(context);
        if (this.isSecondaryStepNeeded(context)) {
            Consumer<ContentsContext> secondaryPipeline = this.buildSecondaryPipeline(scope);
            ContentsContext secondaryContext = this.buildSecondaryContext(context);
            secondaryPipeline.accept(secondaryContext);
            context.getIRContents().addAll(secondaryContext.getIRContents());
        }
        return context.getIRContents();
    }

    @Override
    public Map<String, List<IRContent>> recommendComparisons(ComparisonScope scope, RequestContext requestContext) {
        QuickAccessSmartsModule indexedSM = new QuickAccessSmartsModule(scope.getSmartsModule());
        HashMap<String, List<IRContent>> result = new HashMap<String, List<IRContent>>();
        scope.getIrContents().forEach(irContent -> {
            ComparisonContext context = new ComparisonContext((IRContent)irContent, scope, requestContext, indexedSM);
            Consumer<ComparisonContext> pipeline = this.buildComparisonPipeline(context, requestContext);
            pipeline.accept(context);
            result.put(irContent.getId(), context.getResult());
        });
        return result;
    }

    private Consumer<ComparisonContext> buildComparisonPipeline(ComparisonContext context, RequestContext requestContext) {
        return new InvertFilter().andThen(new ReplaceMeasureInTopBottomFilter(requestContext)).andThen(new ReplaceMeasure(requestContext)).andThen(new RecommendFilter(requestContext)).andThen(new AggregateComparisons(context.getMaxComparisonsPerIR()));
    }

    public List<FieldRecommendationRecord> calculateInterestingFields(AnalysisScope scope, RequestContext rc) {
        if (this.fieldRecommender != null) {
            com.ibm.smarts.schema.AnalysisScope interestingFieldsAnalysisScope = null;
            FieldsRecommendation rec = this.fieldRecommender.recommendInterestingFields(rc, scope.getSmartsModule(), interestingFieldsAnalysisScope);
            if (rec != null) {
                return rec.getRecommendedFields();
            }
        }
        return Collections.emptyList();
    }

    private void putGuidedAsTopCombo(List<IRContent> irContents, List<IRCombination> guidedCombinations) {
        if (!irContents.isEmpty() && !guidedCombinations.isEmpty()) {
            List<IRCombination> firstIrCombinations = irContents.get(0).getCombinations();
            boolean isRemoved = firstIrCombinations.remove(guidedCombinations.get(0));
            firstIrCombinations.add(0, guidedCombinations.get(0));
            if (!isRemoved) {
                firstIrCombinations.remove(firstIrCombinations.size() - 1);
            }
        }
    }

    private void validateAndUpdateAggregationInTopicScope(ContentsContext context) {
        Optional<TopicScope> primaryTopic = context.getScope().getPrimaryTopic();
        if (primaryTopic.isPresent()) {
            ColumnInfo primaryColumnInfo = context.getIndexedSM().getColumnInfo(primaryTopic.get().getId());
            if (primaryColumnInfo == null) {
                throw new ContentException(SmartsStatus.MISSING_INDEXED_COLUMN_INFO);
            }
            if (primaryTopic.get().getAggregationType() == null) {
                primaryTopic.get().setAggregationType(primaryColumnInfo.getDefaultAggregation(), false);
            }
        }
        if (!context.getScope().getSecondaryTopics().isEmpty()) {
            for (TopicScope topicScope : context.getScope().getSecondaryTopics()) {
                ColumnInfo secondaryColumnInfo = context.getIndexedSM().getColumnInfo(topicScope.getId());
                if (secondaryColumnInfo == null) {
                    throw new ContentException(SmartsStatus.MISSING_INDEXED_COLUMN_INFO);
                }
                if (topicScope.getAggregationType() != null) continue;
                topicScope.setAggregationType(secondaryColumnInfo.getDefaultAggregation(), false);
            }
        }
    }

    @Override
    public List<IRExplanation> recommendExplanationComparison(ExplainScope explainScope, RequestContext requestContext) {
        ExplainContext context = new ExplainContext(requestContext, explainScope, this.fieldRecommender);
        Consumer<ExplainContext> pipeline = this.buildExplainPipeline();
        pipeline.accept(context);
        return context.getComparisons();
    }

    private Consumer<ExplainContext> buildExplainPipeline() {
        return new DriverComparisonSelection().andThen(new KeyDifferencesStep());
    }

    @Override
    public List<IRPrescription> recommendPrescriptions(PrescribeScope prescribeScope, RequestContext requestContext) {
        PrescribeContext context = new PrescribeContext(requestContext, prescribeScope, this.fieldRecommender);
        Consumer<PrescribeContext> pipeline = this.buildPrescribePipeline();
        pipeline.accept(context);
        return context.getPrescriptions();
    }

    private Consumer<PrescribeContext> buildPrescribePipeline() {
        return new InfluencersSelection().andThen(new RectangleOfDataSelection()).andThen(new PrescriptionAnalysis());
    }
}

