/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.content.recommender.internal.context;

import com.ibm.smarts.ca.core.impl.SmartsCaClientManager;
import com.ibm.smarts.content.recommender.api.ExplainScope;
import com.ibm.smarts.content.recommender.api.content.IRExplanation;
import com.ibm.smarts.content.recommender.internal.util.QuickAccessSmartsModule;
import com.ibm.smarts.core.util.ObjectCreator;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.fields.recommender.api.InterestingFieldsRecommender;
import java.util.ArrayList;
import java.util.List;

public class ExplainContext {
    private final RequestContext requestContext;
    private final SmartsCaClientManager clientManager;
    private final ExplainScope explainScope;
    private final List<IRExplanation> comparisons;
    private final QuickAccessSmartsModule indexedSM;
    private final List<String> keyDrivers;
    private final InterestingFieldsRecommender interestingFieldsRecommender;

    public ExplainContext(RequestContext requestContext, ExplainScope explainScope, InterestingFieldsRecommender interestingFieldsRecommender) {
        this.requestContext = requestContext;
        this.clientManager = this.getSmartsCaClientManager(requestContext);
        this.explainScope = explainScope;
        this.indexedSM = new QuickAccessSmartsModule(explainScope.getSmartsModule());
        this.comparisons = new ArrayList<IRExplanation>();
        this.keyDrivers = new ArrayList<String>();
        this.interestingFieldsRecommender = interestingFieldsRecommender;
    }

    public RequestContext getRequestContext() {
        return this.requestContext;
    }

    public SmartsCaClientManager getClientManager() {
        return this.clientManager;
    }

    public ExplainScope getExplainScope() {
        return this.explainScope;
    }

    public List<IRExplanation> getComparisons() {
        return this.comparisons;
    }

    private SmartsCaClientManager getSmartsCaClientManager(RequestContext requestContext) {
        if (requestContext == null) {
            return null;
        }
        ObjectCreator clientManagerCreator = (ObjectCreator)requestContext.getRequestAttribute("com.ibm.smarts.rest.clientManager");
        if (clientManagerCreator == null) {
            return null;
        }
        return (SmartsCaClientManager)clientManagerCreator.create(requestContext);
    }

    public QuickAccessSmartsModule getIndexedSM() {
        return this.indexedSM;
    }

    public InterestingFieldsRecommender getInterestingFieldsRecommender() {
        return this.interestingFieldsRecommender;
    }

    public List<String> getKeyDrivers() {
        return this.keyDrivers;
    }
}

