/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.content.recommender.internal.context;

import com.ibm.smarts.ca.core.impl.SmartsCaClientManager;
import com.ibm.smarts.content.recommender.api.PrescribeScope;
import com.ibm.smarts.content.recommender.api.content.IRPrescription;
import com.ibm.smarts.content.recommender.internal.util.QuickAccessSmartsModule;
import com.ibm.smarts.core.util.ObjectCreator;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.db.query.util.RectangleOfData;
import com.ibm.smarts.fields.recommender.api.InterestingFieldsRecommender;
import java.util.ArrayList;
import java.util.List;

public class PrescribeContext {
    private final RequestContext requestContext;
    private final SmartsCaClientManager clientManager;
    private final PrescribeScope prescribeScope;
    private final List<IRPrescription> prescriptions;
    private final QuickAccessSmartsModule indexedSM;
    private final List<String> keyDrivers;
    private final InterestingFieldsRecommender interestingFieldsRecommender;
    private RectangleOfData rectangleOfData;

    public PrescribeContext(RequestContext requestContext, PrescribeScope prescribeScope, InterestingFieldsRecommender interestingFieldsRecommender) {
        this.requestContext = requestContext;
        this.clientManager = this.getSmartsCaClientManager(requestContext);
        this.prescribeScope = prescribeScope;
        this.indexedSM = new QuickAccessSmartsModule(prescribeScope.getSmartsModule());
        this.prescriptions = new ArrayList<IRPrescription>();
        this.keyDrivers = new ArrayList<String>();
        this.interestingFieldsRecommender = interestingFieldsRecommender;
    }

    public RequestContext getRequestContext() {
        return this.requestContext;
    }

    public SmartsCaClientManager getClientManager() {
        return this.clientManager;
    }

    public PrescribeScope getPrescribeScope() {
        return this.prescribeScope;
    }

    public List<IRPrescription> getPrescriptions() {
        return this.prescriptions;
    }

    private SmartsCaClientManager getSmartsCaClientManager(RequestContext requestContext) {
        if (requestContext == null) {
            return null;
        }
        ObjectCreator clientManagerCreator = (ObjectCreator)requestContext.getRequestAttribute("com.ibm.smarts.rest.clientManager");
        if (clientManagerCreator == null) {
            return null;
        }
        return (SmartsCaClientManager)clientManagerCreator.create(requestContext);
    }

    public QuickAccessSmartsModule getIndexedSM() {
        return this.indexedSM;
    }

    public InterestingFieldsRecommender getInterestingFieldsRecommender() {
        return this.interestingFieldsRecommender;
    }

    public List<String> getKeyDrivers() {
        return this.keyDrivers;
    }

    public RectangleOfData getRectangleOfData() {
        return this.rectangleOfData;
    }

    public void setRectangleOfData(RectangleOfData rectangleOfData) {
        this.rectangleOfData = rectangleOfData;
    }
}

