/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.content.recommender.internal.pipeline.compare;

import com.ibm.smarts.content.recommender.api.ContentException;
import com.ibm.smarts.content.recommender.internal.SmartsStatus;
import com.ibm.smarts.content.recommender.internal.context.ComparisonContext;
import com.ibm.smarts.content.recommender.internal.pipeline.compare.ICompareStep;
import java.util.Comparator;
import java.util.stream.Collectors;

public class AggregateComparisons
implements ICompareStep {
    private int maxResultsNumber;

    public AggregateComparisons(int maxResultsNumber) {
        this.maxResultsNumber = maxResultsNumber;
    }

    @Override
    public void accept(ComparisonContext context) {
        if (context == null) {
            throw new ContentException(SmartsStatus.MISSING_CONTEXT);
        }
        context.setResult(context.getResult().stream().filter(r -> !r.getCombinations().isEmpty()).distinct().sorted(Comparator.comparingDouble(r -> r.getScore()).reversed()).limit(this.maxResultsNumber).collect(Collectors.toList()));
    }
}

