/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.content.recommender.internal.pipeline.compare;

import com.ibm.smarts.common.modifiers.BaseFilter;
import com.ibm.smarts.content.recommender.api.AnalysisScope;
import com.ibm.smarts.content.recommender.api.ContentException;
import com.ibm.smarts.content.recommender.api.TopicScope;
import com.ibm.smarts.content.recommender.api.content.IRColumn;
import com.ibm.smarts.content.recommender.internal.SmartsStatus;
import com.ibm.smarts.content.recommender.internal.context.ComparisonContext;
import com.ibm.smarts.content.recommender.internal.context.ContentsContext;
import com.ibm.smarts.content.recommender.internal.pipeline.content.RelatedContentAnalysis;
import com.ibm.smarts.content.recommender.internal.util.Pair;
import com.ibm.smarts.content.recommender.internal.util.StdChartConcepts;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.ontology.registry.Concept;
import com.ibm.smarts.ontology.registry.ConceptsRegistry;
import com.ibm.smarts.schema.AggregationType;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.ConceptInfo;
import com.ibm.smarts.schema.DatasetInfo;
import com.ibm.smarts.schema.LogicalGroup;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.schema.StatisticType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ComparisonUtils {
    private static final String MEASURE_CONCEPT = "Measure";
    private static final String DOMAIN_CONCEPT = "domain";
    protected static final double MEASURE_SCALE_LIMIT = 0.7;
    private static final int MAX_COLUMNS_TO_CONSIDER = 500;

    public static List<String> findComparableLogicalGroupMeasure(String columnIdForExpression, ComparisonContext context) {
        SmartsModule smartsModule = context.getSmartsModule();
        List plannedAndActualColumnsList = smartsModule.getDatasets().stream().flatMap(d -> d.getLogicalGroups().stream()).map(logicalGroup -> ComparisonUtils.getPlannedAndActualColumns(logicalGroup)).filter(columnIds -> columnIds != null && columnIds.contains(columnIdForExpression)).collect(Collectors.toList());
        if (plannedAndActualColumnsList.isEmpty()) {
            return Collections.emptyList();
        }
        return plannedAndActualColumnsList.stream().flatMap(s -> s.stream().filter(c -> !c.equals(columnIdForExpression))).collect(Collectors.toList());
    }

    private static List<ConceptInfo> getFlattenedConceptsList(List<ConceptInfo> ci) {
        if (ci.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ConceptInfo> conceptsList = new ArrayList<ConceptInfo>();
        for (ConceptInfo concept : ci) {
            Concept c = ConceptsRegistry.instance().getConcept(concept.getConceptID());
            if (c == null) continue;
            conceptsList.add(concept);
            if (c.getParents().isEmpty()) continue;
            conceptsList.addAll(c.getAncestors().stream().map(a -> a.toConceptInfo(concept.getConfidence())).collect(Collectors.toList()));
        }
        return conceptsList.stream().distinct().collect(Collectors.toList());
    }

    public static List<Pair<IRColumn, ColumnInfo>> findComparableMeasures(ComparisonContext context, RequestContext requestContext, List<Pair<IRColumn, ColumnInfo>> columns) {
        ContentsContext contentcContext;
        block4: {
            List<TopicScope> topics = columns.stream().map(c -> new TopicScope(((ColumnInfo)c.getRight()).getIdForExpression())).collect(Collectors.toList());
            if (topics.isEmpty()) {
                return Collections.emptyList();
            }
            AnalysisScope scope = new AnalysisScope(context.getSmartsModule(), null, requestContext.locale, (TopicScope)topics.get(0), topics);
            scope.setJoinableColumnMap(context.getJoinableColumnMap());
            contentcContext = new ContentsContext(scope, requestContext, Collections.emptyList(), context.getIndexedSmartsModule());
            try {
                RelatedContentAnalysis related = new RelatedContentAnalysis();
                related.accept(contentcContext);
            }
            catch (ContentException ce) {
                if (ce.getSmartsStatus().equals((Object)SmartsStatus.NO_RELATED_COMBINATIONS) || ce.getSmartsStatus().equals((Object)SmartsStatus.GENERAL_NO_COMBINATIONS)) break block4;
                throw ce;
            }
        }
        Map<String, ColumnInfo> allMeasures = ComparisonUtils.getAllJoinableMeasures(context, contentcContext, columns);
        List measureIds = allMeasures.values().stream().map(m -> m.getIdForExpression()).collect(Collectors.toList());
        Set measuresInContext = columns.stream().filter(c -> allMeasures.containsKey(((ColumnInfo)c.getRight()).getIdForExpression())).collect(Collectors.toSet());
        Map<Pair, List> conceptMap = measuresInContext.stream().collect(Collectors.toMap(col -> col, col -> ComparisonUtils.getFlattenedConceptsList(((ColumnInfo)col.getRight()).getSemanticInfo().getConcepts()), (c1, c2) -> c1));
        Function<ColumnInfo, List> getMinMaxStats = columnInfo -> {
            if (columnInfo.getStatistics() == null) {
                return Collections.emptyList();
            }
            return columnInfo.getStatistics().stream().filter(s -> s.getType() == StatisticType.MAX_VALUE || s.getType() == StatisticType.MIN_VALUE).map(s -> {
                if (s.getValue() != null) {
                    return s.getValue().doubleValue();
                }
                return 0.0;
            }).sorted().collect(Collectors.toList());
        };
        BiPredicate<ColumnInfo, ColumnInfo> checkStatisticsCompatible = (srcMeasure, candidateMeasure) -> {
            List candidateMinMax = (List)getMinMaxStats.apply((ColumnInfo)srcMeasure);
            List replaceCandidateSMinMax = (List)getMinMaxStats.apply((ColumnInfo)candidateMeasure);
            if (candidateMinMax.size() == 2 && replaceCandidateSMinMax.size() == 2) {
                double denominator;
                double nominator;
                double diff1 = Math.abs((Double)candidateMinMax.get(0) - (Double)candidateMinMax.get(1));
                double diff2 = Math.abs((Double)replaceCandidateSMinMax.get(0) - (Double)replaceCandidateSMinMax.get(1));
                double absoluteMin = Math.abs(Math.min((Double)candidateMinMax.get(0), (Double)replaceCandidateSMinMax.get(0)));
                if (diff1 < diff2) {
                    nominator = diff1;
                    denominator = diff2;
                } else {
                    nominator = diff2;
                    denominator = diff1;
                }
                if (denominator != 0.0 && (denominator > 1.0 || absoluteMin < 1.0) && Math.abs(Math.log10(nominator / denominator)) > 0.7) {
                    return false;
                }
                if ((Double)candidateMinMax.get(1) < (Double)replaceCandidateSMinMax.get(0) || (Double)replaceCandidateSMinMax.get(1) < (Double)candidateMinMax.get(0)) {
                    return false;
                }
            }
            return true;
        };
        BiFunction<List, Boolean, List> findComparable = (candidates, checkOnConcepts) -> candidates.stream().map(col -> (ColumnInfo)allMeasures.get(col.getIdForExpression())).filter(Objects::nonNull).filter(col -> !measuresInContext.stream().map(m -> (ColumnInfo)m.getRight()).anyMatch(info -> info.getIdForExpression().equals(col.getIdForExpression()))).flatMap(info -> {
            if (!checkOnConcepts.booleanValue()) {
                return Stream.of(new Pair<IRColumn, ColumnInfo>(new IRColumn(info.getIdForExpression()), (ColumnInfo)info));
            }
            Set candidateConcepts = ComparisonUtils.getFlattenedConceptsList(info.getSemanticInfo().getConcepts()).stream().map(candidConcept -> candidConcept.getConceptID()).collect(Collectors.toSet());
            return measuresInContext.stream().map(in -> {
                AggregationType agg = ((IRColumn)in.getLeft()).getAggregation();
                if (agg != null ? !agg.equals((Object)info.getSemanticInfo().getDefaultAggregation()) : !((ColumnInfo)in.getRight()).getSemanticInfo().getDefaultAggregation().equals((Object)info.getSemanticInfo().getDefaultAggregation())) {
                    return null;
                }
                if (!checkStatisticsCompatible.test((ColumnInfo)info, (ColumnInfo)in.getRight())) {
                    return null;
                }
                List inConcepts = conceptMap.getOrDefault(in, Collections.emptyList());
                Optional<ConceptInfo> match = inConcepts.stream().filter(concept -> concept.getConceptID().contains(DOMAIN_CONCEPT)).filter(concept -> !concept.getConceptID().contains(MEASURE_CONCEPT)).filter(concept -> candidateConcepts.contains(concept.getConceptID())).findAny();
                if (match.isPresent()) {
                    return new Pair(in.getLeft(), (ColumnInfo)info);
                }
                return null;
            }).filter(Objects::nonNull);
        }).distinct().collect(Collectors.toList());
        if (!measuresInContext.isEmpty()) {
            return findComparable.apply(allMeasures.values().stream().collect(Collectors.toList()), true);
        }
        return findComparable.apply(contentcContext.getRelatedCombinations().stream().flatMap(rc -> rc.getColumns().stream().filter(col -> measureIds.contains(col))).map(col -> (ColumnInfo)allMeasures.get(col)).collect(Collectors.toList()), false);
    }

    private static Map<String, ColumnInfo> getAllJoinableMeasures(ComparisonContext context, ContentsContext contentcContext, List<Pair<IRColumn, ColumnInfo>> columns) {
        if (contentcContext.getScope().getJoinableColumnMap().isEmpty()) {
            return columns.stream().flatMap(c -> {
                DatasetInfo dataset = context.getIndexedSmartsModule().getDatasetInfo(((ColumnInfo)c.getRight()).getIdForExpression());
                if (dataset == null) {
                    return Stream.empty();
                }
                return context.getIndexedSmartsModule().getAllMeasures(dataset.getId()).stream();
            }).filter(Objects::nonNull).limit(500L).collect(Collectors.toMap(c -> c.getIdForExpression(), c -> c, (c1, c2) -> c1));
        }
        HashSet<String> previouslyCheckedColumnIds = new HashSet<String>();
        HashMap<String, ColumnInfo> returnMap = new HashMap<String, ColumnInfo>();
        for (Pair<IRColumn, ColumnInfo> pair : columns) {
            Set<String> joinableColumnIds = contentcContext.getScope().getJoinableColumnMap().get(pair.getRight().getIdForExpression());
            if (joinableColumnIds == null) continue;
            for (String joinableColumnId : joinableColumnIds) {
                List<ColumnInfo> allMeasuresDataset;
                if (previouslyCheckedColumnIds.contains(joinableColumnId)) continue;
                previouslyCheckedColumnIds.add(joinableColumnId);
                DatasetInfo ds = context.getIndexedSmartsModule().getDatasetInfo(joinableColumnId);
                if (ds == null || !(allMeasuresDataset = context.getIndexedSmartsModule().getAllMeasures(ds.getId())).stream().anyMatch(c -> c.getIdForExpression().equals(joinableColumnId))) continue;
                returnMap.put(joinableColumnId, context.getIndexedSmartsModule().getColumnInfo(joinableColumnId));
                if (returnMap.size() != 500) continue;
                return returnMap;
            }
        }
        return returnMap;
    }

    private static Set<String> getPlannedAndActualColumns(LogicalGroup logicalGroup) {
        boolean isPlanned = false;
        boolean isActual = false;
        HashSet<String> res = new HashSet<String>();
        for (LogicalGroup.Member m : logicalGroup.getMember()) {
            String memberConcept = m.getAttribute().getConceptID();
            if (memberConcept.equals(StdChartConcepts.PLANNED.getId())) {
                isPlanned = true;
            } else if (memberConcept.equals(StdChartConcepts.ACTUAL.getId())) {
                isActual = true;
            }
            res.add(m.getIdForExpression());
        }
        return isPlanned && isActual ? res : null;
    }

    public static List<BaseFilter> replaceFilter(List<BaseFilter> filters, BaseFilter delta) {
        List<BaseFilter> deltaFilters = filters.stream().filter(f -> !f.getFilterId().equals(delta.getFilterId())).collect(Collectors.toList());
        deltaFilters.add(delta);
        return deltaFilters;
    }
}

