/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.content.recommender.internal.pipeline.compare;

import com.ibm.smarts.common.modifiers.BaseFilter;
import com.ibm.smarts.common.modifiers.CompositeFilter;
import com.ibm.smarts.common.modifiers.InclusionExclusionFilter;
import com.ibm.smarts.common.modifiers.NumericFilter;
import com.ibm.smarts.common.modifiers.NumericRangeFilter;
import com.ibm.smarts.common.modifiers.TopBottomFilter;
import com.ibm.smarts.content.recommender.api.ContentException;
import com.ibm.smarts.content.recommender.api.content.IRCombination;
import com.ibm.smarts.content.recommender.api.content.IRContent;
import com.ibm.smarts.content.recommender.internal.CompareCardLabel;
import com.ibm.smarts.content.recommender.internal.SmartsStatus;
import com.ibm.smarts.content.recommender.internal.context.ComparisonContext;
import com.ibm.smarts.content.recommender.internal.pipeline.compare.ComparisonUtils;
import com.ibm.smarts.content.recommender.internal.pipeline.compare.ICompareStep;
import java.util.List;

public class InvertFilter
implements ICompareStep {
    private static final double INVERT_FILTER_CONFIDANCE = 1.0;

    @Override
    public void accept(ComparisonContext context) {
        if (context == null) {
            throw new ContentException(SmartsStatus.MISSING_CONTEXT);
        }
        this.process(context);
    }

    private void process(ComparisonContext context) {
        IRContent inputContent = context.getInputIRContent();
        inputContent.getGlobalFilters().forEach(srcFilter -> this.processGlobalFilter(context, inputContent, (BaseFilter)srcFilter));
        inputContent.getCombinations().forEach(combination -> combination.getFilters().forEach(f -> this.processFilterInCombination(context, inputContent, (IRCombination)combination, (BaseFilter)f)));
    }

    private void processGlobalFilter(ComparisonContext context, IRContent inputContent, BaseFilter srcFilter) {
        BaseFilter invertedFilter = InvertFilter.invertFilter(srcFilter);
        if (invertedFilter != null) {
            IRContent deltaContent = new IRContent(inputContent);
            List<BaseFilter> deltaFilters = ComparisonUtils.replaceFilter(deltaContent.getGlobalFilters(), invertedFilter);
            deltaContent.setGlobalFilters(deltaFilters);
            deltaContent.setScore(1.0);
            deltaContent.setDetails(CompareCardLabel.INVERT_FILTER.name());
            context.addToResult(deltaContent);
        }
    }

    private void processFilterInCombination(ComparisonContext context, IRContent inputContent, IRCombination combination, BaseFilter srcFilter) {
        BaseFilter invertedFilter = InvertFilter.invertFilter(srcFilter);
        if (invertedFilter != null) {
            IRCombination deltaCombination = new IRCombination(combination);
            List<BaseFilter> deltaFilters = ComparisonUtils.replaceFilter(deltaCombination.getFilters(), invertedFilter);
            deltaCombination.setFilters(deltaFilters);
            IRContent deltaContent = new IRContent(inputContent);
            deltaContent.getCombinations().remove(combination);
            deltaContent.getCombinations().add(deltaCombination);
            deltaContent.setScore(1.0);
            deltaContent.setDetails(CompareCardLabel.INVERT_FILTER.name());
            context.addToResult(deltaContent);
        }
    }

    private static BaseFilter invertFilter(BaseFilter srcFilter) {
        switch (srcFilter.getType()) {
            case INCLUSION_EXCLUSION: {
                return InclusionExclusionFilter.negate((InclusionExclusionFilter)((InclusionExclusionFilter)srcFilter));
            }
            case NUMERIC: {
                return NumericFilter.negate((NumericFilter)((NumericFilter)srcFilter));
            }
            case COMPOSITE: {
                return CompositeFilter.negate((CompositeFilter)((CompositeFilter)srcFilter));
            }
            case TOP_BOTTOM: {
                return TopBottomFilter.negate((TopBottomFilter)((TopBottomFilter)srcFilter));
            }
            case NUMERICRANGE: {
                return NumericRangeFilter.negate((NumericRangeFilter)((NumericRangeFilter)srcFilter));
            }
        }
        return null;
    }
}

