/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.content.recommender.internal.pipeline.content;

import com.ibm.smarts.content.recommender.api.ContentException;
import com.ibm.smarts.content.recommender.api.TopicScope;
import com.ibm.smarts.content.recommender.internal.SmartsStatus;
import com.ibm.smarts.content.recommender.internal.context.CandidateCombination;
import com.ibm.smarts.content.recommender.internal.context.ContentsContext;
import com.ibm.smarts.content.recommender.internal.pipeline.content.IContentStep;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.DatasetInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class PredictiveContentResolution
implements IContentStep {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void accept(ContentsContext context) {
        if (context == null) {
            throw new ContentException(SmartsStatus.MISSING_CONTEXT);
        }
        if (context.getScope() == null || context.getScope().getSmartsModule() == null) {
            throw new ContentException(SmartsStatus.MISSING_CONTEXT_SCOPE);
        }
        Optional<TopicScope> topic = context.getScope().getPrimaryTopic();
        if (!topic.isPresent()) throw new ContentException(SmartsStatus.PRIMARY_TOPIC_MISSING);
        String topicId = topic.get().getId();
        DatasetInfo ds = context.getResolvedTopic().getTopicsToDatasets().get(topicId);
        if (ds == null) throw new ContentException(SmartsStatus.DATASET_INFO_MISSING);
        List<ColumnInfo> measures = context.getIndexedSM().getAllMeasures(ds.getId());
        if (!measures.stream().anyMatch(c -> c.getIdForExpression().equals(topicId))) return;
        ArrayList<String> columns = new ArrayList<String>();
        columns.add(topicId);
        context.addPredictiveCandidateCombination(new CandidateCombination(columns, topicId, 1.0));
    }
}

