/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.content.recommender.internal.pipeline.content;

import com.ibm.smarts.content.recommender.api.AnalysisScope;
import com.ibm.smarts.content.recommender.api.ContentException;
import com.ibm.smarts.content.recommender.internal.ContentInfluencersUtil;
import com.ibm.smarts.content.recommender.internal.SmartsStatus;
import com.ibm.smarts.content.recommender.internal.context.ContentsContext;
import com.ibm.smarts.content.recommender.internal.pipeline.content.IContentStep;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.fields.recommender.api.InterestingFieldsRecommender;
import com.ibm.smarts.schema.FieldRecommendationRecord;
import java.util.Collections;
import java.util.List;

public class RelatedFieldsStep
implements IContentStep {
    private final InterestingFieldsRecommender fieldRecommender;

    public RelatedFieldsStep(InterestingFieldsRecommender fieldRec) {
        this.fieldRecommender = fieldRec;
    }

    @Override
    public void accept(ContentsContext context) {
        if (context == null) {
            throw new ContentException(SmartsStatus.MISSING_CONTEXT);
        }
        if (context.getScope() == null) {
            throw new ContentException(SmartsStatus.MISSING_CONTEXT_SCOPE);
        }
        context.setInfluencers(this.calculateRelatedFields(context.getScope(), context.getRequestContext()));
    }

    private List<FieldRecommendationRecord> calculateRelatedFields(AnalysisScope scope, RequestContext rc) {
        if (this.fieldRecommender != null && scope.getPrimaryTopic().isPresent()) {
            return ContentInfluencersUtil.calculateRelatedFields(this.fieldRecommender, rc, scope.getSmartsModule(), scope.getPrimaryTopic().get().getId());
        }
        return Collections.emptyList();
    }
}

