/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.content.recommender.internal.pipeline.content;

import com.ibm.smarts.content.recommender.api.AnalysisScope;
import com.ibm.smarts.content.recommender.api.ContentException;
import com.ibm.smarts.content.recommender.api.TopicScope;
import com.ibm.smarts.content.recommender.internal.CandidateTopicGenerator;
import com.ibm.smarts.content.recommender.internal.SmartsStatus;
import com.ibm.smarts.content.recommender.internal.context.ContentsContext;
import com.ibm.smarts.schema.ColumnInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TopicResolution {
    public List<AnalysisScope> prepare(ContentsContext context) {
        if (context == null) {
            throw new ContentException(SmartsStatus.MISSING_CONTEXT);
        }
        if (context.getScope() != null) {
            ArrayList<AnalysisScope> preparedScopes = new ArrayList<AnalysisScope>();
            CandidateTopicGenerator topicGenerator = new CandidateTopicGenerator(context.getIndexedSM());
            List<ColumnInfo> suggestedColumns = topicGenerator.getInterestingCandidates(context.getInterestingFields(), context.getScope().getMaxTopics());
            for (ColumnInfo sugg : suggestedColumns) {
                TopicScope primary = new TopicScope(sugg.getIdForExpression(), 1.0, true);
                AnalysisScope innerScope = new AnalysisScope(context.getScope().getSmartsModule(), context.getScope().getSourceType(), context.getScope().getLocale(), Collections.emptyList());
                innerScope.setPrimaryTopic(primary);
                innerScope.setIntents(context.getScope().getIntents());
                innerScope.setMaxCombinationSize(context.getScope().getMaxCombinationSize());
                innerScope.setMaxColumnCombinations(context.getScope().getMaxColumnCombinations());
                innerScope.setFilters(context.getScope().getFilters());
                innerScope.setExcludedColumns(context.getScope().getExcludedColumns());
                innerScope.setIncludedColumns(context.getScope().getIncludedColumns());
                innerScope.setAnalysisType(context.getScope().getAnalysisType());
                innerScope.setIncludePredictiveCombinations(context.getScope().isIncludePredictiveCombinations());
                innerScope.setJoinableColumnMap(context.getScope().getJoinableColumnMap());
                preparedScopes.add(innerScope);
            }
            return preparedScopes;
        }
        return Collections.emptyList();
    }
}

