/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.content.recommender.internal.pipeline.explain;

import com.ibm.smarts.common.modifiers.BaseFilter;
import com.ibm.smarts.common.modifiers.InclusionExclusionFilter;
import com.ibm.smarts.common.modifiers.MissingFilterParametersException;
import com.ibm.smarts.content.recommender.api.ContentException;
import com.ibm.smarts.content.recommender.api.content.IRExplanation;
import com.ibm.smarts.content.recommender.api.content.IRExplanationItem;
import com.ibm.smarts.content.recommender.internal.ContentQueryUtil;
import com.ibm.smarts.content.recommender.internal.SmartsStatus;
import com.ibm.smarts.content.recommender.internal.context.ExplainContext;
import com.ibm.smarts.content.recommender.internal.pipeline.explain.ExplanationType;
import com.ibm.smarts.content.recommender.internal.pipeline.explain.IExplainStep;
import com.ibm.smarts.content.recommender.internal.pipeline.explain.QualifierType;
import com.ibm.smarts.content.recommender.internal.util.CommonUtil;
import com.ibm.smarts.content.recommender.internal.util.Pair;
import com.ibm.smarts.model.value.DoubleValue;
import com.ibm.smarts.model.value.Value;
import com.ibm.smarts.schema.AggregationType;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.UsageType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class KeyDifferencesStep
implements IExplainStep {
    private ContentQueryUtil contentQueryUtil = null;
    private List<IRExplanation> explanationsByComparison = null;
    private String itemOfInterest = null;

    @Override
    public void accept(ExplainContext context) {
        InclusionExclusionFilter focalFieldfilter = CommonUtil.getFocalFieldFilter(context.getExplainScope().getFilters());
        if (focalFieldfilter == null) {
            throw new ContentException(SmartsStatus.INAPPOPRIATE_FILTER_FOR_COMPARISON_ANALYSIS);
        }
        this.itemOfInterest = focalFieldfilter.getFilterCondition() != null ? (String)focalFieldfilter.getFilterCondition().getValues().get(0) : ((InclusionExclusionFilter.DataValue)focalFieldfilter.getInclusionValues().get(0)).getDisplayValue();
        String focalFieldId = focalFieldfilter.getColumnId();
        if (!this.isMeasure(context, context.getExplainScope().getTargetColumnId()) || !this.isCategorical(context, focalFieldId)) {
            throw new ContentException(SmartsStatus.MEASURE_COMPARISON_ONLY);
        }
        this.contentQueryUtil = new ContentQueryUtil(context.getClientManager(), context.getExplainScope().getQueryableAssetId(), context.getExplainScope().getSourceType());
        InclusionExclusionFilter topQuartileFilter = this.getQuartileAsInclusionFilter(context, context.getExplainScope().getTargetColumnId(), focalFieldfilter, context.getExplainScope().getQualifier());
        this.analyzeKeyFactors(context, context.getKeyDrivers(), topQuartileFilter, focalFieldfilter);
    }

    private void analyzeKeyFactors(ExplainContext context, List<String> keyFactors, InclusionExclusionFilter topQuartileFilter, InclusionExclusionFilter memberOfInterest) {
        List<ColumnInfo> aggregatedMeasures = keyFactors.stream().map(k -> context.getIndexedSM().getColumnInfo((String)k)).collect(Collectors.toList());
        for (ColumnInfo ci : aggregatedMeasures) {
            ci.getSemanticInfo().setDefaultAggregation(AggregationType.AVERAGE);
        }
        Map<String, String> keyFactorValueMap = this.contentQueryUtil.getMeasuresByInclusion(aggregatedMeasures, topQuartileFilter);
        Map<String, String> memberValueMap = this.contentQueryUtil.getMeasuresByInclusion(aggregatedMeasures, memberOfInterest);
        for (Map.Entry<String, String> entry : keyFactorValueMap.entrySet()) {
            if (!memberValueMap.containsKey(entry.getKey())) continue;
            this.addResultingComparison(context, memberValueMap.get(entry.getKey()), entry.getValue(), entry.getKey(), (BaseFilter)memberOfInterest, (BaseFilter)topQuartileFilter);
        }
    }

    private void addResultingComparison(ExplainContext context, String memberValue, String comparisonValue, String columnId, BaseFilter memberFilter, BaseFilter quartileFilter) {
        ColumnInfo ci = context.getIndexedSM().getColumnInfo(columnId);
        ArrayList<BaseFilter> myFilterList = new ArrayList<BaseFilter>();
        myFilterList.add(memberFilter);
        ArrayList<BaseFilter> quartileFilterList = new ArrayList<BaseFilter>();
        quartileFilterList.add(quartileFilter);
        IRExplanationItem myValue = new IRExplanationItem(ci.getPrettyName(), myFilterList, AggregationType.AVERAGE, (Value)new DoubleValue(Double.parseDouble(memberValue)));
        IRExplanationItem quartileValue = new IRExplanationItem(ci.getPrettyName(), quartileFilterList, AggregationType.AVERAGE, (Value)new DoubleValue(Double.parseDouble(comparisonValue)));
        ArrayList<IRExplanationItem> items = new ArrayList<IRExplanationItem>();
        items.add(myValue);
        items.add(quartileValue);
        IRExplanation explanation = new IRExplanation(ci.getPrettyName(), ExplanationType.COMPARISON, items, 1.0);
        context.getComparisons().add(explanation);
    }

    private InclusionExclusionFilter getQuartileAsInclusionFilter(ExplainContext context, String targetMeasureColumnId, InclusionExclusionFilter focalFilter, QualifierType qualifier) {
        ArrayList<Pair<String, String>> topQuartile = new ArrayList<Pair<String, String>>();
        ArrayList<Pair<String, String>> bottomQuartile = new ArrayList<Pair<String, String>>();
        ArrayList<Pair<String, String>> middle = new ArrayList<Pair<String, String>>();
        ColumnInfo aggregatedMeasure = context.getIndexedSM().getColumnInfo(targetMeasureColumnId);
        this.contentQueryUtil.getTopAndBottomQuartile(aggregatedMeasure, focalFilter.getColumnId(), topQuartile, bottomQuartile, middle);
        if (topQuartile.isEmpty() || bottomQuartile.isEmpty()) {
            throw new ContentException(SmartsStatus.QUARTILE_ERROR);
        }
        ArrayList<InclusionExclusionFilter.DataValue> quartileDataValues = new ArrayList<InclusionExclusionFilter.DataValue>();
        boolean firstIteration = true;
        if (qualifier.equals((Object)QualifierType.LOW)) {
            for (Pair pair : topQuartile) {
                if (((String)pair.getLeft()).contains(this.itemOfInterest)) {
                    if (firstIteration) {
                        throw new ContentException(SmartsStatus.NO_COMPARISON_BASIS);
                    }
                    break;
                }
                firstIteration = false;
                InclusionExclusionFilter.DataValue dv = new InclusionExclusionFilter.DataValue((String)pair.getLeft(), (String)pair.getRight());
                quartileDataValues.add(dv);
            }
        } else if (qualifier.equals((Object)QualifierType.HIGH)) {
            for (int bottomIdx = bottomQuartile.size() - 1; bottomIdx >= 0; --bottomIdx) {
                Pair pair = (Pair)bottomQuartile.get(bottomIdx);
                if (((String)pair.getLeft()).contains(this.itemOfInterest)) {
                    if (firstIteration) {
                        throw new ContentException(SmartsStatus.NO_COMPARISON_BASIS);
                    }
                    break;
                }
                firstIteration = false;
                InclusionExclusionFilter.DataValue dv = new InclusionExclusionFilter.DataValue((String)pair.getLeft(), (String)pair.getRight());
                quartileDataValues.add(dv);
            }
        } else {
            throw new ContentException(SmartsStatus.UNSUPPORTED_QUALIFIER);
        }
        try {
            return new InclusionExclusionFilter(focalFilter.getColumnId(), quartileDataValues, null, null);
        }
        catch (MissingFilterParametersException e) {
            throw new ContentException(SmartsStatus.INAPPOPRIATE_FILTER_FOR_COMPARISON_ANALYSIS);
        }
    }

    private boolean isMeasure(ExplainContext context, String columnId) {
        ColumnInfo columnInfo = context.getIndexedSM().getColumnInfo(columnId);
        if (columnInfo != null && columnInfo.getSemanticInfo() != null) {
            return columnInfo.getSemanticInfo().getUsage().equals((Object)UsageType.FACT);
        }
        return false;
    }

    private boolean isCategorical(ExplainContext context, String columnId) {
        ColumnInfo columnInfo = context.getIndexedSM().getColumnInfo(columnId);
        if (columnInfo != null && columnInfo.getSemanticInfo() != null) {
            return !columnInfo.getSemanticInfo().getUsage().equals((Object)UsageType.FACT);
        }
        return false;
    }
}

