/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.content.recommender.internal.pipeline.prescribe;

import com.ibm.smarts.content.recommender.internal.ContentInfluencersUtil;
import com.ibm.smarts.content.recommender.internal.context.PrescribeContext;
import com.ibm.smarts.content.recommender.internal.pipeline.prescribe.IPrescribeStep;
import com.ibm.smarts.content.recommender.internal.util.QuickAccessSmartsModule;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.DatasetInfo;
import com.ibm.smarts.schema.FieldRecommendationRecord;
import java.util.ArrayList;
import java.util.List;

public class InfluencersSelection
implements IPrescribeStep {
    private static final int DEFAULT_MIN_INFLUENCERS = 5;

    @Override
    public void accept(PrescribeContext context) {
        ArrayList<String> prunedInfluencers = new ArrayList<String>();
        List<FieldRecommendationRecord> allInfluencers = this.calculateInfluencers(context, context.getPrescribeScope().getTargetColumnId());
        for (FieldRecommendationRecord influencer : allInfluencers) {
            if (!InfluencersSelection.isMeasure(context.getIndexedSM(), influencer.getFieldIDForExpression())) continue;
            prunedInfluencers.add(influencer.getFieldIDForExpression());
        }
        context.getKeyDrivers().addAll(prunedInfluencers.subList(0, Math.min(5, prunedInfluencers.size())));
    }

    private List<FieldRecommendationRecord> calculateInfluencers(PrescribeContext context, String focalFieldId) {
        return ContentInfluencersUtil.calculateRelatedFields(context.getInterestingFieldsRecommender(), context.getRequestContext(), context.getIndexedSM().getSmartsModule(), focalFieldId);
    }

    private static boolean isMeasure(QuickAccessSmartsModule indexedSM, String columnIdForExpr) {
        DatasetInfo ds = indexedSM.getDatasetInfo(columnIdForExpr);
        List<ColumnInfo> measures = indexedSM.getAllMeasures(ds.getId());
        return measures.stream().anyMatch(c -> c.getIdForExpression().equals(columnIdForExpr));
    }
}

