/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.content.recommender.internal.util;

import com.ibm.smarts.content.recommender.internal.util.StdChartConcepts;
import com.ibm.smarts.model.value.Value;
import com.ibm.smarts.ontology.registry.Concept;
import com.ibm.smarts.ontology.registry.ConceptsRegistry;
import com.ibm.smarts.schema.BaseItemObject;
import com.ibm.smarts.schema.BivariateStatistics;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.ConceptInfo;
import com.ibm.smarts.schema.DatasetInfo;
import com.ibm.smarts.schema.Hierarchy;
import com.ibm.smarts.schema.LogicalGroup;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.schema.StatisticType;
import com.ibm.smarts.schema.util.ColumnIdentifier;
import com.ibm.smarts.schema.util.SmartsModuleUtil;
import com.ibm.smarts.schema.util.StatisticsUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class QuickAccessSmartsModule {
    private Map<String, ColumnIdentifier> idForExpressionMap;
    private Map<String, Map<String, ColumnIdentifier>> datasetMap;
    private Map<String, DatasetInfo> columnIdToDatasetInfoMap = new HashMap<String, DatasetInfo>();
    private Map<String, List<ColumnInfo>> datasetTemporalColumns = new HashMap<String, List<ColumnInfo>>();
    private Map<String, List<ColumnInfo>> datasetLocationColumns = new HashMap<String, List<ColumnInfo>>();
    private Map<String, List<ColumnInfo>> datasetMonetaryColumns = new HashMap<String, List<ColumnInfo>>();
    private Map<String, List<ColumnInfo>> datasetPlainCategoricals = new HashMap<String, List<ColumnInfo>>();
    private Map<String, List<ColumnInfo>> datasetNonSpecializedMeasures = new HashMap<String, List<ColumnInfo>>();
    private Map<String, List<ColumnInfo>> datasetPureMeasures = new HashMap<String, List<ColumnInfo>>();
    private Map<String, List<ColumnInfo>> datasetRowIdentifiers = new HashMap<String, List<ColumnInfo>>();
    private Map<String, List<ColumnInfo>> datasetCoordinates = new HashMap<String, List<ColumnInfo>>();
    private Map<String, ColumnInfo> allColumnInfos = new HashMap<String, ColumnInfo>();
    private Map<String, List<ColumnInfo>> datasetAllCategoricals = new HashMap<String, List<ColumnInfo>>();
    private Map<String, List<ColumnInfo>> datasetAllMeasures = new HashMap<String, List<ColumnInfo>>();
    private Map<String, Map<String, LogicalGroup>> datasetLogicalGroups = new HashMap<String, Map<String, LogicalGroup>>();
    private Map<String, Map<String, String>> datasetPlannedToActual = new HashMap<String, Map<String, String>>();
    private Map<String, Map<String, String>> datasetActualToPlanned = new HashMap<String, Map<String, String>>();
    private Map<String, Map<String, Set<Integer>>> datasetColumnHierarchies = new HashMap<String, Map<String, Set<Integer>>>();
    final String DATE = "http://www.ibm.com/ontologies/waca/domain/common#Temporal";
    final String LOCATION = "http://www.ibm.com/ontologies/waca/domain/common#Geography";
    final String MONETARY = "http://www.ibm.com/ontologies/waca/domain/common#Monetary";
    final String ENTITY = "http://www.ibm.com/ontologies/waca/domain/common#Entity";
    final String CATEGORY = "http://www.ibm.com/ontologies/waca/application#Categorical";
    final String MEASURE = "http://www.ibm.com/ontologies/waca/domain/common#Measure";
    final String ROW_ID = "http://www.ibm.com/ontologies/waca/domain/common#RowIdentifier";
    final String LATITUDE = "http://www.ibm.com/ontologies/waca/domain/common#Latitude";
    final String LONGITUDE = "http://www.ibm.com/ontologies/waca/domain/common#Longitude";
    private Map<String, Map<ColumnIdentifier, Map<ColumnIdentifier, BivariateStatistics>>> bivariates = new HashMap<String, Map<ColumnIdentifier, Map<ColumnIdentifier, BivariateStatistics>>>();
    private final SmartsModule smartsModule;
    private boolean indexed;

    public QuickAccessSmartsModule(SmartsModule smartsModule) {
        this.smartsModule = smartsModule;
        this.maybeCreateIndices();
    }

    public void maybeCreateIndices() {
        if (!this.indexed) {
            this.createIndices();
        }
    }

    private void createIndices() {
        this.idForExpressionMap = new HashMap<String, ColumnIdentifier>();
        this.datasetMap = new HashMap<String, Map<String, ColumnIdentifier>>();
        try {
            this.smartsModule.getDatasets().forEach(d -> {
                this.datasetTemporalColumns.put(d.getId(), new ArrayList());
                this.datasetLocationColumns.put(d.getId(), new ArrayList());
                this.datasetMonetaryColumns.put(d.getId(), new ArrayList());
                this.datasetPlainCategoricals.put(d.getId(), new ArrayList());
                this.datasetNonSpecializedMeasures.put(d.getId(), new ArrayList());
                this.datasetPureMeasures.put(d.getId(), new ArrayList());
                this.datasetAllCategoricals.put(d.getId(), new ArrayList());
                this.datasetAllMeasures.put(d.getId(), new ArrayList());
                this.datasetRowIdentifiers.put(d.getId(), new ArrayList());
                this.datasetCoordinates.put(d.getId(), new ArrayList());
                SmartsModuleUtil.getFlattenedColumns((BaseItemObject)d).forEach(c -> {
                    ColumnIdentifier columnIdentifier = new ColumnIdentifier(d, c);
                    this.allColumnInfos.put(c.getIdForExpression(), (ColumnInfo)c);
                    this.columnIdToDatasetInfoMap.put(columnIdentifier.columnIdForExpression, (DatasetInfo)d);
                    if (c.getIdForExpression() != null && !c.getIdForExpression().isEmpty()) {
                        this.idForExpressionMap.put(c.getIdForExpression(), columnIdentifier);
                    }
                    this.addToSpecialized((DatasetInfo)d, (ColumnInfo)c);
                    this.datasetMap.putIfAbsent(d.getId(), new HashMap());
                    this.datasetMap.get(d.getId()).put(c.getId(), columnIdentifier);
                });
                d.getBivariateStatistics().forEach(bi -> this.storeBivariate((BivariateStatistics)bi, (DatasetInfo)d));
                this.recordLogicalGroupsHierarchies(d.getId(), d.getLogicalGroups(), d.getHierarchies());
            });
        }
        finally {
            this.indexed = true;
        }
    }

    public void resetIndices() {
        this.indexed = false;
        this.createIndices();
    }

    private void addToSpecialized(DatasetInfo d, ColumnInfo c) {
        if (c.getSemanticInfo() != null && !this.isMonotone(c)) {
            List concepts = ConceptsRegistry.instance().getConcepts(c.getSemanticInfo().getConcepts().stream().map(ConceptInfo::getConceptID).collect(Collectors.toList()));
            HashSet<String> taggedConcepts = new HashSet<String>();
            this.collectConcepts(d, c, concepts, taggedConcepts);
            this.addToQuickList(d, c, taggedConcepts);
        }
    }

    private boolean isMonotone(ColumnInfo c) {
        Value distinctCount = StatisticsUtil.getStatisticValue((ColumnInfo)c, (StatisticType)StatisticType.DISTINCT_COUNT);
        return distinctCount != null && distinctCount.intValue() == 1;
    }

    public ColumnInfo getColumnInfo(String idForExpression) {
        return this.allColumnInfos.get(idForExpression);
    }

    private boolean isAllUnique(ColumnInfo c) {
        Value distinctCount = StatisticsUtil.getStatisticValue((ColumnInfo)c, (StatisticType)StatisticType.DISTINCT_COUNT);
        Value count = StatisticsUtil.getStatisticValue((ColumnInfo)c, (StatisticType)StatisticType.COUNT);
        return distinctCount != null && count != null && distinctCount.intValue() == count.intValue();
    }

    private void addToQuickList(DatasetInfo d, ColumnInfo c, Set<String> taggedConcepts) {
        boolean addedToSpecialized = false;
        if (taggedConcepts.contains("http://www.ibm.com/ontologies/waca/domain/common#Monetary")) {
            this.datasetMonetaryColumns.get(d.getId()).add(c);
            addedToSpecialized = true;
        } else if (taggedConcepts.contains("http://www.ibm.com/ontologies/waca/domain/common#Temporal")) {
            this.datasetTemporalColumns.get(d.getId()).add(c);
            addedToSpecialized = true;
        } else if (taggedConcepts.contains("http://www.ibm.com/ontologies/waca/domain/common#Latitude") || taggedConcepts.contains("http://www.ibm.com/ontologies/waca/domain/common#Longitude")) {
            this.datasetCoordinates.get(d.getId()).add(c);
            addedToSpecialized = true;
        } else if (taggedConcepts.contains("http://www.ibm.com/ontologies/waca/domain/common#Geography")) {
            this.datasetLocationColumns.get(d.getId()).add(c);
            addedToSpecialized = true;
        }
        if (taggedConcepts.contains("http://www.ibm.com/ontologies/waca/domain/common#RowIdentifier")) {
            if (!addedToSpecialized) {
                this.datasetRowIdentifiers.get(d.getId()).add(c);
            }
        } else if (taggedConcepts.contains("http://www.ibm.com/ontologies/waca/domain/common#Entity")) {
            if (!addedToSpecialized) {
                this.datasetPlainCategoricals.get(d.getId()).add(c);
            }
            if (!taggedConcepts.contains("http://www.ibm.com/ontologies/waca/domain/common#Measure")) {
                this.datasetAllCategoricals.get(d.getId()).add(c);
            } else {
                this.datasetAllMeasures.get(d.getId()).add(c);
            }
        } else if (taggedConcepts.contains("http://www.ibm.com/ontologies/waca/domain/common#Measure")) {
            if (!addedToSpecialized) {
                this.datasetNonSpecializedMeasures.get(d.getId()).add(c);
            }
            this.datasetAllMeasures.get(d.getId()).add(c);
        }
        if (taggedConcepts.contains("http://www.ibm.com/ontologies/waca/domain/common#Measure") && !taggedConcepts.contains("http://www.ibm.com/ontologies/waca/domain/common#Entity")) {
            this.datasetPureMeasures.get(d.getId()).add(c);
        }
    }

    private void collectConcepts(DatasetInfo d, ColumnInfo c, List<Concept> concepts, Set<String> taggedConcepts) {
        for (Concept conceptInfo : concepts) {
            if (conceptInfo.getIRI().contains("http://www.ibm.com/ontologies/waca/domain/common#Temporal")) {
                taggedConcepts.add("http://www.ibm.com/ontologies/waca/domain/common#Temporal");
            } else if (conceptInfo.getIRI().contains("http://www.ibm.com/ontologies/waca/domain/common#Latitude")) {
                taggedConcepts.add("http://www.ibm.com/ontologies/waca/domain/common#Latitude");
            } else if (conceptInfo.getIRI().contains("http://www.ibm.com/ontologies/waca/domain/common#Longitude")) {
                taggedConcepts.add("http://www.ibm.com/ontologies/waca/domain/common#Longitude");
            } else if (conceptInfo.getIRI().contains("http://www.ibm.com/ontologies/waca/domain/common#Geography")) {
                taggedConcepts.add("http://www.ibm.com/ontologies/waca/domain/common#Geography");
            } else if (conceptInfo.getIRI().contains("http://www.ibm.com/ontologies/waca/domain/common#Monetary")) {
                taggedConcepts.add("http://www.ibm.com/ontologies/waca/domain/common#Monetary");
            } else if (conceptInfo.getIRI().contains("http://www.ibm.com/ontologies/waca/domain/common#RowIdentifier")) {
                taggedConcepts.add("http://www.ibm.com/ontologies/waca/domain/common#RowIdentifier");
            } else if (conceptInfo.getIRI().contains("http://www.ibm.com/ontologies/waca/domain/common#Entity") || conceptInfo.getIRI().contains("http://www.ibm.com/ontologies/waca/application#Categorical")) {
                taggedConcepts.add("http://www.ibm.com/ontologies/waca/domain/common#Entity");
            } else if (conceptInfo.getIRI().contains("http://www.ibm.com/ontologies/waca/domain/common#Measure")) {
                taggedConcepts.add("http://www.ibm.com/ontologies/waca/domain/common#Measure");
            }
            if (conceptInfo.getParents() == null || conceptInfo.getParents().isEmpty()) continue;
            this.collectConcepts(d, c, conceptInfo.getParents(), taggedConcepts);
        }
    }

    public ColumnIdentifier getColumnIdentifier(String idForExpression) {
        this.maybeCreateIndices();
        return this.idForExpressionMap.get(idForExpression);
    }

    public ColumnIdentifier getColumnIdentifier(String datasetId, String columnId) {
        Map<String, ColumnIdentifier> columns = this.datasetMap.get(datasetId);
        return columns != null ? columns.get(columnId) : null;
    }

    public Map<String, Map<ColumnIdentifier, Map<ColumnIdentifier, BivariateStatistics>>> getAllBivariates() {
        return this.bivariates;
    }

    public Map<ColumnIdentifier, Map<ColumnIdentifier, BivariateStatistics>> getAllBivariatesByDatasetId(String datasetId) {
        if (this.bivariates.containsKey(datasetId)) {
            return this.bivariates.get(datasetId);
        }
        this.bivariates.put(datasetId, new HashMap());
        return this.bivariates.get(datasetId);
    }

    public Map<ColumnIdentifier, BivariateStatistics> getBivariates(ColumnIdentifier columnIdentifier) {
        return this.getAllBivariatesByDatasetId(columnIdentifier.datasetId).get(columnIdentifier);
    }

    public boolean hasBivariates(ColumnIdentifier columnIdentifier) {
        return this.getAllBivariatesByDatasetId(columnIdentifier.datasetId).containsKey(columnIdentifier);
    }

    private void storeBivariate(BivariateStatistics bi, DatasetInfo ds) {
        ColumnIdentifier columnIdentifier1;
        Map<ColumnIdentifier, Map<ColumnIdentifier, BivariateStatistics>> bivariatesByDataset = this.getAllBivariatesByDatasetId(ds.getId());
        if (!bivariatesByDataset.containsKey(columnIdentifier1 = this.getColumnIdentifier(ds.getId(), bi.getColumn1()))) {
            bivariatesByDataset.put(columnIdentifier1, new HashMap());
        }
        ColumnIdentifier columnIdentifier2 = this.getColumnIdentifier(ds.getId(), bi.getColumn2());
        Map<ColumnIdentifier, BivariateStatistics> storedMap = bivariatesByDataset.get(columnIdentifier1);
        storedMap.put(columnIdentifier2, bi);
        if (!bivariatesByDataset.containsKey(columnIdentifier2)) {
            bivariatesByDataset.put(columnIdentifier2, new HashMap());
        }
        Map<ColumnIdentifier, BivariateStatistics> storedMap2 = bivariatesByDataset.get(columnIdentifier2);
        storedMap2.put(columnIdentifier1, bi);
    }

    private void recordLogicalGroupsHierarchies(String dsId, List<LogicalGroup> logicalGroups, List<Hierarchy> hierarchies) {
        this.datasetLogicalGroups.put(dsId, new HashMap());
        this.datasetColumnHierarchies.put(dsId, new HashMap());
        this.datasetPlannedToActual.put(dsId, new HashMap());
        this.datasetActualToPlanned.put(dsId, new HashMap());
        for (LogicalGroup logicalGroup : logicalGroups) {
            this.storeLogicalGroup(dsId, logicalGroup);
        }
        for (int ii = 0; ii < hierarchies.size(); ++ii) {
            Hierarchy hierarchy = hierarchies.get(ii);
            for (Hierarchy.Level level : hierarchy.getLevel()) {
                LogicalGroup logicalGroup = this.getLogicalGroup(dsId, level.getGroupId());
                for (LogicalGroup.Member member : logicalGroup.getMember()) {
                    this.storeColumnToHierarchy(dsId, member.getIdForExpression(), ii);
                }
            }
        }
    }

    private void storeColumnToHierarchy(String dsId, String columnIdForExpr, int hierarchyNum) {
        Set<Integer> hierarchyForColumn = this.datasetColumnHierarchies.get(dsId).get(columnIdForExpr);
        if (hierarchyForColumn == null) {
            hierarchyForColumn = new HashSet<Integer>();
            this.datasetColumnHierarchies.get(dsId).put(columnIdForExpr, hierarchyForColumn);
        }
        hierarchyForColumn.add(hierarchyNum);
    }

    private void storeLogicalGroup(String dsId, LogicalGroup logicalGroup) {
        this.datasetLogicalGroups.get(dsId).put(logicalGroup.getId(), logicalGroup);
        String planned = "";
        String actual = "";
        for (LogicalGroup.Member m : logicalGroup.getMember()) {
            String memberConcept = m.getAttribute().getConceptID();
            if (memberConcept.equals(StdChartConcepts.PLANNED.getId()) && m.getIdForExpression() != null) {
                planned = m.getIdForExpression();
                continue;
            }
            if (!memberConcept.equals(StdChartConcepts.ACTUAL.getId()) || m.getIdForExpression() == null) continue;
            actual = m.getIdForExpression();
        }
        if (!planned.isEmpty() && !actual.isEmpty()) {
            this.datasetPlannedToActual.get(dsId).put(planned, actual);
            this.datasetActualToPlanned.get(dsId).put(actual, planned);
        }
    }

    private LogicalGroup getLogicalGroup(String dsId, String logicalGroupId) {
        return this.datasetLogicalGroups.get(dsId).get(logicalGroupId);
    }

    public Map<String, LogicalGroup> getLogicalGroups(String dsId) {
        return this.datasetLogicalGroups.get(dsId);
    }

    public Map<String, String> getPlannedToActual(String dsId) {
        return this.datasetPlannedToActual.get(dsId);
    }

    public Map<String, String> getActualToPlanned(String dsId) {
        return this.datasetActualToPlanned.get(dsId);
    }

    public Set<Integer> getHierarchy(String datasetId, String columnIdForExpr) {
        return this.datasetColumnHierarchies.get(datasetId).getOrDefault(columnIdForExpr, Collections.emptySet());
    }

    public DatasetInfo getDatasetInfo(String columnIdForExpr) {
        return this.columnIdToDatasetInfoMap.get(columnIdForExpr);
    }

    public List<ColumnInfo> getTemporalColumns(String datasetId) {
        return this.datasetTemporalColumns.get(datasetId);
    }

    public List<ColumnInfo> getLocationColumns(String datasetId) {
        return this.datasetLocationColumns.get(datasetId);
    }

    public List<ColumnInfo> getMonetaryColumns(String datasetId) {
        return this.datasetMonetaryColumns.get(datasetId);
    }

    public List<ColumnInfo> getCategoricals(String datasetId) {
        return this.datasetPlainCategoricals.get(datasetId);
    }

    public List<ColumnInfo> getMeasures(String datasetId) {
        return this.datasetNonSpecializedMeasures.getOrDefault(datasetId, Collections.emptyList());
    }

    public List<ColumnInfo> getPureMeasures(String datasetId) {
        return this.datasetPureMeasures.getOrDefault(datasetId, Collections.emptyList());
    }

    public List<ColumnInfo> getRowIdentifiers(String datasetId) {
        return this.datasetRowIdentifiers.getOrDefault(datasetId, Collections.emptyList());
    }

    public List<ColumnInfo> getAllCategoricals(String datasetId) {
        return this.datasetAllCategoricals.get(datasetId);
    }

    public List<ColumnInfo> getAllMeasures(String datasetId) {
        return this.datasetAllMeasures.get(datasetId);
    }

    public SmartsModule getSmartsModule() {
        return this.smartsModule;
    }
}

