/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.conversation.training;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.smarts.conversation.training.SystemSamplesGenerator;
import java.io.IOException;
import java.util.Collection;
import java.util.InvalidPropertiesFormatException;
import java.util.Set;

public class SkillSamplesGenerator {
    public static void createTrainingData(JSONObject systemDataDictionary, JSONObject skillTrainingData, String entitiesFilePath, String intentsFilePath) throws IOException {
        JSONObject dictionary = new JSONObject();
        if (skillTrainingData != null && !skillTrainingData.isEmpty()) {
            dictionary = (JSONObject)skillTrainingData.get((Object)"dictionary");
        }
        JSONObject finalDataDictionary = new JSONObject();
        if (dictionary != null) {
            finalDataDictionary = SkillSamplesGenerator.generateDataDictionary(systemDataDictionary, dictionary);
        }
        JSONObject templates = SkillSamplesGenerator.generateTemplates(skillTrainingData);
        SystemSamplesGenerator.createTrainingData(finalDataDictionary, templates, entitiesFilePath, intentsFilePath);
    }

    private static JSONObject generateTemplates(JSONObject skillTrainingData) {
        JSONArray sentences = new JSONArray();
        JSONArray ignoreTokens = new JSONArray();
        JSONObject tokenMap = new JSONObject();
        if (skillTrainingData != null && !skillTrainingData.isEmpty()) {
            sentences = (JSONArray)skillTrainingData.get((Object)"samples");
            JSONObject dictionary = (JSONObject)skillTrainingData.get((Object)"dictionary");
            if (dictionary != null) {
                ignoreTokens = SkillSamplesGenerator.generateIgnoreTokens(dictionary);
                tokenMap = SkillSamplesGenerator.generateTokenMap(dictionary);
            }
        }
        JSONObject templates = new JSONObject();
        templates.put((Object)"ignore_tokens", (Object)ignoreTokens);
        templates.put((Object)"token_map", (Object)tokenMap);
        templates.put((Object)"templates", (Object)sentences);
        return templates;
    }

    protected static JSONObject generateDataDictionary(JSONObject dataDictionary, JSONObject dictionary) throws InvalidPropertiesFormatException {
        JSONObject jsonObject;
        JSONObject finalDataDictionary = new JSONObject();
        Set entityKeys = dictionary.keySet();
        for (Object key : entityKeys) {
            jsonObject = (JSONObject)dictionary.get(key);
            JSONArray values = (JSONArray)jsonObject.getOrDefault((Object)"values", (Object)new JSONArray());
            boolean addSystemValues = (Boolean)jsonObject.getOrDefault((Object)"addSystemValues", (Object)false);
            if (addSystemValues) {
                JSONArray dataDictionaryValue = (JSONArray)dataDictionary.get(key);
                if (dataDictionaryValue != null && !dataDictionaryValue.isEmpty()) {
                    values.addAll((Collection)dataDictionaryValue);
                } else {
                    throw new InvalidPropertiesFormatException(String.format("Add system values was specified for %s but none were found.", key));
                }
            }
            finalDataDictionary.put(key, (Object)values);
        }
        for (Object key : entityKeys) {
            jsonObject = (JSONObject)dictionary.get(key);
            JSONArray addValuesFrom = (JSONArray)jsonObject.getOrDefault((Object)"addValuesFrom", (Object)new JSONArray());
            if (addValuesFrom.isEmpty()) continue;
            JSONArray currentList = (JSONArray)finalDataDictionary.get(key);
            for (Object from : addValuesFrom) {
                JSONArray finalJsonArray = (JSONArray)finalDataDictionary.get(from);
                JSONArray dataJsonArray = (JSONArray)dataDictionary.get(from);
                if (!finalJsonArray.isEmpty()) {
                    currentList.addAll((Collection)finalJsonArray);
                    continue;
                }
                if (!dataDictionary.isEmpty()) {
                    currentList.addAll((Collection)dataJsonArray);
                    continue;
                }
                throw new InvalidPropertiesFormatException(String.format("Add system values was specified for %s but none were found.", from));
            }
            finalDataDictionary.put(key, (Object)currentList);
        }
        return finalDataDictionary;
    }

    protected static JSONArray generateIgnoreTokens(JSONObject dictionary) {
        Set entities = dictionary.keySet();
        JSONArray ignoreTokens = new JSONArray();
        entities.stream().forEach(entity -> {
            JSONObject token = (JSONObject)dictionary.get(entity);
            boolean trainValue = (Boolean)token.getOrDefault((Object)"train", (Object)true);
            if (!trainValue) {
                ignoreTokens.add(entity);
            }
        });
        return ignoreTokens;
    }

    protected static JSONObject generateTokenMap(JSONObject dictionary) {
        Set entities = dictionary.keySet();
        JSONObject tokenMap = new JSONObject();
        entities.stream().forEach(entity -> {
            JSONObject token = (JSONObject)dictionary.get(entity);
            String tagAs = (String)token.get((Object)"tagAs");
            if (tagAs != null) {
                tokenMap.put(entity, (Object)tagAs);
            }
        });
        return tokenMap;
    }
}

