/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.conversation.training;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.InvalidPropertiesFormatException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemSamplesGenerator {
    private static final Pattern SPECIAL_CHARS_PATTERN = Pattern.compile("[\\(\\)%\\{\\}\\$\\?]|[^\\(\\)%\\{\\}\\$\\?]+");
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemSamplesGenerator.class);

    public static void createTrainingData(JSONObject dataDictionary, JSONObject templates, String entitiesFilePath, String intentsFilePath) {
        try {
            ArrayList<String> entitiesTrainList = new ArrayList<String>();
            ArrayList<String> intentsTrainList = new ArrayList<String>();
            JSONArray sentences = new JSONArray();
            JSONArray ignoreTokens = new JSONArray();
            JSONObject tokenMap = new JSONObject();
            if (templates != null && !templates.isEmpty()) {
                sentences = (JSONArray)templates.get((Object)"templates");
                ignoreTokens = (JSONArray)templates.get((Object)"ignore_tokens");
                tokenMap = (JSONObject)templates.get((Object)"token_map");
            }
            File entitiesTrainFile = new File(entitiesFilePath);
            File intentsTrainFile = new File(intentsFilePath);
            SystemSamplesGenerator.generateAllSamples(dataDictionary, sentences, ignoreTokens, tokenMap, entitiesTrainList, intentsTrainList);
            SystemSamplesGenerator.shuffleSamples(entitiesTrainList, intentsTrainList);
            SystemSamplesGenerator.writeListToFile(entitiesTrainFile, intentsTrainFile, entitiesTrainList, intentsTrainList);
            LOGGER.info("Complete!");
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage());
        }
    }

    protected static String processEntityText(String entityText, String entityType) {
        StringBuilder output = new StringBuilder();
        for (String token : entityText.split(" ")) {
            if (token.isEmpty()) continue;
            Matcher m = SPECIAL_CHARS_PATTERN.matcher(token);
            while (m.find()) {
                output.append(token, m.start(), m.end());
                output.append('\t');
                output.append(entityType);
                output.append('\n');
            }
        }
        return output.toString();
    }

    private static void generateEntities(JSONObject dataDictionary, List<String> entitiesList, JSONArray sentences, String consume, JSONArray ignoreTokens, JSONObject tokenMap) throws InvalidPropertiesFormatException {
        Set placeHolders = dataDictionary.keySet();
        HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
        placeHolders.stream().forEach(placeHolder -> indexMap.put(placeHolder.toString(), 0));
        block0: while (true) {
            Iterator iterator = sentences.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block0;
                Object sentence = iterator.next();
                Pattern tokensPattern = Pattern.compile("[^,.:;?' ]+|[,.:;?']");
                StringBuilder sample = new StringBuilder();
                Matcher m = tokensPattern.matcher((String)sentence);
                while (m.find()) {
                    int start = m.start();
                    int end = m.end();
                    String token = sentence.toString().substring(start, end);
                    if (token.startsWith("{") && token.endsWith("}")) {
                        String tokenType = token.substring(1, token.length() - 1);
                        if (placeHolders.contains(tokenType)) {
                            int paramListIndex = (Integer)indexMap.get(tokenType);
                            JSONArray paramValueArray = (JSONArray)dataDictionary.get((Object)tokenType);
                            String paramValue = (String)paramValueArray.get(paramListIndex);
                            if (paramValue != null && !paramValue.isEmpty()) {
                                if (ignoreTokens.contains((Object)tokenType)) {
                                    sample.append(SystemSamplesGenerator.processEntityText(paramValue, "O"));
                                } else {
                                    sample.append(SystemSamplesGenerator.processEntityText(paramValue, tokenMap.getOrDefault((Object)tokenType, (Object)tokenType).toString()));
                                }
                            }
                            if (++paramListIndex == paramValueArray.size()) {
                                if (tokenType.equals(consume)) {
                                    return;
                                }
                                paramListIndex = 0;
                            }
                            indexMap.put(tokenType, paramListIndex);
                            continue;
                        }
                        throw new InvalidPropertiesFormatException(String.format("Invalid template %s is missing %s.", sentence, tokenType));
                    }
                    sample.append(SystemSamplesGenerator.processEntityText(token, "O"));
                }
                sample.append("\n");
                entitiesList.add(sample.toString());
            }
            break;
        }
    }

    private static void generateIntents(JSONObject dataDictionary, List<String> intentsList, JSONArray sentences, String intent, String consume) throws InvalidPropertiesFormatException {
        Set placeHolders = dataDictionary.keySet();
        HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
        placeHolders.stream().forEach(placeHolder -> indexMap.put(placeHolder.toString(), 0));
        block0: while (true) {
            Iterator iterator = sentences.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block0;
                Object sentence = iterator.next();
                Pattern tokensPattern = Pattern.compile("[^,.:;?' ]+|[,.:;?']");
                String sample = "";
                Matcher m = tokensPattern.matcher((String)sentence);
                while (m.find()) {
                    int start = m.start();
                    int end = m.end();
                    String token = sentence.toString().substring(start, end);
                    if (token.startsWith("{") && token.endsWith("}")) {
                        String tokenType = token.substring(1, token.length() - 1);
                        if (placeHolders.contains(tokenType)) {
                            int paramListIndex = (Integer)indexMap.get(tokenType);
                            JSONArray paramValueArray = (JSONArray)dataDictionary.get((Object)tokenType);
                            String paramValue = (String)paramValueArray.get(paramListIndex);
                            sample = sample + paramValue + " ";
                            if (++paramListIndex == paramValueArray.size()) {
                                if (tokenType.equals(consume)) {
                                    return;
                                }
                                paramListIndex = 0;
                            }
                            indexMap.put(tokenType, paramListIndex);
                            continue;
                        }
                        throw new InvalidPropertiesFormatException(String.format("Invalid template %s is missing %s.", sentence, tokenType));
                    }
                    sample = sample + token + " ";
                }
                sample = sample.trim();
                intentsList.add(intent + "\t" + sample + "\n");
            }
            break;
        }
    }

    protected static void processStaticSamples(String intent, JSONArray sentences, List<String> entitiesTrainList, List<String> intentsTrainList) {
        for (Object sentence : sentences) {
            Pattern tokensPattern = Pattern.compile("[^,.;?' ]+|[,.;?']");
            String intentSample = "";
            String entitySample = "";
            Matcher m = tokensPattern.matcher((String)sentence);
            while (m.find()) {
                int start = m.start();
                int end = m.end();
                String token = sentence.toString().substring(start, end);
                if (token.startsWith("{") && token.endsWith("}")) {
                    token = token.substring(1, token.length() - 1);
                    int index = token.indexOf(":");
                    String entity = token.substring(index + 1);
                    String value = token.substring(0, index);
                    intentSample = intentSample + value + " ";
                    entitySample = entitySample + value + "\t" + entity + "\n";
                    continue;
                }
                intentSample = intentSample + token + " ";
                entitySample = entitySample + token + "\tO\n";
            }
            intentSample = intentSample.trim();
            intentsTrainList.add(intent + "\t" + intentSample + "\n");
            entitySample = entitySample + "\n";
            entitiesTrainList.add(entitySample);
        }
    }

    private static void processRegularSamples(JSONObject dataDictionary, JSONArray sentences, String intent, String consume, JSONArray ignoreTokens, JSONObject tokenMap, List<String> entitiesTrainList, List<String> intentsTrainList) throws InvalidPropertiesFormatException {
        for (int i = 0; i < 3; ++i) {
            SystemSamplesGenerator.shuffleDictionary(dataDictionary);
            SystemSamplesGenerator.generateEntities(dataDictionary, entitiesTrainList, sentences, consume, ignoreTokens, tokenMap);
            SystemSamplesGenerator.generateIntents(dataDictionary, intentsTrainList, sentences, intent, consume);
        }
    }

    private static void shuffleDictionary(JSONObject dataDictionary) {
        Set entries = dataDictionary.entrySet();
        for (Map.Entry entry : entries) {
            JSONArray values = (JSONArray)entry.getValue();
            Collections.shuffle(values);
        }
    }

    protected static JSONArray getStaticSentences(JSONArray sentences) {
        JSONArray staticSentences = new JSONArray();
        for (Object obj : sentences) {
            String sentence = (String)obj;
            if ((sentence.contains("{") || sentence.contains("}")) && !sentence.contains(":")) continue;
            staticSentences.add((Object)sentence);
        }
        return staticSentences;
    }

    protected static JSONArray getRegularSentences(JSONArray sentences) {
        JSONArray regularSentences = new JSONArray();
        for (Object obj : sentences) {
            String sentence = (String)obj;
            if (!sentence.contains("{") || !sentence.contains("}") || sentence.contains(":")) continue;
            regularSentences.add((Object)sentence);
        }
        return regularSentences;
    }

    protected static void generateAllSamples(JSONObject dataDictionary, JSONArray templates, JSONArray ignoreTokens, JSONObject tokenMap, List<String> entitiesTrainList, List<String> intentsTrainList) throws InvalidPropertiesFormatException {
        for (Object templateObject : templates) {
            JSONArray regularSentences;
            JSONArray staticSentences;
            JSONObject template = (JSONObject)templateObject;
            String intent = (String)template.get((Object)"intent");
            JSONArray sentences = (JSONArray)template.get((Object)"sentences");
            String consume = (String)template.get((Object)"consume");
            String name = (String)template.get((Object)"name");
            LOGGER.debug("Processing templates: {}", (Object)name);
            if (consume == null || consume.isEmpty()) {
                consume = (String)template.get((Object)"useAllValues");
            }
            if (!(staticSentences = SystemSamplesGenerator.getStaticSentences(sentences)).isEmpty()) {
                SystemSamplesGenerator.processStaticSamples(intent, staticSentences, entitiesTrainList, intentsTrainList);
            }
            if ((regularSentences = SystemSamplesGenerator.getRegularSentences(sentences)).isEmpty()) continue;
            SystemSamplesGenerator.processRegularSamples(dataDictionary, regularSentences, intent, consume, ignoreTokens, tokenMap, entitiesTrainList, intentsTrainList);
        }
    }

    private static void shuffleSamples(List<String> entitiesTrainList, List<String> intentsTrainList) {
        SystemSamplesGenerator.removeDuplicates(entitiesTrainList);
        SystemSamplesGenerator.removeDuplicates(intentsTrainList);
        Collections.shuffle(entitiesTrainList);
        Collections.shuffle(intentsTrainList);
    }

    protected static void writeListToFile(File entitiesTrainFile, File intentsTrainFile, List<String> entitiesTrainList, List<String> intentsTrainList) throws IOException {
        try (FileWriter trainEntitiesWriter = new FileWriter(entitiesTrainFile, true);
             FileWriter trainIntentsWriter = new FileWriter(intentsTrainFile, true);){
            for (String line : entitiesTrainList) {
                trainEntitiesWriter.write(line);
            }
            for (String line : intentsTrainList) {
                trainIntentsWriter.write(line);
            }
        }
    }

    private static void removeDuplicates(List<String> trainingList) {
        int originalSize = trainingList.size();
        HashSet<String> trainingSet = new HashSet<String>(trainingList);
        trainingList.clear();
        trainingList.addAll(trainingSet);
        int duplicates = originalSize - trainingList.size();
        LOGGER.debug("Removed {} duplicates samples, final size: {}", (Object)duplicates, (Object)trainingList.size());
    }
}

