/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ca.core.impl.content;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.smarts.ca.core.impl.content.SmartsModuleCMFields;
import com.ibm.smarts.ca.core.rest.client.CaRestClient;
import com.ibm.smarts.common.mq.function.SmartsModulePublishUtil;
import com.ibm.smarts.common.util.CommonJAXBHelper;
import com.ibm.smarts.core.exceptions.InternalException;
import com.ibm.smarts.core.rest.client.RestClient;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.model.builder.ColumnEmbedding;
import com.ibm.smarts.model.builder.SmartsModuleOptions;
import com.ibm.smarts.model.common.content.ContentObject;
import com.ibm.smarts.schema.AnalysisPhase;
import com.ibm.smarts.schema.AnalysisScope;
import com.ibm.smarts.schema.AnalysisStateType;
import com.ibm.smarts.schema.BaseObject;
import com.ibm.smarts.schema.BivariateStatistics;
import com.ibm.smarts.schema.DatasetInfo;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.schema.util.AnalysisScopes;
import com.ibm.smarts.schema.util.SmartsModuleFactory;
import com.ibm.smarts.schema.util.SmartsModuleUtil;
import com.ibm.smarts.schema.util.SmartsUtil;
import com.ibm.smarts.store.api.query.IRecord;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import javax.ws.rs.core.Response;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaContentRestClient
extends CaRestClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(CaContentRestClient.class);

    public CaContentRestClient(RestClient.RestCallContextFactory rccf, RequestContext requestContext, String uri) {
        super(rccf, requestContext, uri);
    }

    public CompletableFuture<ContentObject> getObjectAsync(String objectId, String ... fields) {
        return this.getObjectAsync(objectId, 0L, 0L, fields);
    }

    public CompletableFuture<ContentObject> getObjectAsync(String objectId, long minimumVersion, long timeoutMillis, String ... fields) {
        long expiry = System.currentTimeMillis() + timeoutMillis;
        String path = String.format("/bi/v1/objects/%s", objectId);
        RestClient.QueryParams queryParams = this.buildFieldsQueryParam(fields);
        return this.getObjectAsync(path, queryParams, minimumVersion, expiry, fields);
    }

    private CompletableFuture<ContentObject> getObjectAsync(String path, RestClient.QueryParams queryParams, long minimumVersion, long expiry, String ... fields) {
        return this.getAsync(path, queryParams).thenCompose(json -> {
            ContentObject content;
            List<ContentObject> objects = CaContentRestClient.parseObjects(json, fields);
            ContentObject contentObject = content = objects.isEmpty() ? null : objects.get(0);
            while (content == null || content.version < minimumVersion) {
                if (System.currentTimeMillis() < expiry) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    String contentJson = this.get(path, queryParams);
                    objects = CaContentRestClient.parseObjects(contentJson, fields);
                    content = objects.isEmpty() ? null : objects.get(0);
                    continue;
                }
                return CompletableFuture.completedFuture(null);
            }
            return CompletableFuture.completedFuture(content);
        });
    }

    public ContentObject getObject(String objectId, String ... fields) {
        CompletableFuture<ContentObject> future = this.getObjectAsync(objectId, fields);
        return (ContentObject)this.get(future);
    }

    public ContentObject getObject(String objectId, long minimumVersion, long timeoutMillis, String ... fields) {
        CompletableFuture<ContentObject> future = this.getObjectAsync(objectId, minimumVersion, timeoutMillis, fields);
        return (ContentObject)this.get(future);
    }

    public CompletableFuture<Boolean> deleteObjectAsync(String objectId) {
        String path = String.format("/bi/v1/objects/%s", objectId);
        RestClient.QueryParams queryParams = new RestClient.QueryParams();
        queryParams.add("recursive", new String[]{"true"});
        return this.deleteAsync(path, queryParams).thenApply(json -> {
            this.notifyDeleted(objectId);
            return Boolean.TRUE;
        });
    }

    public Boolean deleteObject(String objectId) {
        CompletableFuture<Boolean> future = this.deleteObjectAsync(objectId);
        return (Boolean)this.get(future);
    }

    public CompletableFuture<Boolean> deleteObjectsAsync(String objectIds) {
        String path = "/bi/v1/objects";
        RestClient.QueryParams queryParams = new RestClient.QueryParams();
        queryParams.add("ids", new String[]{objectIds});
        queryParams.add("recursive", new String[]{"true"});
        return this.deleteAsync(path, queryParams).thenApply(json -> {
            Arrays.stream(objectIds.split(",")).forEach(this::notifyDeleted);
            return Boolean.TRUE;
        });
    }

    public Boolean deleteObjects(String objectIds) {
        if (objectIds.isEmpty()) {
            return true;
        }
        CompletableFuture<Boolean> future = this.deleteObjectsAsync(objectIds);
        return (Boolean)this.get(future);
    }

    public CompletableFuture<ContentObject> getObjectBaseModuleAsync(String objectId, String ... fields) {
        return this.getObjectBaseModuleAsync(objectId, 0L, 0L, fields);
    }

    public ContentObject getObjectBaseModule(String objectId, String ... fields) {
        return this.getObjectBaseModule(objectId, 0L, 0L, fields);
    }

    public CompletableFuture<ContentObject> getObjectBaseModuleAsync(String objectId, long minimumVersion, long timeoutMillis, String ... fields) {
        long expiry = System.currentTimeMillis() + timeoutMillis;
        StringBuilder path = new StringBuilder(String.format("/bi/v1/objects/%s/base_module", objectId));
        RestClient.QueryParams queryParams = this.buildFieldsQueryParam(fields);
        return this.getObjectBaseModuleAsync(path.toString(), queryParams, minimumVersion, expiry, fields);
    }

    private CompletableFuture<ContentObject> getObjectBaseModuleAsync(String path, RestClient.QueryParams queryParams, long minimumVersion, long expiry, String ... fields) {
        return this.getAsync(path, queryParams).thenCompose(json -> {
            ContentObject content;
            List<ContentObject> objects = CaContentRestClient.parseObjects(json, fields);
            ContentObject contentObject = content = objects.isEmpty() ? null : objects.get(0);
            while (content == null || content.version != null && content.version < minimumVersion) {
                if (System.currentTimeMillis() < expiry) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    String contentJson = this.get(path, queryParams);
                    objects = CaContentRestClient.parseObjects(contentJson, fields);
                    content = objects.isEmpty() ? null : objects.get(0);
                    continue;
                }
                return CompletableFuture.completedFuture(null);
            }
            return CompletableFuture.completedFuture(content);
        });
    }

    public ContentObject getObjectBaseModule(String objectId, long minimumVersion, long timeoutMillis, String ... fields) {
        CompletableFuture<ContentObject> future = this.getObjectBaseModuleAsync(objectId, minimumVersion, timeoutMillis, fields);
        return (ContentObject)this.get(future);
    }

    public CompletableFuture<Boolean> objectExistsAsync(String objectId) {
        return this.getObjectAsync(objectId, new String[0]).thenApply(object -> object != null);
    }

    public Boolean objectExists(String objectId) {
        CompletableFuture<Boolean> future = this.objectExistsAsync(objectId);
        return (Boolean)this.get(future);
    }

    public CompletableFuture<List<ContentObject>> getObjectItemsAsync(String parentId, String types, String ... fields) {
        String path = String.format("/bi/v1/objects/%s/items", parentId);
        RestClient.QueryParams queryParams = this.buildFieldsQueryParam(fields);
        if (types != null) {
            queryParams.add("types", new String[]{types});
        }
        return this.getAsync(path, queryParams).thenApply(json -> {
            List<ContentObject> objects = CaContentRestClient.parseObjects(json, fields);
            return objects;
        });
    }

    public CompletableFuture<List<ContentObject>> getObjectSmartModulesAsync(String parentId, String types, List<String> tags, String ... fields) {
        String path = String.format("/bi/v1/objects/%s/smarts_modules", parentId);
        RestClient.QueryParams queryParams = this.buildFieldsQueryParam(fields);
        if (types != null) {
            queryParams.add("types", new String[]{types});
        }
        if (!tags.isEmpty()) {
            queryParams.add("tags", new String[]{this.queryString(tags)});
        }
        return this.getAsync(path, queryParams).thenApply(json -> CaContentRestClient.parseObjects(json, fields));
    }

    public List<ContentObject> getObjectItems(String parentId, String types, String ... fields) {
        CompletableFuture<List<ContentObject>> future = this.getObjectItemsAsync(parentId, types, fields);
        return (List)this.get(future);
    }

    public CompletableFuture<List<String>> getObjectIdsByPrefixAsync(String parentId, String types, String namePrefix) {
        return this.getObjectItemsAsync(parentId, types, new String[0]).thenApply(objects -> {
            ArrayList<String> ids = new ArrayList<String>();
            for (ContentObject o : objects) {
                if (namePrefix != null && (o.defaultName == null || !o.defaultName.startsWith(namePrefix))) continue;
                ids.add(o.id);
            }
            return ids;
        });
    }

    public List<String> getObjectIdsByPrefix(String parentId, String type, String namePrefix) {
        CompletableFuture<List<String>> future = this.getObjectIdsByPrefixAsync(parentId, type, namePrefix);
        return (List)this.get(future);
    }

    private RestClient.QueryParams buildFieldsQueryParam(String ... fields) {
        RestClient.QueryParams queryParams = new RestClient.QueryParams();
        boolean firstField = true;
        if (fields != null && fields.length > 0) {
            StringBuilder fieldsValue = new StringBuilder();
            for (int i = 0; i < fields.length; ++i) {
                if (firstField) {
                    firstField = false;
                } else {
                    fieldsValue.append(",");
                }
                fieldsValue.append(fields[i]);
            }
            queryParams.add("fields", new String[]{fieldsValue.toString()});
        }
        return queryParams;
    }

    private String queryString(List<String> tags) {
        StringBuilder queryBuilder = new StringBuilder();
        FirstFlag firstFlag = new FirstFlag();
        tags.forEach(tag -> {
            if (firstFlag.first) {
                firstFlag.first = false;
            } else {
                queryBuilder.append(",");
            }
            queryBuilder.append(SmartsModulePublishUtil.truncateTag((String)tag));
        });
        return queryBuilder.toString();
    }

    public static List<ContentObject> parseObjects(String json, String ... fields) {
        JSONObject jsonObject;
        ArrayList<ContentObject> result = new ArrayList<ContentObject>();
        try {
            jsonObject = JSONObject.parse((String)json);
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e, "Failed to parse the object response.", new Object[0]);
        }
        JSONArray data = (JSONArray)jsonObject.get((Object)"data");
        for (int i = 0; i < data.size(); ++i) {
            ContentObject o = CaContentRestClient.parseObjectData((JSONObject)data.get(i), fields);
            if (o == null) continue;
            result.add(o);
        }
        return result;
    }

    private static ContentObject parseObjectData(JSONObject dataObject, String ... fields) {
        ContentObject result = null;
        if (dataObject != null) {
            result = new ContentObject((String)dataObject.get((Object)"id"), (String)dataObject.get((Object)"type"), (String)dataObject.get((Object)"defaultName"), (Long)dataObject.get((Object)"version"));
            if (fields != null) {
                for (String field : fields) {
                    Object fieldObject = dataObject.get((Object)field);
                    String value = fieldObject != null ? fieldObject.toString() : "";
                    result.addField(field, value);
                }
            }
        }
        return result;
    }

    public Response updateObjectSmartsModule(String id, String smartsModuleName, SmartsModule smartsModule) {
        return this.createObjectSmartsModule(id, smartsModuleName, smartsModule, Collections.emptyList(), false);
    }

    public Response createObjectSmartsModule(String id, String smartsModuleName, SmartsModule smartsModule, List<String> tags, boolean replace) {
        String path = String.format("/bi/v1/objects/%s/smarts_modules", id);
        String body = this.createSmartsModuleRequestBody(smartsModuleName, smartsModule, null, tags);
        RestClient.QueryParams queryParams = null;
        if (replace) {
            queryParams = new RestClient.QueryParams();
            queryParams.add("updateAction", new String[]{"replace"});
        }
        return this.postResponse(path, body, queryParams);
    }

    public Response updateObjectSmartsModule(String resourceURI, String smartsModuleName, SmartsModule smartsModule, String version, List<String> tags) {
        String body = this.createSmartsModuleRequestBody(smartsModuleName, smartsModule, version, tags);
        return this.putResponse(resourceURI, body);
    }

    private String createSmartsModuleRequestBody(String smartsModuleName, SmartsModule smartsModule, String version, List<String> tags) {
        JSONObject smartsModuleObject = new JSONObject();
        smartsModuleObject.put((Object)"type", (Object)"smartsModule");
        List datasets = smartsModule.getDatasets();
        if (!datasets.isEmpty()) {
            List analysisPhases;
            List columnEmbeddings;
            DatasetInfo datasetInfo = (DatasetInfo)datasets.get(0);
            List bivariateStatistics = datasetInfo.getBivariateStatistics();
            if (!bivariateStatistics.isEmpty()) {
                smartsModuleObject.put((Object)"biVariates", (Object)this.encodeSource(bivariateStatistics));
                bivariateStatistics.clear();
            }
            if (!(columnEmbeddings = datasetInfo.getColumnEmbeddings()).isEmpty()) {
                smartsModuleObject.put((Object)"columnEmbedding", (Object)this.encodeSource(columnEmbeddings));
                columnEmbeddings.clear();
            }
            if (!"SmartsModule".equals(smartsModuleName) && !(analysisPhases = datasetInfo.getAnalysisPhases()).isEmpty()) {
                smartsModuleObject.put((Object)"status", (Object)this.encodeSource(analysisPhases));
            }
        }
        if ("SmartsModule".equals(smartsModuleName) && smartsModule.getAnalysisState() != null) {
            smartsModuleObject.put((Object)"status", (Object)this.encodeSource(smartsModule.getAnalysisState()));
        }
        smartsModuleObject.put((Object)"smartsData", (Object)this.encodeSource(smartsModule));
        if (smartsModuleName != null && !smartsModuleName.isEmpty()) {
            smartsModuleObject.put((Object)"defaultName", (Object)smartsModuleName);
        }
        if (!tags.isEmpty()) {
            JSONArray tagsArray = new JSONArray();
            tagsArray.addAll(tags);
            smartsModuleObject.put((Object)"tags", (Object)tagsArray);
        }
        if (!StringUtils.isBlank((CharSequence)version)) {
            smartsModuleObject.put((Object)"version", (Object)version);
        }
        return CommonJAXBHelper.marshalToJSON((Object)smartsModuleObject);
    }

    @Deprecated
    public SmartsModule getObjectSmartsModule(String id) {
        return this.getObjectSmartsModule(id, Collections.emptyList(), true, true);
    }

    public SmartsModule getObjectSmartsModule(String id, List<String> tags, boolean includeFailedDataset, boolean includeBivariates) {
        return this.getObjectSmartsModule(id, tags, includeFailedDataset, includeBivariates, false);
    }

    public SmartsModule getObjectSmartsModule(String id, List<String> tags, boolean includeFailedDataset, boolean includeBivariates, boolean includeColumnEmbedding) {
        SmartsModuleOptions smartsModuleOptions = new SmartsModuleOptions.SmartsModuleOptionsBuilder().addBivariates(includeBivariates).addFailedDataSets(includeFailedDataset).addColumnEmbedding(includeColumnEmbedding).build();
        CompletableFuture<SmartsModule> result = this.getObjectSmartsModuleAsync(id, tags, smartsModuleOptions);
        return (SmartsModule)this.get(result);
    }

    public SmartsModule getObjectSmartsModule(String id, List<String> tags, SmartsModuleOptions smartsModuleOptions) {
        CompletableFuture<SmartsModule> result = this.getObjectSmartsModuleAsync(id, tags, smartsModuleOptions);
        return (SmartsModule)this.get(result);
    }

    public IRecord<SmartsModule> getSmartsModuleRecord(String id, List<String> tags, SmartsModuleOptions smartsModuleOptions) {
        boolean isColumnEmbeddingOnly;
        boolean bl = isColumnEmbeddingOnly = smartsModuleOptions != null && smartsModuleOptions.isExcludeSmartsData() && smartsModuleOptions.isIncludeColumnEmbedding() && !smartsModuleOptions.isIncludeBivariates();
        if (isColumnEmbeddingOnly) {
            return this.fetchOnlyColumnEmbedding(id, tags);
        }
        CompletableFuture<IRecord<SmartsModule>> result = this.getObjectSmartsModuleRecordAsync(id, tags, smartsModuleOptions);
        return (IRecord)this.get(result);
    }

    public CompletableFuture<IRecord<SmartsModule>> getSmartsModuleRecordAsync(String id, List<String> tags, SmartsModuleOptions smartsModuleOptions) {
        return this.getObjectSmartsModuleRecordAsync(id, tags, smartsModuleOptions);
    }

    public CompletableFuture<SmartsModule> getObjectSmartsModuleAsync(String id) {
        SmartsModuleOptions smartsModuleOptions = new SmartsModuleOptions.SmartsModuleOptionsBuilder().addFailedDataSets(true).addBivariates(true).build();
        return this.getObjectSmartsModuleAsync(id, Collections.emptyList(), smartsModuleOptions);
    }

    public SmartsModule fetchStatus(String id, AnalysisScope analysisScope, SmartsModuleOptions options) {
        List tags = AnalysisScopes.getInScopeTableNames((AnalysisScope)analysisScope);
        SmartsModule smartsModule = (SmartsModule)this.get(this.fetchStatusR7(id, tags, options));
        if (smartsModule == null) {
            smartsModule = (SmartsModule)this.get(this.fetchStatusR6(id, tags));
        }
        if (smartsModule == null) {
            return (SmartsModule)this.get(this.getObjectSmartsModuleAsync(id, tags, options));
        }
        return smartsModule;
    }

    private CompletableFuture<SmartsModule> fetchStatusR7(String id, List<String> tags, SmartsModuleOptions options) {
        SmartsModule globalSmartsModule = this.getObjectSmartsModule(id, Collections.singletonList("SmartsModule"), options);
        if (globalSmartsModule == null || globalSmartsModule.getDatasets().isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        if (tags != null && !tags.isEmpty()) {
            HashSet<String> ids = new HashSet<String>(tags);
            ids.remove("SmartsModule");
            if (!ids.isEmpty()) {
                globalSmartsModule.getDatasets().removeIf(ds -> !ids.contains(ds.getId()));
                globalSmartsModule.setAnalysisState(SmartsUtil.calculateState((SmartsModule)globalSmartsModule));
            }
        }
        return CompletableFuture.completedFuture(globalSmartsModule);
    }

    private CompletableFuture<SmartsModule> fetchStatusR6(String id, List<String> tags) {
        String[] fields = SmartsModuleCMFields.STATUS_ONLY_FIELDS.getEnabled();
        CompletableFuture<List<ContentObject>> responseFuture = this.getObjectSmartModulesAsync(id, "smartsModule", tags, fields);
        return responseFuture.thenApply(parts -> {
            String analysisPhasesData;
            if (parts.isEmpty()) {
                return null;
            }
            Map<String, ContentObject> nameToParts = parts.stream().filter(part -> StringUtils.isNotBlank((CharSequence)part.getField("status"))).collect(Collectors.toMap(part -> part.getField("defaultName"), part -> part));
            if (nameToParts.isEmpty()) {
                return null;
            }
            SmartsModule smartsModule = SmartsModuleFactory.createSmartsModule();
            ContentObject globalPart = nameToParts.remove("SmartsModule");
            if (globalPart != null && StringUtils.isNotBlank((CharSequence)(analysisPhasesData = (String)globalPart.getFields().get("status")))) {
                AnalysisStateType analysisPhases = this.decodeSource(AnalysisStateType.class, analysisPhasesData);
                smartsModule.setAnalysisState(analysisPhases);
            }
            nameToParts.entrySet().stream().filter(entry -> entry.getKey() != null).forEach(entry -> {
                String name = (String)entry.getKey();
                ContentObject part = (ContentObject)entry.getValue();
                String analysisPhasesData = (String)part.getFields().get("status");
                String datasetId = name.replace("-SemanticInfo", "");
                List<Object> analysisPhases = new ArrayList();
                if (StringUtils.isNotBlank((CharSequence)analysisPhasesData)) {
                    analysisPhases = this.decodeListSource(AnalysisPhase.class, analysisPhasesData);
                }
                List datasets = smartsModule.getDatasets();
                DatasetInfo datasetInfo = new DatasetInfo();
                datasetInfo.setId(datasetId);
                datasetInfo.getAnalysisPhases().addAll(analysisPhases);
                datasets.add(datasetInfo);
            });
            if (smartsModule.getAnalysisState() == null || tags != null && !tags.stream().anyMatch(t -> t.equals("SmartsModule"))) {
                smartsModule.setAnalysisState(SmartsUtil.calculateState((SmartsModule)smartsModule));
            }
            return smartsModule;
        });
    }

    protected IRecord<SmartsModule> fetchOnlyColumnEmbedding(String id, List<String> tags) {
        SmartsModule smartsModule = (SmartsModule)this.get(this.fetchColumnEmbeddingR6(id));
        if (smartsModule == null) {
            smartsModule = (SmartsModule)this.get(this.fetchColumnEmbeddingR5(id));
        }
        return IRecord.create((Object)smartsModule, (String)id);
    }

    private CompletableFuture<SmartsModule> fetchColumnEmbeddingR6(String id) {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("defaultName");
        fields.add("columnEmbedding");
        CompletableFuture<List<ContentObject>> responseFuture = this.getObjectSmartModulesAsync(id, "smartsModule", Collections.emptyList(), fields.toArray(new String[0]));
        return responseFuture.thenApply(parts -> {
            if (parts.isEmpty()) {
                return null;
            }
            SmartsModule smartsModule = SmartsModuleFactory.createSmartsModule();
            boolean hasColumnEmbeddings = false;
            for (ContentObject part : parts) {
                String partName = (String)part.getFields().get("defaultName");
                String columnEmbeddingData = (String)part.getFields().get("columnEmbedding");
                List<Object> columnEmbeddings = new ArrayList();
                if (StringUtils.isNotBlank((CharSequence)columnEmbeddingData)) {
                    columnEmbeddings = this.decodeListSource(ColumnEmbedding.class, columnEmbeddingData);
                    hasColumnEmbeddings = true;
                }
                if (columnEmbeddings.isEmpty()) continue;
                String datasetName = partName != null ? partName.replace("-SemanticInfo", "") : "";
                List datasets = smartsModule.getDatasets();
                DatasetInfo datasetInfo = new DatasetInfo();
                datasetInfo.setId(datasetName);
                datasetInfo.getColumnEmbeddings().addAll(columnEmbeddings);
                datasets.add(datasetInfo);
            }
            if (hasColumnEmbeddings) {
                return smartsModule;
            }
            return null;
        });
    }

    private CompletableFuture<SmartsModule> fetchColumnEmbeddingR5(String id) {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("defaultName");
        fields.add("smartsData");
        CompletableFuture<List<ContentObject>> responseFuture = this.getObjectSmartModulesAsync(id, "smartsModule", Collections.singletonList("ColumnEmbedding"), fields.toArray(new String[0]));
        return responseFuture.thenApply(parts -> {
            if (parts.isEmpty()) {
                return null;
            }
            ContentObject columnEmbeddingCO = (ContentObject)parts.get(0);
            String partName = (String)columnEmbeddingCO.getFields().get("defaultName");
            if (!"ColumnEmbedding".equals(partName)) {
                return null;
            }
            String smartsData = (String)columnEmbeddingCO.getFields().get("smartsData");
            return this.decodeSource(SmartsModule.class, smartsData);
        });
    }

    private CompletableFuture<SmartsModule> getObjectSmartsModuleAsync(String id, List<String> tags, SmartsModuleOptions smartsModuleOptions) {
        return this.getObjectSmartsModuleRecordAsync(id, tags, smartsModuleOptions).thenApply(sm -> sm != null ? (SmartsModule)sm.getRecord() : null);
    }

    private CompletableFuture<IRecord<SmartsModule>> getObjectSmartsModuleRecordAsync(String id, List<String> tags, SmartsModuleOptions smartsModuleOptions) {
        if (tags != null && !tags.isEmpty() && !tags.contains("SmartsModule")) {
            tags.add("SmartsModule");
        }
        CompletableFuture<List<ContentObject>> responseFuture = this.fetchSmartsModuleObjectFromCM(id, tags, smartsModuleOptions);
        return responseFuture.thenApply(parts -> {
            SmartsModule smartsModule;
            if (parts.isEmpty()) {
                return IRecord.create(null, (String)id);
            }
            SmartsModule globalSmartsModule = null;
            SmartsModule smartsModuleWithColumnEmbeddings = null;
            Instant creationTime = Instant.MAX;
            Instant modificationTime = Instant.MIN;
            String globalSmartsModuleVersion = "";
            ArrayList<SmartsModule> smartsModuleParts = new ArrayList<SmartsModule>();
            HashMap<String, String> resourceUrlMap = new HashMap<String, String>();
            boolean includeBivariates = smartsModuleOptions != null && smartsModuleOptions.isIncludeBivariates();
            boolean includeColumnEmbedding = smartsModuleOptions != null && smartsModuleOptions.isIncludeColumnEmbedding();
            for (ContentObject part : parts) {
                String smartsData = (String)part.getFields().get("smartsData");
                smartsData = StringUtils.isNotBlank((CharSequence)smartsData) ? smartsData : "{}";
                String biVariatesData = (String)part.getFields().get("biVariates");
                String columnEmbeddingData = (String)part.getFields().get("columnEmbedding");
                String partName = (String)part.getFields().get("defaultName");
                creationTime = this.pickTime(creationTime, part, "creationTime", Instant::isBefore);
                modificationTime = this.pickTime(modificationTime, part, "modificationTime", Instant::isAfter);
                resourceUrlMap.put(partName, String.format("/bi/v1/objects/%s", part.id));
                SmartsModule sm = this.decodeSource(SmartsModule.class, smartsData);
                List<Object> biVariateStatistics = new ArrayList();
                List<Object> columnEmbeddings = new ArrayList();
                if (includeBivariates && StringUtils.isNotBlank((CharSequence)biVariatesData)) {
                    biVariateStatistics = this.decodeListSource(BivariateStatistics.class, biVariatesData);
                }
                if (includeColumnEmbedding && StringUtils.isNotBlank((CharSequence)columnEmbeddingData)) {
                    columnEmbeddings = this.decodeListSource(ColumnEmbedding.class, columnEmbeddingData);
                }
                List datasets = sm.getDatasets();
                if (partName.equals("SmartsModule")) {
                    globalSmartsModule = sm;
                    globalSmartsModuleVersion = String.valueOf(part.version);
                    continue;
                }
                if (datasets.isEmpty()) continue;
                DatasetInfo datasetInfo = (DatasetInfo)datasets.get(0);
                if (!biVariateStatistics.isEmpty()) {
                    datasetInfo.getBivariateStatistics().clear();
                    datasetInfo.getBivariateStatistics().addAll(biVariateStatistics);
                }
                if (!columnEmbeddings.isEmpty()) {
                    datasetInfo.getColumnEmbeddings().clear();
                    datasetInfo.getColumnEmbeddings().addAll(columnEmbeddings);
                }
                if (partName.equals("ColumnEmbedding")) {
                    if (!includeColumnEmbedding) continue;
                    smartsModuleWithColumnEmbeddings = sm;
                    continue;
                }
                smartsModuleParts.add(sm);
            }
            if (globalSmartsModule != null) {
                boolean clearDatasets = tags == null || tags.size() != 1 || !((String)tags.get(0)).equals("SmartsModule");
                smartsModule = SmartsUtil.smartsModuleFromParts(smartsModuleParts, globalSmartsModule, (boolean)clearDatasets);
            } else {
                smartsModule = SmartsUtil.smartsModuleFromParts(smartsModuleParts);
                smartsModule.setAnalysisState(SmartsUtil.calculateState((SmartsModule)smartsModule));
            }
            if (smartsModuleWithColumnEmbeddings != null) {
                if (StringUtils.isBlank((CharSequence)smartsModule.getName())) {
                    smartsModule = smartsModuleWithColumnEmbeddings;
                } else {
                    this.moveColumnEmbeddingsToTargetSmartsModule(smartsModule, smartsModuleWithColumnEmbeddings);
                }
            }
            this.addTimestampInSmartModule(smartsModule, creationTime, modificationTime);
            if (!smartsModule.getDatasets().isEmpty()) {
                SmartsModuleUtil.filterSmartsModuleByOptions((SmartsModule)smartsModule, (SmartsModuleOptions)smartsModuleOptions);
            }
            return IRecord.create((Object)smartsModule, (String)id, (String)globalSmartsModuleVersion, resourceUrlMap);
        });
    }

    private void moveColumnEmbeddingsToTargetSmartsModule(SmartsModule smartsModule, SmartsModule smartsModuleWithColumnEmbeddings) {
        Objects.requireNonNull(smartsModule);
        Objects.requireNonNull(smartsModuleWithColumnEmbeddings);
        List initDatasets = smartsModuleWithColumnEmbeddings.getDatasets();
        List targetDatasets = smartsModule.getDatasets();
        if (targetDatasets.isEmpty()) {
            targetDatasets.addAll(initDatasets);
        } else {
            Map idToInitDatasets = initDatasets.stream().collect(Collectors.toMap(BaseObject::getId, Function.identity()));
            for (DatasetInfo targetDataset : targetDatasets) {
                String id = targetDataset.getId();
                DatasetInfo initDataset = (DatasetInfo)idToInitDatasets.get(id);
                if (initDataset == null) continue;
                List initColumnEmbeddings = initDataset.getColumnEmbeddings();
                List targetColumnEmbeddings = targetDataset.getColumnEmbeddings();
                if (initColumnEmbeddings.isEmpty() || !targetColumnEmbeddings.isEmpty()) continue;
                targetColumnEmbeddings.addAll(initColumnEmbeddings);
            }
        }
    }

    private CompletableFuture<List<ContentObject>> fetchSmartsModuleObjectFromCM(String id, List<String> tags, SmartsModuleOptions smartsModuleOptions) {
        String[] fields = CaContentRestClient.getFields(smartsModuleOptions);
        return this.getObjectSmartModulesAsync(id, "smartsModule", tags, fields);
    }

    private Instant pickTime(Instant time, ContentObject part, String fieldName, BiPredicate<Instant, Instant> compare) {
        String tempTime = (String)part.getFields().get(fieldName);
        if (StringUtils.isNotBlank((CharSequence)tempTime)) {
            try {
                Instant tempTimeInPart = Instant.parse(tempTime);
                return compare.test(tempTimeInPart, time) ? tempTimeInPart : time;
            }
            catch (DateTimeParseException e) {
                LOGGER.error("failed to parse time to LocalTime: " + tempTime, (Throwable)e);
            }
        }
        return time;
    }

    private void addTimestampInSmartModule(SmartsModule smartsModule, Instant creationTime, Instant modificationTime) {
        XMLGregorianCalendar calendar;
        if (!Instant.MAX.equals(creationTime)) {
            try {
                calendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(creationTime.toString());
                smartsModule.setModuleCreationTime(calendar);
            }
            catch (DatatypeConfigurationException e) {
                LOGGER.error("failed to parse module creation time " + creationTime, (Throwable)e);
            }
        }
        if (!Instant.MIN.equals(modificationTime)) {
            try {
                calendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(modificationTime.toString());
                smartsModule.setModuleLastModifiedTime(calendar);
            }
            catch (DatatypeConfigurationException e) {
                LOGGER.error("failed to parse module modification time " + modificationTime, (Throwable)e);
            }
        }
    }

    private static String[] getFields(SmartsModuleOptions smartsModuleOptions) {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("defaultName");
        fields.add("creationTime");
        fields.add("modificationTime");
        if (smartsModuleOptions == null || smartsModuleOptions.isIncludeSmartsData()) {
            fields.add("smartsData");
        }
        if (smartsModuleOptions != null && smartsModuleOptions.isIncludeBivariates()) {
            fields.add("biVariates");
        }
        if (smartsModuleOptions != null && smartsModuleOptions.isIncludeColumnEmbedding()) {
            fields.add("columnEmbedding");
        }
        return fields.toArray(new String[0]);
    }

    private boolean isCompressed(String moduleSource) {
        return !moduleSource.startsWith("{");
    }

    /*
     * Exception decompiling
     */
    private <T> String encodeSource(T obj) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private <T> List<T> decodeListSource(Class<T> clazz, String source) {
        String jsonSource = this.decompressSource(clazz, source);
        return CommonJAXBHelper.unmarshalListFromJSON(clazz, (String)jsonSource);
    }

    private <T> T decodeSource(Class<T> clazz, String source) {
        String jsonSource = this.decompressSource(clazz, source);
        return (T)CommonJAXBHelper.unmarshalFromJSON(clazz, (String)jsonSource);
    }

    private <T> String decompressSource(Class<T> clazz, String source) {
        String jsonSource;
        block27: {
            if (this.isCompressed(source)) {
                byte[] base64 = Base64.getDecoder().decode(source);
                try (ByteArrayInputStream bis = new ByteArrayInputStream(base64);
                     GZIPInputStream gzipIS = new GZIPInputStream(bis);){
                    jsonSource = IOUtils.toString((InputStream)gzipIS, (Charset)StandardCharsets.UTF_8);
                    break block27;
                }
                catch (IOException ex) {
                    throw new InternalException((Throwable)ex, "Unable to decode the source string of type:" + clazz, new Object[0]);
                }
            }
            jsonSource = source;
        }
        return jsonSource;
    }

    public Boolean deleteSmartsModule(String id) {
        if (id == null || id.isEmpty()) {
            throw new InternalException("Unexpectedly empty id parameter passed to deleteSmartsModule", new Object[0]);
        }
        String path = String.format("/bi/v1/objects/%s/smarts_modules", id);
        CompletableFuture cf = this.deleteAsync(path, null);
        String response = (String)this.get(cf);
        JSONObject jsonObject = null;
        try {
            jsonObject = JSONObject.parse((String)response);
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e, "Failed to parse the delete SmartsModule response.", new Object[0]);
        }
        if (jsonObject.containsKey((Object)"count")) {
            return true;
        }
        return false;
    }

    public Boolean deleteSmartsModule(List<String> listUri) {
        if (listUri == null || listUri.isEmpty()) {
            throw new InternalException("Unexpectedly empty ids parameter passed to deleteSmartsModule", new Object[0]);
        }
        String idsString = listUri.stream().map(uri -> this.convertResourceUriToId((String)uri)).collect(Collectors.joining(","));
        RestClient.QueryParams queryParams = new RestClient.QueryParams();
        queryParams.add("ids", new String[]{idsString});
        CompletableFuture cf = this.deleteAsync("/bi/v1/objects", queryParams);
        String response = (String)this.get(cf);
        JSONObject jsonObject = null;
        try {
            jsonObject = JSONObject.parse((String)response);
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e, "Failed to parse the delete SmartsModule response.", new Object[0]);
        }
        if (jsonObject.containsKey((Object)"count")) {
            return true;
        }
        return false;
    }

    private String convertResourceUriToId(String resourceUri) {
        if (resourceUri == null) {
            return null;
        }
        String[] parts = resourceUri.split("/");
        return parts[parts.length - 1];
    }

    private class FirstFlag {
        boolean first = true;

        private FirstFlag() {
        }
    }

    public static class Headers {
        public static final String LOCATION = "Location";
    }

    public static class Locations {
        public static final String MY_FOLDERS = ".my_folders";
        public static final String PUBLIC_FOLDERS = ".public_folders";
    }

    static class SmartsModuleCMObjectFields {
        static final String SMARTS_DATA = "smartsData";
        static final String BIVARIATES_DATA = "biVariates";
        static final String COLUMN_EMBEDDING_DATA = "columnEmbedding";
        static final String TAGS = "tags";
        static final String STATUS = "status";

        SmartsModuleCMObjectFields() {
        }
    }

    public static class ObjectTypes {
        public static final String FOLDER = "folder";
        public static final String BASE_MODULE = "baseModule";
        public static final String MODULE = "module";
        public static final String SMARTS_MODULE = "smartsModule";
    }

    public static class ObjectFields {
        public static final String ID = "id";
        public static final String TYPE = "type";
        public static final String DEFAULT_NAME = "defaultName";
        public static final String VERSION = "version";
        public static final String ANCESTORS = "ancestors";
        public static final String BASE_DEFINITION = "baseDefinition";
        public static final String PHYSICAL_DEFINITION = "physicalDefinition";
        public static final String BASE_ANALYTICS = "baseAnalytics";
        public static final String DEFINITION = "definition";
        public static final String ANALYTICS = "analytics";
        public static final String STATUS = "status";
        public static final String ROUTING_SERVER_GROUP = "routingServerGroup";
        public static final String SEARCH_PATH = "searchPath";
        public static final String DEPLOYMENT_REFS = "deploymentReferences";
        public static final String CATALOG = "catalog";
        public static final String SCHEMA = "schema";
        public static final String PARENT = "parent";
        public static final String CREATION_TIME = "creationTime";
        public static final String MODIFICATION_TIME = "modificationTime";
        public static final String PERMISSIONS = "permissions";
        public static final String META = "_meta";
    }

    public static class Paths {
        public static final String OBJECTS = "/bi/v1/objects";
        public static final String OBJECT = "/bi/v1/objects/%s";
        public static final String OBJECT_BASE_MODULE = "/bi/v1/objects/%s/base_module";
        public static final String OBJECT_ITEMS = "/bi/v1/objects/%s/items";
        public static final String OBJECT_SMARTS_MODULES = "/bi/v1/objects/%s/smarts_modules";
    }
}

