/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ca.core.impl.questiongenerator;

import com.ibm.smarts.ca.core.rest.client.CaRestClient;
import com.ibm.smarts.common.util.CommonJAXBHelper;
import com.ibm.smarts.core.rest.client.RestClient;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.model.qg.GenerateQuestionsRequest;
import com.ibm.smarts.model.qg.GenerateQuestionsResponse;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

public class CaQuestionGeneratorClient
extends CaRestClient {
    public CaQuestionGeneratorClient(RestClient.RestCallContextFactory rccf, RequestContext requestContext, String uri) {
        super(rccf, requestContext, uri);
    }

    public GenerateQuestionsResponse generateQuestions(GenerateQuestionsRequest request) {
        try {
            return this.generateQuestionsAsync(request).get();
        }
        catch (InterruptedException | ExecutionException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    private CompletableFuture<GenerateQuestionsResponse> generateQuestionsAsync(GenerateQuestionsRequest request) {
        String path = Paths.generatePath();
        String requestJson = CommonJAXBHelper.marshalToJSON((Object)request);
        return this.generateAsync(path, requestJson).thenApply(json -> (GenerateQuestionsResponse)CommonJAXBHelper.unmarshalFromJSON(GenerateQuestionsResponse.class, (String)json));
    }

    private CompletableFuture<String> generateAsync(String path, String request) {
        return this.postAsync(path, request);
    }

    private static class Paths {
        private static final String QUESTION_GENERATOR = "/bi/v1/smarts/question-generator";
        private static final String GENERATE = "/bi/v1/smarts/question-generator/generate";

        private Paths() {
        }

        private static String generatePath() {
            return GENERATE;
        }
    }
}

