/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ca.core.impl.search;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.smarts.ca.core.impl.Messages;
import com.ibm.smarts.ca.core.rest.client.CaRestClient;
import com.ibm.smarts.core.exceptions.InternalException;
import com.ibm.smarts.core.rest.client.RestClient;
import com.ibm.smarts.core.rest.client.util.JaxRs20Exceptions;
import com.ibm.smarts.core.rest.client.util.JaxRs20Helper;
import com.ibm.smarts.core.rest.client.util.RestClientHelper;
import com.ibm.smarts.core.util.Ensure;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.model.common.content.ContentObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

public class CaSearchClient
extends CaRestClient {
    public CaSearchClient(RestClient.RestCallContextFactory rccf, RequestContext requestContext, String uri) {
        super(rccf, requestContext, uri);
    }

    public void createIndex(String schema) {
        Ensure.nonBlank((String[])new String[]{schema});
        this.post("/bi/v1/collections", schema);
    }

    public CompletableFuture<Response> searchAsync(String index, RestClient.QueryParams params) {
        return this.searchAsync(index, params, null);
    }

    public CompletableFuture<Response> searchAsync(String index, RestClient.QueryParams params, String body) {
        Ensure.nonBlank((String[])new String[]{index});
        if (params == null) {
            throw new IllegalArgumentException("query params cannot be null");
        }
        String path = "/bi/v1/select/" + index;
        return StringUtils.isBlank((CharSequence)body) ? this.getAsyncResponse(path, params) : this.postAsyncResponse(path, body, params);
    }

    public CompletableFuture<List<ContentObject>> getAllCMItemsAsync() {
        RestClient.QueryParams params = new RestClient.QueryParams();
        params.add("fields", new String[]{"id,defaultName,ancestors,type"});
        params.add("filter", new String[]{"type|module|uploadedFile|package|dataSet2|data_asset"});
        params.add("hide_internal", new String[]{"all"});
        return this.getAsync("/bi/v1/search/cm", params).thenApply(json -> CaSearchClient.parseModuleInfoList(json));
    }

    public List<ContentObject> getAllCMItems() {
        return (List)this.get(this.getAllCMItemsAsync());
    }

    private static List<ContentObject> parseModuleInfoList(String json) {
        ArrayList<ContentObject> moduleList = new ArrayList<ContentObject>();
        try {
            JSONObject jsonObj = JSONObject.parse((String)json);
            JSONArray jsonList = (JSONArray)jsonObj.get((Object)"results");
            for (int i = 0; i < jsonList.size(); ++i) {
                JSONObject obj = (JSONObject)jsonList.get(i);
                ContentObject content = new ContentObject((String)obj.get((Object)"id"), (String)obj.get((Object)"type"), (String)obj.get((Object)"defaultName"), Long.valueOf("1"));
                JSONArray ancestors = (JSONArray)obj.get((Object)"ancestors");
                content.addField("location", CaSearchClient.parseLocationfromAncestors(ancestors));
                moduleList.add(content);
            }
            return moduleList;
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e, "Failed to parse mdoule list from response json.", new Object[0]);
        }
    }

    private static String parseLocationfromAncestors(JSONArray ancestors) {
        String myFolderLabel = Messages.getString("MY_FOLDERS");
        String teamFolderLabel = Messages.getString("TEAM_CONTENT");
        StringBuilder location = new StringBuilder();
        for (int j = 0; j < ancestors.size(); ++j) {
            JSONObject ancestor = (JSONObject)ancestors.get(j);
            String type = (String)ancestor.get((Object)"type");
            if (!"folder".equals(type) && !"content".equals(type)) continue;
            String folderName = (String)ancestor.get((Object)"defaultName");
            if (location.length() > 0) {
                location.append(" > ");
            } else if ("My Folders".equals(folderName)) {
                folderName = myFolderLabel;
            } else if ("Team Content".equals(folderName)) {
                folderName = teamFolderLabel;
            }
            location.append(folderName);
        }
        return location.toString();
    }

    public Response storeSerialized(String index, String serializedDocuments) {
        Ensure.nonBlank((String[])new String[]{index, serializedDocuments});
        Response resp = this.putResponse(this.documentsPath(index), serializedDocuments);
        this.handleIndexDoesNotExistResponse(index, resp);
        return resp;
    }

    public boolean indexExists(String index) {
        Ensure.nonBlank((String[])new String[]{index});
        Response response = this.getResponse(this.collectionsPath(index));
        return response.getStatus() == 200;
    }

    private String documentsPath(String index) {
        return this.collectionsPath(index) + "/documents";
    }

    protected String collectionsPath(String index) {
        return "/bi/v1/collections/" + index;
    }

    public boolean handleIndexDoesNotExistResponse(String index, Response resp) {
        if (resp.getStatus() == 404) {
            JaxRs20Exceptions.ProcessingException e = RestClientHelper.buildException((Response)resp);
            LOGGER.warn("Index '" + index + "' does not exist", (Throwable)e);
            return true;
        }
        Response.Status.Family f = JaxRs20Helper.familyForResponse((Response)resp);
        if (f == Response.Status.Family.REDIRECTION || f == Response.Status.Family.CLIENT_ERROR || f == Response.Status.Family.SERVER_ERROR) {
            throw RestClientHelper.buildException((Response)resp);
        }
        return false;
    }

    public static class Paths {
        public static final String SEARCH = "/bi/v1/select";
        public static final String SEARCH_CM = "/bi/v1/search/cm";
        public static final String COLLECTIONS = "/bi/v1/collections";
        public static final String DOCUMENTS = "/documents";
    }
}

