/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ca.core.rest.client;

import com.ibm.smarts.ca.core.rest.util.MultivaluedHashMap;
import com.ibm.smarts.core.util.StringUtils;
import com.ibm.smarts.core.util.ToString;
import com.sun.jersey.core.header.reader.HttpHeaderReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;

class BIJaxrsResponse
extends Response {
    private final int status;
    private final Response.StatusType statusType;
    private final Map<String, List<String>> headers;
    private final MultivaluedMap<String, Object> metadata;
    private final String body;

    public BIJaxrsResponse(final int status, Map<String, List<String>> headers, String body) {
        this.status = status;
        Object st = Response.Status.fromStatusCode((int)status);
        if (st == null) {
            st = new Response.StatusType(){

                public int getStatusCode() {
                    return status;
                }

                public Response.Status.Family getFamily() {
                    return Response.Status.Family.OTHER;
                }

                public String getReasonPhrase() {
                    return "unknown";
                }
            };
        }
        this.statusType = st;
        this.headers = headers;
        this.metadata = BIJaxrsResponse.buildMultivaluedHashMap(headers);
        this.body = body;
    }

    private <T> T notThere() {
        throw new UnsupportedOperationException();
    }

    public int getStatus() {
        return this.status;
    }

    public Response.StatusType getStatusInfo() {
        return this.statusType;
    }

    public Object getEntity() throws IllegalStateException {
        return this.body;
    }

    public <T> T readEntity(Class<T> entityType) throws WebApplicationException, IllegalStateException {
        if (entityType == String.class) {
            return (T)this.body;
        }
        return this.notThere();
    }

    public boolean hasEntity() {
        return false;
    }

    public boolean bufferEntity() throws WebApplicationException {
        return false;
    }

    public void close() throws WebApplicationException {
    }

    public String getHeaderString(String name) {
        List<String> values = this.headers.get(name);
        if (values == null) {
            return null;
        }
        if (values.isEmpty()) {
            return "";
        }
        String ret = StringUtils.join(values, (String)",");
        return ret;
    }

    public Map<String, NewCookie> getCookies() {
        List<String> cookies = this.headers.get("Set-Cookie");
        if (cookies == null || cookies.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, NewCookie> result = new HashMap<String, NewCookie>();
        for (String cookie : cookies) {
            if (cookie == null) continue;
            NewCookie newCookie = HttpHeaderReader.readNewCookie((String)cookie);
            result.put(newCookie.getName(), newCookie);
        }
        return result;
    }

    public MultivaluedMap<String, Object> getMetadata() {
        return this.metadata;
    }

    public String toString() {
        return ToString.with((Object)((Object)this)).field("status", (Object)this.status).field("headers", this.headers).field("body", (Object)this.body).get();
    }

    private static MultivaluedMap<String, Object> buildMultivaluedHashMap(Map<String, List<String>> headers) {
        MultivaluedHashMap<String, Object> ret = new MultivaluedHashMap<String, Object>();
        for (String key : headers.keySet()) {
            List<String> values = headers.get(key);
            for (String value : values) {
                ret.add(key, value);
            }
        }
        return ret;
    }
}

