/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ca.core.rest.client;

import com.ibm.bi.common.exceptions.cqe.catalogs.CQEError;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.rest.RESTClient;
import com.ibm.bi.rest.RESTClientConfig;
import com.ibm.bi.rest.RESTClientFactory;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.smarts.ca.core.rest.client.BIJaxrsResponse;
import com.ibm.smarts.ca.core.rest.client.BIRestClientConfigInfo;
import com.ibm.smarts.ca.core.rest.client.SmartsCaRestClientHelper;
import com.ibm.smarts.core.exceptions.InternalException;
import com.ibm.smarts.core.rest.client.RestClient;
import com.ibm.smarts.core.rest.client.util.JaxRs20Classes;
import com.ibm.smarts.core.rest.client.util.JaxRs20Exceptions;
import com.ibm.smarts.core.rest.client.util.JaxRs20Helper;
import com.ibm.smarts.core.rest.client.util.WrappedResponse;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.core.util.ToString;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;

public class BIRestCallContext<T>
extends RestClient.AbstractRestCallContext<T>
implements RestClient.RestCallContext<T> {
    private static final String TRUSTED_HEADER = "X-CA-Authorization";
    private final RESTClientFactory factory;
    private final RESTClientConfig clientConfig;
    private final BIRestClientConfigInfo biRestConfigInfo;
    private final String pathRoot;
    private final String trustedServiceId;

    public BIRestCallContext(RequestContext requestContext, Class<T> klass, RESTClientFactory factory, BIRestClientConfigInfo biRestConfigInfo, RestClient.MeasuredFuture<T> mf, String root, String path, RestClient.QueryParams params, MediaType mediaType, Map<String, List<String>> headers, Map<String, NewCookie> setCookies) {
        this(requestContext, klass, factory, biRestConfigInfo, mf, root, path, params, mediaType, headers, setCookies, null);
    }

    public BIRestCallContext(RequestContext requestContext, Class<T> klass, RESTClientFactory factory, BIRestClientConfigInfo biRestConfigInfo, RestClient.MeasuredFuture<T> mf, String root, String path, RestClient.QueryParams params, MediaType mediaType, Map<String, List<String>> headers, Map<String, NewCookie> setCookies, String trustedServiceId) {
        super(requestContext, klass, mf, root, path, params, mediaType, headers, setCookies);
        this.factory = factory;
        this.trustedServiceId = trustedServiceId;
        this.biRestConfigInfo = biRestConfigInfo;
        this.clientConfig = SmartsCaRestClientHelper.buildRESTClientConfig(requestContext, headers);
        Collection configHeaders = this.clientConfig.getRequestHeaders();
        for (Header configHeader : configHeaders) {
            String name = configHeader.getName();
            if (headers.containsKey(name)) continue;
            String value = configHeader.getValue();
            List<String> ourValue = headers.get(name);
            if (ourValue == null) {
                ourValue = new ArrayList<String>();
                headers.put(name, ourValue);
            }
            ourValue.add(value);
        }
        String proot = "";
        try {
            URL url = new URL(root);
            String protocol = url.getProtocol();
            String host = url.getHost();
            int port = url.getPort();
            URL shortUrl = new URL(protocol, host, port, "");
            String shortRoot = shortUrl.toString();
            proot = root.substring(shortRoot.length());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            throw new InternalException((Throwable)e, "Building URL from '" + root + "'", new Object[0]);
        }
        this.pathRoot = proot;
    }

    public String buildPath(String path) {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return super.buildPath(this.pathRoot + path);
    }

    private Future<T> executeCall(String verb, JaxRs20Classes.InvocationCallback<T> callback, RestExecutor func) {
        return this.executeCall(verb, callback, null, func);
    }

    private Future<T> executeCall(String verb, JaxRs20Classes.InvocationCallback<T> callback, String trustedServiceOverride, RestExecutor func) {
        return this.executeCall(verb, callback, trustedServiceOverride, func, "");
    }

    private Future<T> executeCall(String verb, final JaxRs20Classes.InvocationCallback<T> callback, String trustedServiceOverride, final RestExecutor func, String callBody) {
        this.verb = verb;
        this.reportCall(callBody);
        final String useTrustedServiceId = trustedServiceOverride == null ? this.trustedServiceId : trustedServiceOverride;
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                RESTClient client = null;
                try {
                    boolean trustWorked = false;
                    client = BIRestCallContext.this.factory.getClient(BIRestCallContext.this.clientConfig);
                    if (useTrustedServiceId != null) {
                        trustWorked = client.makeTrusted(useTrustedServiceId);
                        if (trustWorked) {
                            Header trustedHeader = BIRestCallContext.this.clientConfig.getRequestHeader(BIRestCallContext.TRUSTED_HEADER);
                            if (trustedHeader != null) {
                                String trustedHeaderValue = trustedHeader.getValue();
                                BIRestCallContext.this.setHeader(BIRestCallContext.TRUSTED_HEADER, trustedHeaderValue);
                            }
                        } else {
                            throw new InternalException("Failed to make trusted: " + useTrustedServiceId, new Object[0]);
                        }
                    }
                    int status = func.apply(client);
                    Object object = null;
                    try {
                        object = BIRestCallContext.this.buildResponseObject(status, client);
                        callback.completed(object);
                    }
                    catch (Exception e) {
                        callback.failed((Throwable)e);
                    }
                }
                catch (Exception e2) {
                    callback.failed((Throwable)e2);
                }
                finally {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        };
        runnable.run();
        return this.mf;
    }

    public Future<T> get(JaxRs20Classes.InvocationCallback<T> callback) {
        return this.executeCall("GET", callback, client -> client.getResource(this.buildPath(this.path)));
    }

    public Future<T> get(JaxRs20Classes.InvocationCallback<T> callback, String trustedServiceId) {
        return this.executeCall("GET", callback, trustedServiceId, client -> client.getResource(this.buildPath(this.path)));
    }

    public Future<T> put(JaxRs20Classes.Entity<?> entity, JaxRs20Classes.InvocationCallback<T> callback) {
        return this.put(entity, callback, null);
    }

    public Future<T> put(JaxRs20Classes.Entity<?> entity, JaxRs20Classes.InvocationCallback<T> callback, String trustedServiceId) {
        return this.executeCall("PUT", callback, trustedServiceId, client -> {
            Object item = entity.getEntity();
            if (item != null) {
                if (item instanceof InputStream) {
                    InputStream is = (InputStream)item;
                    return client.updateResource(this.buildPath(this.path), this.mediaType.toString(), -1L, is);
                }
                if (!(item instanceof String)) throw new InternalException("Unexpected entity in PUT: class=" + entity.getClass().getName() + " entity=" + entity, new Object[0]);
                String json = (String)item;
                JsonObject jsonObject = JsonObject.parseString((String)json, (boolean)true);
                return client.updateResource(this.buildPath(this.path), this.mediaType.toString(), jsonObject);
            }
            String json = "{}";
            JsonObject jsonObject = JsonObject.parseString((String)"{}", (boolean)true);
            return client.updateResource(this.buildPath(this.path), this.mediaType.toString(), jsonObject);
        });
    }

    public Future<T> post(JaxRs20Classes.Entity<?> entity, JaxRs20Classes.InvocationCallback<T> callback) {
        Object item = entity.getEntity();
        String body = item != null ? item.toString() : "";
        return this.executeCall("POST", callback, null, client -> this.handlerFunc(entity, client), body);
    }

    public Future<T> post(JaxRs20Classes.Entity<?> entity, JaxRs20Classes.InvocationCallback<T> callback, String trustedServiceId) {
        Object item = entity.getEntity();
        String body = item != null ? item.toString() : "";
        return this.executeCall("POST", callback, trustedServiceId, client -> this.handlerFunc(entity, client), body);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int handlerFunc(JaxRs20Classes.Entity<?> entity, RESTClient client) throws IOException {
        Object item = entity.getEntity();
        if (item != null) {
            if (item instanceof InputStream) {
                InputStream is = (InputStream)item;
                return client.createResource(this.buildPath(this.path), this.mediaType.toString(), -1L, is);
            }
            if (item instanceof String) {
                String json = (String)item;
                JsonObject jsonObject = JsonObject.parseString((String)json, (boolean)true);
                return client.createResource(this.buildPath(this.path), this.mediaType.toString(), jsonObject);
            }
            if (!(item instanceof HttpEntity)) throw new InternalException("Unexpected entity in POST: class=" + entity.getClass().getName() + " entity=" + entity, new Object[0]);
            return client.createResource(this.buildPath(this.path), (HttpEntity)item);
        }
        String json = "{}";
        JsonObject jsonObject = JsonObject.parseString((String)"{}", (boolean)true);
        return client.createResource(this.buildPath(this.path), this.mediaType.toString(), jsonObject);
    }

    public Future<T> delete(JaxRs20Classes.InvocationCallback<T> callback) {
        return this.delete(callback, null);
    }

    public Future<T> delete(JaxRs20Classes.InvocationCallback<T> callback, String trustedServiceId) {
        return this.executeCall("DELETE", callback, trustedServiceId, client -> {
            int status = client.deleteResource(this.buildPath(this.path), this.mediaType.toString());
            return status;
        });
    }

    private T buildResponseObject(int status, RESTClient client) throws Exception {
        boolean isOkStatus;
        T result = null;
        WrappedResponse<BIJaxrsResponse, ?> wrappedResponse = this.buildBIResponse(status, client);
        BIJaxrsResponse response = (BIJaxrsResponse)wrappedResponse.delegate;
        Response.StatusType statusType = response.getStatusInfo();
        boolean bl = statusType == null ? false : (isOkStatus = statusType.getFamily() == Response.Status.Family.SUCCESSFUL);
        if (this.klass == Response.class) {
            result = this.klass.cast(wrappedResponse);
        } else if (isOkStatus) {
            result = response.readEntity(this.klass);
        } else {
            JaxRs20Exceptions.ProcessingException processingException = this.buildException(response);
            throw processingException;
        }
        return result;
    }

    public JaxRs20Exceptions.ProcessingException buildException(Response resp) {
        JaxRs20Exceptions.ProcessingException ret = this.convertToException(resp);
        return ret;
    }

    private JaxRs20Exceptions.ProcessingException convertToException(Response response) {
        try {
            WebApplicationException webAppException;
            int statusCode = response.getStatus();
            Response.Status status = Response.Status.fromStatusCode((int)statusCode);
            Response.Status.Family statusFamily = JaxRs20Helper.familyForStatus((int)statusCode);
            StringBuilder sb = new StringBuilder();
            sb.append(statusCode);
            sb.append(" ");
            sb.append(" [REST call " + this.instanceNumber + "] ");
            sb.append(this.getRestUri());
            sb.append(" headers=" + ToString.valueString((Object)this.headers));
            sb.append(" setCookies=" + ToString.valueString((Object)this.setCookies));
            sb.append(" body=" + ToString.valueString((Object)response.getEntity()));
            String messageDetails = sb.toString();
            if (status == null) {
                webAppException = this.createExceptionForFamily(messageDetails, response, statusFamily);
            } else {
                int METHOD_NOT_ALLOWED = 405;
                if (statusCode == 405) {
                    webAppException = new JaxRs20Exceptions.NotAllowedException(messageDetails, response);
                } else {
                    switch (status) {
                        case BAD_REQUEST: {
                            webAppException = new JaxRs20Exceptions.BadRequestException(messageDetails, response);
                            break;
                        }
                        case UNAUTHORIZED: {
                            webAppException = new JaxRs20Exceptions.NotAuthorizedException(messageDetails, response);
                            break;
                        }
                        case FORBIDDEN: {
                            webAppException = this.createForbiddenOrDataSourceException(messageDetails, response);
                            break;
                        }
                        case NOT_FOUND: {
                            webAppException = new JaxRs20Exceptions.NotFoundException(messageDetails, response);
                            break;
                        }
                        case NOT_ACCEPTABLE: {
                            webAppException = new JaxRs20Exceptions.NotAcceptableException(messageDetails, response);
                            break;
                        }
                        case PRECONDITION_FAILED: {
                            webAppException = this.createPreconditionFailedOrDataSourceException(messageDetails, response);
                            break;
                        }
                        case UNSUPPORTED_MEDIA_TYPE: {
                            webAppException = new JaxRs20Exceptions.NotSupportedException(messageDetails, response);
                            break;
                        }
                        case INTERNAL_SERVER_ERROR: {
                            webAppException = new JaxRs20Exceptions.InternalServerErrorException(messageDetails, response);
                            break;
                        }
                        case SERVICE_UNAVAILABLE: {
                            webAppException = new JaxRs20Exceptions.ServiceUnavailableException(messageDetails, response);
                            break;
                        }
                        default: {
                            webAppException = this.createExceptionForFamily(messageDetails, response, statusFamily);
                        }
                    }
                }
            }
            return new JaxRs20Exceptions.ResponseProcessingException(response, messageDetails, (Throwable)webAppException);
        }
        catch (Throwable t) {
            return new JaxRs20Exceptions.ResponseProcessingException(response, t);
        }
    }

    private WebApplicationException createForbiddenOrDataSourceException(String messageDetails, Response response) {
        String dataSourceErrorCode = this.getDataSourceExceptionErrorCode(response);
        if (this.isAmbiguousConnectionFault(dataSourceErrorCode)) {
            return new JaxRs20Exceptions.DataSourceException(messageDetails, response, false);
        }
        return new JaxRs20Exceptions.ForbiddenException(messageDetails, response);
    }

    private WebApplicationException createPreconditionFailedOrDataSourceException(String messageDetails, Response response) {
        String dataSourceErrorCode = this.getDataSourceExceptionErrorCode(response);
        if (this.isPromptFault(dataSourceErrorCode)) {
            return new JaxRs20Exceptions.DataSourceException(messageDetails, response, true);
        }
        return new JaxRs20Exceptions.PreconditionFailedException(messageDetails, response);
    }

    private String getDataSourceExceptionErrorCode(Response response) {
        String errorCode = "";
        String body = (String)response.getEntity();
        try {
            JSONObject json = JSONObject.parse((String)body);
            JSONArray errors = (JSONArray)json.get((Object)"errors");
            if (errors != null && !errors.isEmpty()) {
                JSONObject error = (JSONObject)errors.get(0);
                errorCode = (String)error.get((Object)"code");
            }
        }
        catch (IOException e) {
            return errorCode;
        }
        return errorCode;
    }

    private boolean isAmbiguousConnectionFault(String code) {
        return code.equals(CQEError.DS_AmbiguousConnection.getErrorCode()) || code.equals(CQEError.DS_AmbiguousSignon.getErrorCode()) || code.equals(CQEError.DS_DataSourceLogonFailure.getErrorCode());
    }

    private boolean isPromptFault(String code) {
        return code.equals("QF-888");
    }

    private WebApplicationException createExceptionForFamily(String message, Response response, Response.Status.Family statusFamily) {
        JaxRs20Exceptions.LocalWebApplicationException webAppException;
        if (statusFamily != null) {
            switch (statusFamily) {
                case REDIRECTION: {
                    webAppException = new JaxRs20Exceptions.RedirectionException(message, response);
                    break;
                }
                case CLIENT_ERROR: {
                    webAppException = new JaxRs20Exceptions.ClientErrorException(message, response);
                    break;
                }
                case SERVER_ERROR: {
                    webAppException = new JaxRs20Exceptions.ServerErrorException(message, response);
                    break;
                }
                default: {
                    webAppException = new JaxRs20Exceptions.LocalWebApplicationException(message, response);
                    break;
                }
            }
        } else {
            webAppException = new JaxRs20Exceptions.LocalWebApplicationException(message, response);
        }
        return webAppException;
    }

    private WrappedResponse<BIJaxrsResponse, ?> buildBIResponse(int status, RESTClient client) {
        Header[] respHeaders = client.getResponseHeaders();
        InputStream respStream = null;
        String respBody = null;
        try {
            respStream = client.getResponseStream();
            if (respStream != null) {
                respBody = IOUtils.toString((InputStream)respStream, (Charset)StandardCharsets.UTF_8);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (respStream != null && respStream != null) {
            try {
                respStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        if (respHeaders != null) {
            for (Header h : respHeaders) {
                String name = h.getName();
                if (!headers.containsKey(name)) {
                    headers.put(name, new ArrayList());
                }
                List values = (List)headers.get(name);
                String value = h.getValue();
                values.add(value);
                headers.put(name, values);
            }
        }
        BIJaxrsResponse biResp = new BIJaxrsResponse(status, headers, respBody);
        WrappedResponse ret = new WrappedResponse((Response)biResp, (RestClient.RestCallContext)this);
        return ret;
    }

    public String toString() {
        return ToString.with((Object)((Object)this)).field("biRestConfig", (Object)this.biRestConfigInfo).field(TRUSTED_HEADER, this.headers.get(TRUSTED_HEADER)).get();
    }

    private static interface RestExecutor {
        public int apply(RESTClient var1) throws Exception;
    }
}

