/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ca.core.rest.client;

import com.ibm.bi.rest.RESTClientConfig;
import com.ibm.bi.rest.RESTClientFactory;
import com.ibm.smarts.ca.core.rest.client.BIRestCallContextFactory;
import com.ibm.smarts.ca.core.rest.client.BIRestClientConfigInfo;
import com.ibm.smarts.ca.core.rest.util.ThrowingHttpServletRequest;
import com.ibm.smarts.core.rest.client.RestClient;
import com.ibm.smarts.core.util.RequestContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class SmartsCaRestClientHelper {
    private static final String REST_CLIENT_INFO_KEY = "com.ibm.smarts.restClientConfigInfo";
    public static final String SERVLETCONTEXT = "ServletContext";

    public static void setConfigIntoRequestContext(BIRestClientConfigInfo config, RequestContext rc) {
        rc.setRequestAttribute(REST_CLIENT_INFO_KEY, (Object)config);
    }

    public static BIRestClientConfigInfo getConfigFromRequestContext(RequestContext rc) {
        BIRestClientConfigInfo ret = (BIRestClientConfigInfo)rc.getRequestAttribute(REST_CLIENT_INFO_KEY);
        return ret;
    }

    public static RestClient.RestCallContextFactory buildRccf(BIRestClientConfigInfo config) {
        RESTClientFactory.getInstance().startup();
        return new BIRestCallContextFactory(config);
    }

    public static RestClient.RestCallContextFactory injectRCCF(RequestContext rc) {
        BIRestClientConfigInfo ci = SmartsCaRestClientHelper.getConfigFromRequestContext(rc);
        RestClient.RestCallContextFactory rccf = SmartsCaRestClientHelper.buildRccf(ci);
        rc.setAttribute("com.ibm.smarts.rest.restCallContextFactory", (Object)rccf);
        return rccf;
    }

    public static BIRestClientConfigInfo from(HttpServletRequest sr) {
        String contextPath = sr.getContextPath();
        String scheme = sr.getScheme();
        String server = sr.getLocalName();
        int port = sr.getLocalPort();
        Map<String, List<String>> headers = SmartsCaRestClientHelper.buildHeaderMap(sr);
        BIRestClientConfigInfo ret = new BIRestClientConfigInfo(contextPath, scheme, server, port, headers);
        return ret;
    }

    private static Map<String, List<String>> buildHeaderMap(HttpServletRequest sr) {
        HashMap<String, List<String>> ret = new HashMap<String, List<String>>();
        Enumeration iterNames = sr.getHeaderNames();
        while (iterNames.hasMoreElements()) {
            String name = (String)iterNames.nextElement();
            ArrayList<String> values = new ArrayList<String>();
            ret.put(name, values);
            Enumeration iterValues = sr.getHeaders(name);
            while (iterValues.hasMoreElements()) {
                String value = (String)iterValues.nextElement();
                values.add(value);
            }
        }
        return ret;
    }

    public static RestClient.RestCallContextFactory injectRCCF(RequestContext rc, HttpServletRequest req) {
        BIRestClientConfigInfo biConfig = SmartsCaRestClientHelper.from(req);
        SmartsCaRestClientHelper.setConfigIntoRequestContext(biConfig, rc);
        rc.setAttribute(SERVLETCONTEXT, (Object)req.getServletContext());
        return SmartsCaRestClientHelper.injectRCCF(rc);
    }

    public static RESTClientConfig buildRESTClientConfig(final RequestContext rc, Map<String, List<String>> headers) {
        RESTClientConfig ret;
        final BIRestClientConfigInfo biConfig = SmartsCaRestClientHelper.getConfigFromRequestContext(rc);
        Map<String, List<String>> configHeaders = biConfig == null ? null : biConfig.headers;
        final Map<String, List<String>> combinedHeaders = SmartsCaRestClientHelper.combineHeaders(configHeaders, headers);
        ThrowingHttpServletRequest mockRequest = new ThrowingHttpServletRequest(){

            @Override
            public String getHeader(String name) {
                Map hdrs;
                List values;
                if (combinedHeaders != null && (values = (List)(hdrs = combinedHeaders).get(name)) != null && values.size() > 0) {
                    return (String)values.get(0);
                }
                return null;
            }

            @Override
            public Enumeration<String> getHeaders(String name) {
                ArrayList values = combinedHeaders != null ? (List)combinedHeaders.get(name) : new ArrayList();
                Enumeration<String> ret = Collections.enumeration(values);
                return ret;
            }

            @Override
            public Enumeration<String> getHeaderNames() {
                Map hdrs = combinedHeaders != null ? combinedHeaders : new HashMap();
                Enumeration<String> ret = Collections.enumeration(hdrs.keySet());
                return ret;
            }

            @Override
            public String getContextPath() {
                return biConfig.context.length() > 0 ? biConfig.context : "/";
            }

            @Override
            public String getLocalName() {
                return biConfig.server;
            }

            @Override
            public int getLocalPort() {
                return biConfig.port;
            }

            @Override
            public String getScheme() {
                return biConfig.scheme;
            }

            @Override
            public Object getAttribute(String name) {
                return null;
            }

            @Override
            public Enumeration<String> getAttributeNames() {
                return Collections.emptyEnumeration();
            }

            @Override
            public Cookie[] getCookies() {
                return new Cookie[0];
            }

            @Override
            public ServletContext getServletContext() {
                return (ServletContext)rc.getAttribute(SmartsCaRestClientHelper.SERVLETCONTEXT);
            }
        };
        RESTClientConfig rESTClientConfig = ret = biConfig == null ? new RESTClientConfig() : new RESTClientConfig((HttpServletRequest)mockRequest);
        if (configHeaders != null && configHeaders.containsKey("Cookie")) {
            List<String> cookieList = configHeaders.get("Cookie");
            ret.setRequestHeader("Cookie", cookieList.get(0));
        }
        return ret;
    }

    private static Map<String, List<String>> combineHeaders(Map<String, List<String>> left, Map<String, List<String>> right) {
        List<String> oldValues;
        List<String> newValues;
        String newName;
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        HashMap<String, List<String>> ret = new HashMap<String, List<String>>();
        Iterator<String> iterator = left.keySet().iterator();
        while (iterator.hasNext()) {
            String name;
            newName = name = iterator.next();
            newValues = new ArrayList();
            oldValues = left.get(name);
            for (String value : oldValues) {
                newValues.add(value);
            }
            ret.put(newName, newValues);
        }
        for (String name : right.keySet()) {
            newName = name;
            if (ret.containsKey(newName)) {
                newValues = (List)ret.get(newName);
            } else {
                newValues = new ArrayList();
                ret.put(newName, newValues);
            }
            oldValues = right.get(name);
            for (String value : oldValues) {
                if (newValues.contains(value)) continue;
                newValues.add(value);
            }
        }
        return ret;
    }
}

