/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.conversation.nlu;

import com.ibm.smarts.conversation.nlu.ConversationNLUResponse;
import com.ibm.smarts.conversation.nlu.LockSentenceProcessor;
import com.ibm.smarts.conversation.nlu.SkillAction;
import com.ibm.smarts.conversation.nlu.schema.entity.Entity;
import com.ibm.smarts.conversation.nlu.schema.intent.Intent;
import com.ibm.smarts.conversation.nlu.skills.EntityClassifier;
import com.ibm.smarts.conversation.nlu.skills.ISystemIntentHandlersRegistrar;
import com.ibm.smarts.conversation.nlu.skills.IntentClassifier;
import com.ibm.smarts.conversation.nlu.skills.Skill;
import com.ibm.smarts.conversation.nlu.skills.SkillsManager;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConversationNLU {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConversationNLU.class);
    private static final String IGNORED_NEGATIVE_INTENT = "negative_intent";
    private SkillsManager skillsManager;
    private LockSentenceProcessor lockSentenceProcessor;

    public ConversationNLU(Properties config, ISystemIntentHandlersRegistrar systemRegistrar) {
        Path configPath = Paths.get(config.getProperty("smarts.core.configFolder"), "conversation");
        Path skillsPath = configPath.resolve("skills");
        String tempPath = config.getProperty("smarts.core.tempFolder");
        ArrayList<String> disabledSkills = new ArrayList<String>();
        String disabledSkillsProp = config.getProperty("smarts.conversation.disabledSkills");
        if (disabledSkillsProp != null && !StringUtils.isBlank((CharSequence)disabledSkillsProp)) {
            disabledSkills.addAll(Arrays.asList(disabledSkillsProp.split(",")));
        }
        String defaultSkill = config.getProperty("smarts.conversation.defaultSkill");
        this.init(configPath.toString(), skillsPath.toString(), tempPath, systemRegistrar, disabledSkills, defaultSkill);
    }

    public ConversationNLU(String conversationConfigPath, String skillsPath, String tempPath, ISystemIntentHandlersRegistrar systemRegistrar) {
        this.init(conversationConfigPath, skillsPath, tempPath, systemRegistrar, Collections.emptyList(), "");
    }

    private void init(String conversationConfigPath, String skillsPath, String tempPath, ISystemIntentHandlersRegistrar systemRegistrar, List<String> disabledSkills, String defaultSkill) {
        long startTime = System.currentTimeMillis();
        this.skillsManager = new SkillsManager(conversationConfigPath, skillsPath, tempPath, systemRegistrar, disabledSkills, defaultSkill);
        this.lockSentenceProcessor = new LockSentenceProcessor(this.skillsManager);
        long timeSpent = System.currentTimeMillis() - startTime;
        LOGGER.debug("initialize time: {}", (Object)timeSpent);
    }

    public SkillAction getSkillLockAction(String sentence) {
        return this.lockSentenceProcessor.getSkillAction(sentence);
    }

    public ConversationNLUResponse tagSentence(String sentence, String skillId) {
        return this.classify(sentence, skillId);
    }

    public ConversationNLUResponse tagSentence(String sentence) {
        return this.tagSentence(sentence, this.skillsManager.getSystemSkillId());
    }

    public ConversationNLUResponse buildFromIntent(String skillId, String intent, String sentence) {
        ArrayList<Intent> intentList = new ArrayList<Intent>();
        intentList.add(new Intent(intent, 100.0));
        ConversationNLUResponse response = new ConversationNLUResponse();
        response.setSentence(sentence);
        response.setSelectedIntent((Intent)intentList.get(0));
        response.setIntentList(intentList);
        response.setSkillId(skillId);
        List<Entity> entities = this.classifyEntities(sentence, this.skillsManager.getSkillById(skillId).getEntityClassifier());
        response.setEntities(entities);
        return response;
    }

    public ConversationNLUResponse classify(String sentence) {
        return this.classify(sentence, this.skillsManager.getSystemSkillId());
    }

    public ConversationNLUResponse classify(String sentence, String skillId) {
        Skill skill = this.skillsManager.getSkillById(skillId);
        List<Intent> intents = this.classifyIntent(sentence, skill.getIntentClassifier());
        List<Entity> entities = this.classifyEntities(sentence, skill.getEntityClassifier());
        return this.constructNLUResponse(sentence, intents, entities, skillId);
    }

    private ConversationNLUResponse constructNLUResponse(String sentence, List<Intent> intents, List<Entity> entities, String skillId) {
        ConversationNLUResponse response = new ConversationNLUResponse();
        response.setSentence(sentence);
        if (!intents.isEmpty()) {
            response.setSelectedIntent(intents.get(0));
            response.setIntentList(intents);
        }
        response.setEntities(entities);
        response.setSkillId(skillId);
        return response;
    }

    private void removeNegativeIntent(List<Intent> intents) {
        Iterator<Intent> it = intents.iterator();
        while (it.hasNext()) {
            if (!IGNORED_NEGATIVE_INTENT.equals(it.next().getId())) continue;
            it.remove();
            break;
        }
    }

    private List<Intent> classifyIntent(String sentence, IntentClassifier intentClassifier) {
        List<Intent> classifierIntentList = intentClassifier.classify(sentence);
        this.removeNegativeIntent(classifierIntentList);
        Collections.sort(classifierIntentList);
        return classifierIntentList;
    }

    private List<Entity> classifyEntities(String sentence, EntityClassifier classifier) {
        if (classifier != null) {
            return classifier.classify(sentence);
        }
        return Collections.emptyList();
    }

    public SkillsManager getSkillsManager() {
        return this.skillsManager;
    }
}

