/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.conversation.nlu;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.smarts.conversation.nlu.schema.entity.Entity;
import com.ibm.smarts.conversation.nlu.schema.intent.Intent;
import java.util.ArrayList;
import java.util.List;

public class ConversationNLUResponse {
    private List<Entity> entities = new ArrayList<Entity>();
    private List<Intent> intents = new ArrayList<Intent>();
    private String sentence;
    private Intent selectedIntent;
    private String skillId = "";

    public ConversationNLUResponse() {
    }

    public ConversationNLUResponse(List<Entity> entities, String sentence, Intent selectedIntent) {
        this.entities = entities;
        this.sentence = sentence;
        this.selectedIntent = selectedIntent;
    }

    public void setSelectedIntent(Intent intent) {
        this.selectedIntent = intent;
    }

    public void setIntentList(List<Intent> intentList) {
        this.intents = intentList;
    }

    public void setSentence(String sentence) {
        this.sentence = sentence;
    }

    public void setEntities(List<Entity> entities) {
        this.entities = entities;
    }

    public String getSentence() {
        return this.sentence;
    }

    public List<Entity> getEntities() {
        return this.entities;
    }

    public List<Intent> getIntents() {
        return this.intents;
    }

    public Intent getSelectedIntent() {
        return this.selectedIntent;
    }

    public String getSkillId() {
        return this.skillId;
    }

    public void setSkillId(String skillId) {
        this.skillId = skillId;
    }

    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        JSONArray entityArray = new JSONArray();
        if (this.entities != null) {
            for (Entity entity : this.entities) {
                entityArray.add((Object)entity.toJSON());
            }
            json.put((Object)"entities", (Object)entityArray);
        }
        JSONArray intentArray = new JSONArray();
        if (this.intents != null) {
            for (Intent intent : this.intents) {
                intentArray.add((Object)intent.toJSON());
            }
            json.put((Object)"intent_ranking", (Object)intentArray);
        }
        json.put((Object)"text", (Object)this.sentence);
        if (this.selectedIntent != null) {
            json.put((Object)"intent", (Object)this.selectedIntent.toJSON());
        }
        return json;
    }
}

