/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.conversation.nlu;

import com.ibm.smarts.conversation.nlu.SkillAction;
import com.ibm.smarts.conversation.nlu.SkillActionEnum;
import com.ibm.smarts.conversation.nlu.skills.Skill;
import com.ibm.smarts.conversation.nlu.skills.SkillsManager;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class LockSentenceProcessor {
    private Pattern lockRegex;
    private Pattern skillsRegex;
    private Pattern directRegex;
    private static final String[] unlockWords = new String[]{"goodbye", "good bye", "stop", "off", "exit"};
    private static final String[] lockPrefixWords = new String[]{"lock", "use", "default", "start", "begin", "talk to"};
    private static final String[] directPrefixWords = new String[]{"ask", "tell", "open", "talk to", "launch", "use", "start"};
    private static final String[] connectingWords = new String[]{"from", "about", "to", ":", ",", "for"};
    private SkillsManager skillsManager;

    public LockSentenceProcessor(SkillsManager skillsManager) {
        this.skillsManager = skillsManager;
        this.buildSkillMatchingExpressions();
    }

    private void buildSkillMatchingExpressions() {
        List escapedActivationPhrases = this.skillsManager.getAllActivationPhrases().stream().map(f -> Pattern.quote(f)).collect(Collectors.toList());
        this.skillsRegex = Pattern.compile("(" + String.join((CharSequence)"|", escapedActivationPhrases) + ")", 2);
        this.lockRegex = Pattern.compile("^(" + String.join((CharSequence)"|", lockPrefixWords) + ") " + this.skillsRegex + "$", 2);
        this.directRegex = Pattern.compile("^\\s*(" + String.join((CharSequence)"|", directPrefixWords) + ")\\s*" + this.skillsRegex + "\\s*(" + String.join((CharSequence)"|", connectingWords) + ")?\\s*?(.*)", 2);
    }

    public SkillAction getSkillAction(String sentence) {
        for (String ex : this.skillsManager.getAllActivationPhrases()) {
            if (!sentence.equalsIgnoreCase(ex)) continue;
            return new SkillAction(SkillActionEnum.LOCK_SKILL, sentence, sentence, null, this.getSkillIdByActivationPhrase(ex));
        }
        Matcher lockMatcher = this.lockRegex.matcher(sentence);
        if (lockMatcher.matches()) {
            String activationPhrase = lockMatcher.group(2);
            return new SkillAction(SkillActionEnum.LOCK_SKILL, activationPhrase, sentence, null, this.getSkillIdByActivationPhrase(activationPhrase));
        }
        Matcher directMatcher = this.directRegex.matcher(sentence);
        if (directMatcher.matches()) {
            String activationPhrase = directMatcher.group(2);
            return new SkillAction(SkillActionEnum.DIRECT_TO_SKILL, activationPhrase, sentence, directMatcher.group(4).trim(), this.getSkillIdByActivationPhrase(activationPhrase));
        }
        for (String s : unlockWords) {
            if (!s.equals(sentence)) continue;
            return new SkillAction(SkillActionEnum.UNLOCK_SKILL, null, sentence, null, null);
        }
        return new SkillAction(SkillActionEnum.DEFAULT, null, sentence, sentence, null);
    }

    private String getSkillIdByActivationPhrase(String activationPhrase) {
        Skill skill = this.skillsManager.getSkillByActivationPhrase(activationPhrase);
        if (skill != null) {
            return skill.getId();
        }
        return null;
    }
}

