/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.conversation.nlu;

import com.ibm.smarts.conversation.nlu.ConversationNLU;
import com.ibm.smarts.conversation.nlu.ConversationNLUResponse;
import com.ibm.smarts.conversation.nlu.PreProcessor;
import com.ibm.smarts.conversation.nlu.SkillAction;
import com.ibm.smarts.conversation.nlu.skills.ISystemIntentHandlersRegistrar;
import com.ibm.smarts.conversation.nlu.skills.Skill;
import com.ibm.smarts.conversation.schema.provider.IConversationProvider;
import com.ibm.smarts.core.config.SmartsCoreProps;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.nlp.core.SmartNLPImpl;
import com.ibm.smarts.nlp.core.config.NLPProps;
import com.ibm.smarts.schema.TextInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NLUTagger {
    private static final Logger LOGGER = LoggerFactory.getLogger(NLUTagger.class);
    private static SmartNLPImpl nlp;
    private static ConversationNLU engine;
    private static List<String> INTENTS_NOT_REQUIRING_PROCESSING;

    private NLUTagger() {
    }

    public static void init(List<String> intentsNotRequiringProcessing) {
        INTENTS_NOT_REQUIRING_PROCESSING = intentsNotRequiringProcessing;
    }

    public static SkillAction getSkillLockAction(String sentence) {
        return engine.getSkillLockAction(sentence);
    }

    public static ConversationNLUResponse tagSentence(String sentence, List<String> clickParams, IConversationProvider provider, String skillId) {
        ConversationNLUResponse nluResponse = NLUTagger.getUnprocessedNluResponse(sentence, clickParams, skillId);
        return NLUTagger.processNLUresponse(nluResponse, provider);
    }

    private static ConversationNLUResponse processNLUresponse(ConversationNLUResponse nluResponse, IConversationProvider provider) {
        if (nluResponse != null) {
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Engine response: {}", (Object)nluResponse.toJSON().serialize(true));
                }
            }
            catch (IOException e) {
                LOGGER.error("Engine Response", (Throwable)e);
            }
            String selectedIntent = nluResponse.getSelectedIntent().getId();
            if (!INTENTS_NOT_REQUIRING_PROCESSING.contains(selectedIntent)) {
                PreProcessor.process(nluResponse, provider.getRequestContext());
            }
        }
        return nluResponse;
    }

    private static ConversationNLUResponse getUnprocessedNluResponse(String sentence, List<String> clickParams, String skillId) {
        ConversationNLU engine = NLUTagger.getNLUEngine();
        if (clickParams != null && !clickParams.isEmpty()) {
            return engine.buildFromIntent(skillId, clickParams.get(0), sentence);
        }
        return engine.tagSentence(sentence, skillId);
    }

    public static ConversationNLU getNLUEngine() {
        return engine;
    }

    public static void initializeNLUEngine(String uimaPath, String nlpPath, String skillsPath, String tempPath, ISystemIntentHandlersRegistrar systemRegistrar) {
        engine = new ConversationNLU(nlpPath, skillsPath, tempPath, systemRegistrar);
        NLUTagger.initializeNLP(uimaPath);
    }

    public static void initializeNLP(String configFolder) {
        Properties config = new Properties();
        Properties nlpConfig = NLPProps.getDefaultConfig();
        String tempFolder = config.getProperty("smarts.core.tempFolder", SmartsCoreProps.DEFAULT_TEMP_FOLDER);
        String nlpLibsFolder = tempFolder + nlpConfig.getProperty("smarts.nlp.libs.folder");
        String uimaDatapath = configFolder + nlpConfig.getProperty("smarts.nlp.uima.datapath");
        String uimaDescriptor = uimaDatapath + nlpConfig.getProperty("smarts.nlp.uima.descriptor");
        config.setProperty("smarts.nlp.libs.folder", nlpLibsFolder);
        config.setProperty("smarts.nlp.uima.datapath", uimaDatapath);
        config.setProperty("smarts.nlp.uima.descriptor", uimaDescriptor);
        nlp = new SmartNLPImpl(config, null);
        nlp.initialize(null);
    }

    public static List<TextInfo> describeNLP(RequestContext requestContext, String[] text) {
        return nlp.describeText(requestContext, text);
    }

    public static void initializeNLUEngine(Properties config, ISystemIntentHandlersRegistrar systemRegistrar) {
        engine = new ConversationNLU(config, systemRegistrar);
        NLUTagger.initializeNLP(config);
    }

    public static void initializeNLP(Properties config) {
        String configFolder = config.getProperty("smarts.core.configFolder", SmartsCoreProps.DEFAULT_CONFIG_FOLDER);
        Properties nlpConfig = NLPProps.getDefaultConfig();
        String tempFolder = config.getProperty("smarts.core.tempFolder", SmartsCoreProps.DEFAULT_TEMP_FOLDER);
        String nlpLibsFolder = tempFolder + nlpConfig.getProperty("smarts.nlp.libs.folder");
        String uimaDatapath = configFolder + nlpConfig.getProperty("smarts.nlp.uima.datapath");
        String uimaDescriptor = uimaDatapath + nlpConfig.getProperty("smarts.nlp.uima.descriptor");
        config.setProperty("smarts.nlp.libs.folder", nlpLibsFolder);
        config.setProperty("smarts.nlp.uima.datapath", uimaDatapath);
        config.setProperty("smarts.nlp.uima.descriptor", uimaDescriptor);
        nlp = new SmartNLPImpl(config, null);
        nlp.initialize(null);
    }

    public static Class<?> getIntentHandlerClass(String skillId, String intent) {
        Skill skill = engine.getSkillsManager().getSkillById(skillId);
        if (skill != null) {
            return skill.getIntentHandlerClass(intent);
        }
        LOGGER.error("Can't find a skill by id: {}", (Object)skillId);
        return null;
    }

    public static Class<?> getSentenceHandlerClass(String skillId) {
        Skill skill = engine.getSkillsManager().getSkillById(skillId);
        if (skill != null) {
            return skill.getSentenceHandlerClass();
        }
        LOGGER.error("Can't find a skill by id: {}", (Object)skillId);
        return null;
    }

    public static boolean hasIntentHandler(String extensionId, String intent) {
        Skill extension = engine.getSkillsManager().getSkillById(extensionId);
        return extension != null && extension.getIntentHandlerClass(intent) != null;
    }

    static {
        INTENTS_NOT_REQUIRING_PROCESSING = new ArrayList<String>();
    }
}

