/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.conversation.nlu;

import com.ibm.smarts.conversation.nlu.ConversationNLUResponse;
import com.ibm.smarts.conversation.nlu.NLUTagger;
import com.ibm.smarts.conversation.nlu.schema.entity.ColumnModifierEntity;
import com.ibm.smarts.conversation.nlu.schema.entity.Entity;
import com.ibm.smarts.conversation.nlu.schema.intent.Intent;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.schema.NLPMentionsEntity;
import com.ibm.smarts.schema.PhraseInfo;
import com.ibm.smarts.schema.TextInfo;
import com.ibm.smarts.schema.TokenInfo;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PreProcessor {
    private static Pattern numbersPattern = Pattern.compile("[+-]?(\\p{N}|\\.|,)+");

    private PreProcessor() {
    }

    public static void process(ConversationNLUResponse coreResponse, RequestContext requestContext) {
        List<Entity> allEntities = coreResponse.getEntities();
        ArrayList<Entity> collectedEntities = new ArrayList<Entity>();
        String sentence = coreResponse.getSentence();
        PreProcessor.processCRFEntities(allEntities, collectedEntities);
        List<Entity> numberEntities = PreProcessor.collectNumberEntities(sentence, requestContext);
        PreProcessor.processColumnModifiers(collectedEntities, numberEntities);
        PreProcessor.splitEntitiesWithIsolatedNumber(collectedEntities, numberEntities);
        PreProcessor.processEntityToIntentPairing(coreResponse.getSelectedIntent(), collectedEntities);
        PreProcessor.fixOpeningBracketsEntities(sentence, collectedEntities);
        allEntities.clear();
        allEntities.addAll(collectedEntities);
        allEntities.addAll(numberEntities);
    }

    private static void fixOpeningBracketsEntities(String sentence, List<Entity> collectedEntities, char openingBracket, char closingBracket) {
        for (int i = 0; i < collectedEntities.size(); ++i) {
            int closingBracketIndex;
            Entity entity = collectedEntities.get(i);
            String entityText = entity.getText();
            if (entityText.isEmpty() || entityText.charAt(entityText.length() - 1) != openingBracket || (closingBracketIndex = PreProcessor.findMatchingClosingBracket(sentence, (int)entity.getEnd(), openingBracket, closingBracket)) == -1) continue;
            boolean entityExpanded = false;
            Entity closingBracketEntity = PreProcessor.findEntityContainingIndex(collectedEntities, closingBracketIndex);
            if (closingBracketEntity == null) {
                entity.setEnd(closingBracketIndex + 1);
                entityExpanded = true;
            } else {
                entity.setEnd((int)closingBracketEntity.getEnd());
                entityExpanded = true;
            }
            if (!entityExpanded) continue;
            entity.setText(sentence.substring((int)entity.getStart(), (int)entity.getEnd()));
            for (int j = i + 1; j < collectedEntities.size(); ++j) {
                Entity otherEntity = collectedEntities.get(j);
                if (!entity.contains(otherEntity)) continue;
                collectedEntities.remove(j);
                --j;
            }
        }
    }

    private static void fixOpeningBracketsEntities(String sentence, List<Entity> collectedEntities) {
        PreProcessor.fixOpeningBracketsEntities(sentence, collectedEntities, '(', ')');
        PreProcessor.fixOpeningBracketsEntities(sentence, collectedEntities, '[', ']');
        PreProcessor.fixOpeningBracketsEntities(sentence, collectedEntities, '{', '}');
    }

    private static int findMatchingClosingBracket(String sentence, int startingFrom, char openingBracket, char closingBracket) {
        int stack = 0;
        for (int i = startingFrom; i < sentence.length(); ++i) {
            if (sentence.charAt(i) == openingBracket) {
                ++stack;
                continue;
            }
            if (sentence.charAt(i) != closingBracket) continue;
            if (stack == 0) {
                return i;
            }
            --stack;
        }
        return -1;
    }

    private static Entity findEntityContainingIndex(List<Entity> collectedEntities, int charIndex) {
        for (Entity entity : collectedEntities) {
            if ((long)charIndex < entity.getStart() || (long)charIndex >= entity.getEnd()) continue;
            return entity;
        }
        return null;
    }

    private static boolean isAllDigits(String text) {
        return text.chars().allMatch(Character::isDigit);
    }

    private static void splitEntitiesWithIsolatedNumber(List<Entity> collectedEntities, List<Entity> numberEntities) {
        block0: for (int i = 0; i < collectedEntities.size(); ++i) {
            Entity entity = collectedEntities.get(i);
            for (int j = 0; j < numberEntities.size(); ++j) {
                boolean rightOk;
                long entityStart;
                Entity numberEntity = numberEntities.get(j);
                if (!numberEntity.isNumber() || !PreProcessor.isAllDigits(numberEntity.getText()) || entity.equals((Object)numberEntity) || !entity.contains(numberEntity)) continue;
                long numberStart = numberEntity.getStart();
                boolean leftOk = numberStart == (entityStart = entity.getStart()) || entity.getText().charAt((int)(numberStart - 1L - entityStart)) == ' ';
                long numberEnd = numberEntity.getEnd();
                long entityEnd = entity.getEnd();
                boolean bl = rightOk = numberEnd == entityEnd || entity.getText().charAt((int)(numberEnd - entityStart)) == ' ';
                if (!leftOk || !rightOk) continue;
                if (numberStart > entityStart) {
                    String leftText = entity.getText().substring(0, (int)(numberStart - entityStart - 1L));
                    Entity leftEntity = new Entity(entity.getId(), leftText, entityStart, entityStart + (long)leftText.length(), "ner_nlp");
                    collectedEntities.add(leftEntity);
                }
                if (numberEnd < entityEnd) {
                    String rightText = entity.getText().substring((int)(numberEnd + 1L - entityStart));
                    Entity rightEntity = new Entity(entity.getId(), rightText, numberEnd + 1L, entityEnd, "ner_nlp");
                    collectedEntities.add(rightEntity);
                }
                numberEntity.setId("filter");
                collectedEntities.add(numberEntity);
                numberEntities.remove(j);
                collectedEntities.remove(i);
                --i;
                continue block0;
            }
        }
    }

    private static void processCRFEntities(List<Entity> allEntities, List<Entity> collectedEntities) {
        for (Entity entity : allEntities) {
            if (!entity.isExtractedByCRF()) continue;
            collectedEntities.add(entity);
        }
    }

    private static List<Entity> collectNumberEntities(String sentence, RequestContext requestContext) {
        List<Entity> numberEntities = PreProcessor.collectNumberEntitiesUsingRegex(sentence, requestContext);
        List<Entity> coreNlpNumberEntities = PreProcessor.collectNumberEntitiesUsingCoreNLP(sentence, requestContext);
        PreProcessor.removeContainedEntities(coreNlpNumberEntities, numberEntities);
        PreProcessor.removeContainedEntities(numberEntities, coreNlpNumberEntities);
        numberEntities.addAll(coreNlpNumberEntities);
        PreProcessor.removeUselessZeros(numberEntities);
        return numberEntities;
    }

    private static void removeUselessZeros(List<Entity> numberEntities) {
        for (Entity numberEntity : numberEntities) {
            int lastIndex;
            String value = (String)numberEntity.getValue();
            if (value.indexOf(46) == -1) continue;
            for (lastIndex = value.length() - 1; lastIndex >= 0 && value.charAt(lastIndex) == '0'; --lastIndex) {
            }
            if (value.charAt(lastIndex) == '.') {
                --lastIndex;
            }
            value = value.substring(0, lastIndex + 1);
            numberEntity.setValue(value);
        }
    }

    private static void removeContainedEntities(List<Entity> firstList, List<Entity> secondList) {
        if (firstList.isEmpty() || secondList.isEmpty()) {
            return;
        }
        for (int i = firstList.size() - 1; i >= 0; --i) {
            Entity entity = firstList.get(i);
            if (!PreProcessor.isContained(entity, secondList)) continue;
            firstList.remove(i);
        }
    }

    private static boolean isContained(Entity entity, List<Entity> numberEntities) {
        for (Entity listEntity : numberEntities) {
            if (!listEntity.contains(entity)) continue;
            return true;
        }
        return false;
    }

    private static List<Entity> collectNumberEntitiesUsingCoreNLP(String sentence, RequestContext requestContext) {
        ArrayList<Entity> numberEntities = new ArrayList<Entity>();
        List<TextInfo> texts = NLUTagger.describeNLP(requestContext, new String[]{sentence});
        if (!texts.isEmpty()) {
            for (PhraseInfo phrase : texts.get(0).getPhrases()) {
                for (NLPMentionsEntity nlpEntity : phrase.getEntities()) {
                    String value;
                    String entityType = nlpEntity.getType();
                    if (!entityType.equals("NUMBER") && !entityType.equals("PERCENT") || (value = nlpEntity.getNormalizedEntityTag()) == null || value.isEmpty()) continue;
                    int start = ((TokenInfo)phrase.getTokens().get(nlpEntity.getTokenBegin())).getCharOffsetBegin();
                    int end = ((TokenInfo)phrase.getTokens().get(nlpEntity.getTokenEnd() - 1)).getCharOffsetEnd();
                    if (start < 0 || end <= 0 || start >= end) continue;
                    String text = sentence.substring(start, end);
                    Entity entity = new Entity(entityType.equals("NUMBER") ? "number" : "percent", text, (long)start, (long)(start + text.length()), "ner_nlp");
                    if (value.length() > 1 && (value.startsWith(">") || value.startsWith("<") || value.startsWith("%"))) {
                        value = value.substring(1);
                    }
                    entity.setValue(value);
                    numberEntities.add(entity);
                }
            }
        }
        return numberEntities;
    }

    private static List<Entity> collectNumberEntitiesUsingRegex(String sentence, RequestContext requestContext) {
        ArrayList<Entity> numberEntities = new ArrayList<Entity>();
        NumberFormat format = NumberFormat.getInstance(requestContext.locale);
        Matcher m = numbersPattern.matcher(sentence);
        while (m.find()) {
            int start = m.start();
            int end = m.end();
            String text = sentence.substring(start, end);
            try {
                Number number = format.parse(text);
                Entity entity = new Entity("number", text, (long)start, (long)end, "ner_nlp");
                String value = number instanceof Float || number instanceof Double ? String.format(Locale.ENGLISH, "%f", number.doubleValue()) : String.format(Locale.ENGLISH, "%d", number.longValue());
                entity.setValue(value);
                PreProcessor.updateEntityNumberValue(entity, sentence);
                numberEntities.add(entity);
            }
            catch (ParseException parseException) {}
        }
        return numberEntities;
    }

    private static void updateEntityNumberValue(Entity entity, String sentence) {
        int end = (int)entity.getEnd();
        String text = entity.getText();
        if (end < sentence.length()) {
            char suffix = sentence.charAt(end);
            if (suffix == '%') {
                entity.setId("percent");
                entity.setEnd(end + 1);
            } else {
                int factor = 1;
                if (suffix == 'k' || suffix == 'K') {
                    factor = 1000;
                } else if (suffix == 'm' || suffix == 'M') {
                    factor = 1000000;
                }
                if (factor != 1) {
                    try {
                        int value = Integer.parseInt(text);
                        entity.setValue(Integer.toString(value * factor));
                        entity.setEnd(end + 1);
                    }
                    catch (NumberFormatException ex) {
                        try {
                            float value = Float.parseFloat(text);
                            entity.setValue(String.format("%f", Float.valueOf(value * (float)factor)));
                            entity.setEnd(end + 1);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }

    private static void processColumnModifiers(List<Entity> collectedEntities, List<Entity> numberEntities) {
        for (Entity entity : collectedEntities) {
            if (!entity.isColumnModifier()) continue;
            for (int i = 0; i < numberEntities.size(); ++i) {
                Entity numberEntity = numberEntities.get(i);
                if (!entity.contains(numberEntity)) continue;
                ColumnModifierEntity columnModifierEntity = (ColumnModifierEntity)entity;
                String value = numberEntity.getValue().toString();
                int dotIndex = value.indexOf(46);
                if (dotIndex != -1) {
                    value = value.substring(0, dotIndex);
                }
                columnModifierEntity.setLimit(value, numberEntity.isPercent());
                numberEntities.remove(i);
                --i;
            }
        }
    }

    protected static List<Entity> processEntityToIntentPairing(Intent selectedIntent, List<Entity> collectedEntities) {
        if (selectedIntent != null && selectedIntent.getId().equals("show")) {
            collectedEntities.stream().forEach(entity -> {
                if (entity.isSource()) {
                    entity.setId("column");
                }
            });
        }
        return collectedEntities;
    }
}

