/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.conversation.nlu.skills;

import com.ibm.smarts.conversation.nlu.schema.entity.Entity;
import com.ibm.smarts.conversation.nlu.schema.entity.EntityFactory;
import edu.stanford.nlp.ie.AbstractSequenceClassifier;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EntityClassifier {
    private AbstractSequenceClassifier<CoreLabel> classifier;
    private static final String OTHER_ENTITY = "O";
    private Map<String, String> entityInstanceOfMap = new HashMap<String, String>();

    public EntityClassifier(AbstractSequenceClassifier<CoreLabel> classifier) {
        this.classifier = classifier;
    }

    public EntityClassifier(AbstractSequenceClassifier<CoreLabel> classifier, Map<String, String> entityInstanceOfMap) {
        this.classifier = classifier;
        this.entityInstanceOfMap = entityInstanceOfMap;
    }

    public List<Entity> classify(String sentence) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        if (this.classifier != null) {
            List result = (List)this.classifier.classify(sentence).get(0);
            entities.addAll(this.collectEntities(result, "ner_crf", sentence));
        }
        return entities;
    }

    private Entity mergeItemsToEntity(List<CoreLabel> items, String entity, String extractor, String sentence) {
        int startIdx = items.get(0).beginPosition();
        int endIdx = items.get(items.size() - 1).endPosition();
        String value = sentence.substring(startIdx, endIdx);
        String instanceOf = this.entityInstanceOfMap.get(entity);
        return EntityFactory.createEntity((String)entity, (String)value.trim(), (long)startIdx, (long)endIdx, (String)extractor, (String)instanceOf);
    }

    private List<Entity> collectEntities(List<CoreLabel> result, String extractor, String sentence) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        ArrayList<CoreLabel> entityTokenList = new ArrayList<CoreLabel>();
        String previousAnnotation = "";
        for (int i = 0; i < result.size(); ++i) {
            CoreLabel coreLabel = result.get(i);
            String annotation = this.getAnnotation(coreLabel, extractor);
            if (!entityTokenList.isEmpty() && !annotation.equals(previousAnnotation)) {
                entities.add(this.mergeItemsToEntity(entityTokenList, previousAnnotation, extractor, sentence));
                entityTokenList.clear();
            }
            if (!annotation.equals(OTHER_ENTITY)) {
                entityTokenList.add(coreLabel);
            }
            previousAnnotation = annotation;
        }
        if (!entityTokenList.isEmpty()) {
            entities.add(this.mergeItemsToEntity(entityTokenList, previousAnnotation, extractor, sentence));
        }
        return entities;
    }

    private String getAnnotation(CoreLabel coreLabel, String extractor) {
        if (extractor.equalsIgnoreCase("ner_crf")) {
            return (String)coreLabel.get(CoreAnnotations.AnswerAnnotation.class);
        }
        return (String)coreLabel.get(CoreAnnotations.NamedEntityTagAnnotation.class);
    }
}

